/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.helpers.query.MDEQueries;
import org.polarsys.capella.common.menu.dynamic.CreationHelper;
import org.polarsys.capella.core.data.capellacommon.GenericTrace;
import org.polarsys.capella.core.data.capellacommon.TransfoLink;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.capellacore.Namespace;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.model.handler.helpers.HoldingResourceHelper;
import org.polarsys.capella.core.model.helpers.refmap.CapellaRefMap;
import org.polarsys.capella.core.model.helpers.refmap.KPair;
import org.polarsys.capella.core.model.helpers.refmap.VPair;
import org.polarsys.capella.core.tiger.ITransfo;
import org.polarsys.capella.core.tiger.TransfoException;
import org.polarsys.capella.core.tiger.helpers.Query;
import org.polarsys.capella.core.tiger.impl.TransfoEngine;

public class CapellaEngine
extends TransfoEngine {
    public static final String TRANSFO_TARGET_CONTAINER = "transfoTargetContainer";

    public CapellaEngine(Logger logger) {
        super(logger);
    }

    public CapellaEngine() {
    }

    public void doProcessDependingModels(List<EObject> dependingModels_p) throws TransfoException {
    }

    public void initialize(ITransfo transfo_p) throws TransfoException {
        super.initialize(transfo_p);
        ArrayList<TransfoLink> techLinks = new ArrayList<TransfoLink>();
        for (EObject src : this._agenda) {
            AbstractTrace trace = this.retrieveTransfoLink(src);
            if (trace == null || !(trace instanceof TransfoLink)) continue;
            techLinks.add((TransfoLink)trace);
        }
        ArrayList<TransfoLink> eltsToDelete = new ArrayList<TransfoLink>();
        EObject container = (EObject)transfo_p.get((Object)TRANSFO_TARGET_CONTAINER);
        Set links = MDEQueries.getInstance().getAllQueries().getAll(container, TransfoLink.class);
        for (EObject obj : links) {
            TransfoLink link = (TransfoLink)obj;
            TraceableElement src = link.getSourceElement();
            TraceableElement tgt = link.getTargetElement();
            if (src != null && tgt != null) continue;
            eltsToDelete.add(link);
        }
        for (TransfoLink link : eltsToDelete) {
            try {
                link.destroy();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        for (TransfoLink transfoLink : techLinks) {
            TraceableElement tgt;
            TraceableElement src = transfoLink.getSourceElement();
            if (this.isSemantiklyLinked(src, LaPackage.Literals.LOGICAL_COMPONENT, tgt = transfoLink.getTargetElement(), PaPackage.Literals.PHYSICAL_COMPONENT, CsPackage.Literals.COMPONENT_REALIZATION) && this.isSemantiklyLinked(src, FaPackage.Literals.COMPONENT_EXCHANGE, tgt, FaPackage.Literals.COMPONENT_EXCHANGE, FaPackage.Literals.COMPONENT_EXCHANGE_REALIZATION) && this.isSemantiklyLinked(src, FaPackage.Literals.FUNCTIONAL_EXCHANGE, tgt, FaPackage.Literals.FUNCTIONAL_EXCHANGE, FaPackage.Literals.FUNCTIONAL_EXCHANGE_REALIZATION) && this.isSemantiklyLinked(src, FaPackage.Literals.FUNCTIONAL_EXCHANGE, tgt, FaPackage.Literals.COMPONENT_EXCHANGE, FaPackage.Literals.COMPONENT_EXCHANGE_FUNCTIONAL_EXCHANGE_ALLOCATION) && this.isSemantiklyLinked(src, FaPackage.Literals.ABSTRACT_FUNCTION, tgt, FaPackage.Literals.ABSTRACT_FUNCTION, FaPackage.Literals.FUNCTION_REALIZATION) && this.isSemantiklyLinked(src, CsPackage.Literals.INTERFACE, tgt, CsPackage.Literals.INTERFACE, CsPackage.Literals.INTERFACE_ALLOCATION)) continue;
            transfoLink.destroy();
        }
    }

    protected AbstractTrace retrieveTransfoLink(EObject object_p) {
        if (object_p instanceof CapellaElement) {
            CapellaElement element = (CapellaElement)object_p;
            EList traceList = element.getIncomingTraces();
            for (AbstractTrace trace : traceList) {
                if (!Query.isLinkOfTransfo((AbstractTrace)trace, (ITransfo)this._transfo)) continue;
                return trace;
            }
        }
        return null;
    }

    protected void initialize_() {
    }

    public void generateUid() {
        CapellaElement transfoTarget = (CapellaElement)this._transfo.get((Object)TRANSFO_TARGET_CONTAINER);
        this._transfo.setUid("Type='Transition' TargetId='" + transfoTarget.getId() + "'");
    }

    protected void finalize_() {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug((Object)"====================================");
            this._logger.debug((Object)"Finalizing...");
            this._logger.debug((Object)"====================================");
        }
        this.performContributionCommands();
        this.attachTransfoLinks();
        this.attachSemanticLinks();
    }

    protected void performContributionCommands() {
        Object links;
        Object transformedElements = this._transfo.get((Object)"transformedElements");
        if (transformedElements != null && transformedElements instanceof Collection) {
            Collection transformedElementsList = (Collection)transformedElements;
            for (EObject element : transformedElementsList) {
                CompoundCommand command = CreationHelper.getContributorsCommand((EObject)element, (EObject)element.eContainer(), (EClass)element.eClass(), (EStructuralFeature)element.eContainmentFeature());
                if (!command.canExecute()) continue;
                command.execute();
            }
        }
        if ((links = this._transfo.get((Object)"newLinks")) != null && links instanceof Collection) {
            Collection linksList = (Collection)links;
            for (EObject element : linksList) {
                CompoundCommand command = CreationHelper.getContributorsCommand((EObject)element, (EObject)element.eContainer(), (EClass)element.eClass(), (EStructuralFeature)element.eContainmentFeature());
                if (!command.canExecute()) continue;
                command.execute();
            }
        }
    }

    protected void attachTransfoLinks() {
        List links = (List)this._transfo.get((Object)"newLinks");
        for (AbstractTrace abstractLink : links) {
            GenericTrace transfoLink;
            TraceableElement elt;
            Namespace ownerElt;
            if (!(abstractLink instanceof GenericTrace) || (ownerElt = (Namespace)((elt = (transfoLink = (GenericTrace)abstractLink).getSourceElement()) instanceof Namespace ? elt : EcoreUtil2.getFirstContainer((EObject)elt, (EClass)CapellacorePackage.Literals.NAMESPACE))) == null) continue;
            HoldingResourceHelper.ensureMoveElement((EObject)transfoLink, (EObject)ownerElt);
            ownerElt.getOwnedTraces().add((Object)transfoLink);
        }
    }

    protected void attachSemanticLinks() {
        Map mappings = CapellaRefMap.getInstance().getMappings();
        for (EObject src : this._agenda) {
            Object tgt = Query.retrieveTransformedElement((EObject)src, (ITransfo)this._transfo);
            if (tgt == null) continue;
            if (tgt instanceof EObject) {
                EObject tgt2 = (EObject)tgt;
                this.attachSemanticLink(mappings, tgt2, src);
                continue;
            }
            List l = (List)tgt;
            for (EObject tgt2 : l) {
                this.attachSemanticLink(mappings, tgt2, src);
            }
        }
    }

    protected void attachSemanticLink(Map<KPair, VPair> mapping_p, EObject linkSrc_p, EObject linkTgt_p) {
        VPair semanticLink = mapping_p.get(new KPair(linkSrc_p.eClass(), linkTgt_p.eClass()));
        if (semanticLink != null) {
            for (AbstractTrace trace : ((TraceableElement)linkTgt_p).getIncomingTraces()) {
                EClass[] classes = (EClass[])semanticLink.getFirstValue();
                EReference[] references = (EReference[])semanticLink.getSecondValue();
                int i = 0;
                while (i < classes.length) {
                    if (classes[i].isInstance((Object)trace) && trace.getSourceElement() == linkSrc_p) {
                        HoldingResourceHelper.ensureMoveElement((EObject)trace, (EObject)linkSrc_p);
                        ((Collection)linkSrc_p.eGet((EStructuralFeature)references[i])).add(trace);
                    }
                    ++i;
                }
            }
        }
    }

    protected boolean isSemantiklyLinked(TraceableElement src, EClass srcType, TraceableElement tgt, EClass tgtType, EClass semanticLink) {
        if (!srcType.equals(src.eClass()) && !srcType.isSuperTypeOf(src.eClass()) || !tgtType.equals(tgt.eClass()) && !tgtType.isSuperTypeOf(tgt.eClass())) {
            return true;
        }
        for (AbstractTrace abstractTrace : src.getOutgoingTraces()) {
            TraceableElement traceableElt;
            if (abstractTrace.eClass() != semanticLink || (traceableElt = abstractTrace.getTargetElement()) != tgt) continue;
            return true;
        }
        return false;
    }
}

