/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.diagram.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.contentassist.ContentInstanceContext;
import org.eclipse.sirius.common.tools.api.contentassist.IProposalProvider;
import org.eclipse.sirius.common.tools.api.interpreter.CompoundInterpreter;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterProvider;
import org.eclipse.sirius.common.tools.internal.assist.ProposalProviderRegistry;
import org.eclipse.sirius.common.tools.internal.interpreter.DefaultInterpreterProvider;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.description.DAnnotation;
import org.eclipse.sirius.viewpoint.description.DModelElement;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.RepresentationElementMapping;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.common.ui.toolkit.browser.category.CategoryRegistry;
import org.polarsys.capella.common.ui.toolkit.browser.category.ICategory;
import org.polarsys.capella.core.diagram.helpers.DAnnotationHelper;
import org.polarsys.capella.core.model.handler.helpers.CapellaAdapterHelper;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;
import org.polarsys.capella.core.model.helpers.viewpoint.ViewpointHelper;
import org.polarsys.kitalpha.emde.model.Element;

public class TitleBlockHelper {
    public static final String TITLE_BLOCK_LINE = "TitleBlockLine";
    public static final String TITLE_BLOCK_CELL = "TitleBlockCell";
    public static final String ELEMENT_TITLE_BLOCK = "ElementTitleBlock";
    public static final String TITLE_BLOCK_CONTENT = "TitleBlockContent";
    public static final String TRUE = "True";
    public static final String NAME = "Name:";
    public static final String CONTENT = "Content:";
    public static final String DIAGRAM_TITLE_BLOCK = "DiagramTitleBlock";
    public static final String CAPELLA_PREFIX = "capella:";
    public static final String AQL_PREFIX = "aql:";
    public static final String FEATURE_PREFIX = "feature:";
    public static final String TITLE_BLOCK_MAPPING_PREFIX = "DT_TitleBlock";

    public static boolean isDiagramTitleBlock(DAnnotation titleBlock) {
        return titleBlock.getSource() != null && titleBlock.getSource().equals(DIAGRAM_TITLE_BLOCK);
    }

    public static boolean isElementTitleBlock(DAnnotation titleBlock) {
        return titleBlock.getSource() != null && titleBlock.getSource().equals(ELEMENT_TITLE_BLOCK);
    }

    public static boolean isTitleBlock(DAnnotation annotation) {
        return TitleBlockHelper.isDiagramTitleBlock(annotation) || TitleBlockHelper.isElementTitleBlock(annotation);
    }

    public static boolean isTitleBlockLine(DAnnotation annotation) {
        return annotation.getSource() != null && annotation.getSource().equals(TITLE_BLOCK_LINE);
    }

    public static boolean isTitleBlockCell(DAnnotation annotation) {
        return annotation.getSource() != null && annotation.getSource().equals(TITLE_BLOCK_CELL);
    }

    public static boolean isContentTitleBlock(DAnnotation titleBlock) {
        return titleBlock.getSource() != null && titleBlock.getSource().equals(TITLE_BLOCK_CONTENT);
    }

    public static boolean isTitleBlockCell(DDiagramElement diagramElement) {
        return diagramElement.getTarget() instanceof DAnnotation && TitleBlockHelper.isTitleBlockCell((DAnnotation)diagramElement.getTarget());
    }

    public static boolean isTitleBlockMapping(RepresentationElementMapping mapping) {
        return mapping != null && TitleBlockHelper.isTitleBlockMapping(mapping.getName());
    }

    public static boolean isTitleBlockMapping(String mappingName) {
        return mappingName != null && mappingName.contains(TITLE_BLOCK_MAPPING_PREFIX);
    }

    public static List<DAnnotation> getElementTitleBlocks(DDiagram diagram) {
        DRepresentationDescriptor descriptor = RepresentationHelper.getRepresentationDescriptor((DRepresentation)diagram);
        if (descriptor != null && descriptor.getEAnnotations() != null) {
            return descriptor.getEAnnotations().stream().filter(a -> a.getSource().equals(ELEMENT_TITLE_BLOCK)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static List<DAnnotation> getDiagramTitleBlocks(DDiagram diagram) {
        DRepresentationDescriptor descriptor = RepresentationHelper.getRepresentationDescriptor((DRepresentation)diagram);
        if (descriptor != null && descriptor.getEAnnotations() != null) {
            return descriptor.getEAnnotations().stream().filter(a -> a.getSource().equals(DIAGRAM_TITLE_BLOCK)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static List<DAnnotation> getElementTitleBlocks(DDiagram diagram, EObject element) {
        return TitleBlockHelper.getElementTitleBlocks(diagram).stream().filter(block -> block.getReferences().contains((Object)element)).collect(Collectors.toList());
    }

    public static List<DAnnotation> getTitleBlockLines(DAnnotation titleBlock) {
        ArrayList<DAnnotation> lines = new ArrayList<DAnnotation>();
        if (TitleBlockHelper.isTitleBlock(titleBlock)) {
            for (EObject element : titleBlock.getReferences()) {
                if (!(element instanceof DAnnotation) || !TitleBlockHelper.isTitleBlockLine((DAnnotation)element)) continue;
                lines.add((DAnnotation)element);
            }
        }
        return lines;
    }

    public static List<DAnnotation> getTitleBlockCells(DAnnotation titleBlockLine) {
        ArrayList<DAnnotation> cells = new ArrayList<DAnnotation>();
        if (TitleBlockHelper.isTitleBlockLine(titleBlockLine)) {
            for (EObject element : titleBlockLine.getReferences()) {
                if (!(element instanceof DAnnotation) || !TitleBlockHelper.isTitleBlockCell((DAnnotation)element)) continue;
                cells.add((DAnnotation)element);
            }
        }
        return cells;
    }

    public static boolean containsCell(DAnnotation container, DAnnotation cell) {
        if (TitleBlockHelper.isTitleBlock(container) && TitleBlockHelper.isTitleBlockCell(cell)) {
            return TitleBlockHelper.getTitleBlockLines(container).stream().flatMap(line -> TitleBlockHelper.getTitleBlockCells(line).stream()).anyMatch(c -> c.equals(cell));
        }
        if (TitleBlockHelper.isTitleBlockLine(container) && TitleBlockHelper.isTitleBlockCell(cell)) {
            return TitleBlockHelper.getTitleBlockCells(container).stream().anyMatch(c -> c.equals(cell));
        }
        return false;
    }

    public static DAnnotation getParentTitleBlock(DAnnotation titleBlockCell) {
        Collection referencer;
        Session session;
        if (TitleBlockHelper.isTitleBlockCell(titleBlockCell) && (session = SessionManager.INSTANCE.getSession((EObject)titleBlockCell)) != null && !(referencer = session.getSemanticCrossReferencer().getInverseReferences((EObject)titleBlockCell, DescriptionPackage.Literals.DANNOTATION__REFERENCES, false)).isEmpty()) {
            DAnnotation line = (DAnnotation)((EStructuralFeature.Setting)referencer.iterator().next()).getEObject();
            referencer = session.getSemanticCrossReferencer().getInverseReferences((EObject)line, DescriptionPackage.Literals.DANNOTATION__REFERENCES, false);
            if (!referencer.isEmpty()) {
                return (DAnnotation)((EStructuralFeature.Setting)referencer.iterator().next()).getEObject();
            }
        }
        return null;
    }

    public static DAnnotation getParentAnnotation(DAnnotation annotation) {
        Collection referencer;
        Session session = SessionManager.INSTANCE.getSession((EObject)annotation);
        if (session != null && !(referencer = session.getSemanticCrossReferencer().getInverseReferences((EObject)annotation, DescriptionPackage.Literals.DANNOTATION__REFERENCES, false)).isEmpty()) {
            return (DAnnotation)((EStructuralFeature.Setting)referencer.iterator().next()).getEObject();
        }
        return null;
    }

    public static EObject getSemanticElementReference(DAnnotation titleBlock) {
        List modelElements;
        if (titleBlock != null && !(modelElements = titleBlock.getReferences().stream().filter(x -> !(x instanceof DAnnotation)).collect(Collectors.toList())).isEmpty()) {
            return (EObject)modelElements.get(0);
        }
        return null;
    }

    public static int getColumnIndexOfCell(DAnnotation titleBlockCell, DAnnotation titleBlock) {
        for (DAnnotation line : TitleBlockHelper.getTitleBlockLines(titleBlock)) {
            List<DAnnotation> cells = TitleBlockHelper.getTitleBlockCells(line);
            int index = 0;
            while (index < cells.size()) {
                if (cells.get(index).equals(titleBlockCell)) {
                    return index;
                }
                ++index;
            }
        }
        return -1;
    }

    public static int getLineIndexOfCell(DAnnotation cell, DAnnotation titleBlock) {
        List<DAnnotation> lines = TitleBlockHelper.getTitleBlockLines(titleBlock);
        int index = 0;
        while (index < lines.size()) {
            if (TitleBlockHelper.containsCell(lines.get(index), cell)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public static DAnnotation addDiagramTitleBlock(DDiagram diagram) {
        return DAnnotationHelper.createAnnotation(DIAGRAM_TITLE_BLOCK, (DModelElement)RepresentationHelper.getRepresentationDescriptor((DRepresentation)diagram));
    }

    public static DAnnotation addElementTitleBlock(DDiagram diagram, DDiagramElement diagramElement) {
        DAnnotation annotation = DAnnotationHelper.createAnnotation(ELEMENT_TITLE_BLOCK, (DModelElement)RepresentationHelper.getRepresentationDescriptor((DRepresentation)diagram));
        annotation.getReferences().add((Object)diagramElement.getTarget());
        return annotation;
    }

    public static DAnnotation addTitleBlockLine(DDiagram diagram, DAnnotation titleBlock) {
        DAnnotation line = DAnnotationHelper.createAnnotation(TITLE_BLOCK_LINE, (DModelElement)RepresentationHelper.getRepresentationDescriptor((DRepresentation)diagram));
        titleBlock.getReferences().add((Object)line);
        return line;
    }

    public static DAnnotation addTitleBlockLine(DDiagram diagram, DAnnotation titleBlock, int position) {
        DAnnotation line = DAnnotationHelper.createAnnotation(TITLE_BLOCK_LINE, (DModelElement)RepresentationHelper.getRepresentationDescriptor((DRepresentation)diagram));
        if (TitleBlockHelper.isDiagramTitleBlock(titleBlock)) {
            titleBlock.getReferences().add(position, (Object)line);
        } else {
            titleBlock.getReferences().add(position + 1, (Object)line);
        }
        return line;
    }

    public static DAnnotation addTitleBlockLine(DDiagram diagram, DAnnotation titleBlock, int position, int numCols) {
        DAnnotation line = TitleBlockHelper.addTitleBlockLine(diagram, titleBlock, position);
        int i = 0;
        while (i < numCols) {
            TitleBlockHelper.addTitleBlockCell(diagram, line, "", "");
            ++i;
        }
        return line;
    }

    public static DAnnotation addTitleBlockCell(DDiagram diagram, DAnnotation line, String name, String content) {
        DAnnotation cell = DAnnotationHelper.createAnnotation(TITLE_BLOCK_CELL, (DModelElement)RepresentationHelper.getRepresentationDescriptor((DRepresentation)diagram));
        cell.getDetails().put((Object)NAME, (Object)name);
        cell.getDetails().put((Object)CONTENT, (Object)content);
        line.getReferences().add((Object)cell);
        return cell;
    }

    public static DAnnotation addTitleBlockCell(DDiagram diagram, DAnnotation line, String name, String content, int position) {
        DAnnotation cell = DAnnotationHelper.createAnnotation(TITLE_BLOCK_CELL, (DModelElement)RepresentationHelper.getRepresentationDescriptor((DRepresentation)diagram));
        cell.getDetails().put((Object)NAME, (Object)name);
        cell.getDetails().put((Object)CONTENT, (Object)content);
        line.getReferences().add(position, (Object)cell);
        return cell;
    }

    public static int getNumOfColumns(DAnnotation titleBlock) {
        DAnnotation firstLine = TitleBlockHelper.getTitleBlockLines(titleBlock).get(0);
        return TitleBlockHelper.getTitleBlockCells(firstLine).size();
    }

    public static void setTitleBlockCellContent(DAnnotation line, String name, String content) {
        line.getDetails().put((Object)NAME, (Object)name);
        line.getDetails().put((Object)CONTENT, (Object)content);
    }

    public static void getServicesProposals(final Text textField, EObject target) {
        final EObject resolvedTarget = CapellaAdapterHelper.resolveDescriptorOrBusinessObject((Object)target);
        try {
            KeyStroke keyStroke = KeyStroke.getInstance((String)"Ctrl+Space");
            IContentProposalProvider provider = new IContentProposalProvider(){

                public IContentProposal[] getProposals(String contents, int position) {
                    IInterpreter vpInterpreter = CompoundInterpreter.INSTANCE.getInterpreterForExpression(contents);
                    ArrayList<ContentProposal> proposalsList = new ArrayList<ContentProposal>();
                    ContentInstanceContext contentContext = new ContentInstanceContext(resolvedTarget, contents, position);
                    if (contents.contains(TitleBlockHelper.CAPELLA_PREFIX)) {
                        Set categories = CategoryRegistry.getInstance().gatherCategories(resolvedTarget);
                        for (ICategory category : categories) {
                            String proposalContent = category.getSymbolicName();
                            if (!proposalContent.toLowerCase().startsWith(contents.replaceFirst(TitleBlockHelper.CAPELLA_PREFIX, "").toLowerCase())) continue;
                            proposalsList.add(new ContentProposal(proposalContent, proposalContent, null));
                        }
                    } else {
                        List<org.eclipse.sirius.common.tools.api.contentassist.ContentProposal> computedProposals;
                        if (contents == null || contents.length() == 0 || !contents.contains(":")) {
                            computedProposals = CompoundInterpreter.INSTANCE.getAllNewEmtpyExpressions();
                            computedProposals.removeIf(p -> !p.getProposal().equals(TitleBlockHelper.AQL_PREFIX) && !p.getProposal().equals(TitleBlockHelper.FEATURE_PREFIX));
                            computedProposals.add(new org.eclipse.sirius.common.tools.api.contentassist.ContentProposal(TitleBlockHelper.CAPELLA_PREFIX, TitleBlockHelper.CAPELLA_PREFIX, null));
                            if (contents != null && contents.length() > 0) {
                                computedProposals.removeIf(p -> !p.getProposal().toLowerCase().startsWith(contents.toLowerCase()));
                            }
                        } else if (vpInterpreter instanceof IProposalProvider) {
                            computedProposals = ((IProposalProvider)vpInterpreter).getProposals(vpInterpreter, contentContext);
                        } else {
                            computedProposals = new ArrayList<org.eclipse.sirius.common.tools.api.contentassist.ContentProposal>();
                            List proposalProviders = ProposalProviderRegistry.getProvidersFor((IInterpreter)vpInterpreter);
                            for (IProposalProvider provider : proposalProviders) {
                                computedProposals.addAll(provider.getProposals(vpInterpreter, contentContext));
                            }
                        }
                        for (org.eclipse.sirius.common.tools.api.contentassist.ContentProposal proposals : computedProposals) {
                            ContentProposal contentProposals = new ContentProposal(proposals.getProposal(), proposals.getDisplay(), proposals.getInformation(), proposals.getCursorPosition());
                            proposalsList.add(contentProposals);
                        }
                    }
                    IContentProposal[] proposals = new IContentProposal[proposalsList.size()];
                    proposals = proposalsList.toArray(proposals);
                    return proposals;
                }
            };
            final ContentProposalAdapter adapter = new ContentProposalAdapter((Control)textField, (IControlContentAdapter)new TextContentAdapter(), provider, keyStroke, null);
            adapter.addContentProposalListener(new IContentProposalListener(){

                public void proposalAccepted(IContentProposal proposal) {
                    String proposalContent = proposal.getContent();
                    String textBeforeProposal = textField.getText(0, textField.getText().length() - proposalContent.length() - 1);
                    StringBuffer patternToMatch = new StringBuffer();
                    int currentIndex = textBeforeProposal.length() - 1;
                    String matchedString = "";
                    while (currentIndex >= 0 && patternToMatch.length() <= textBeforeProposal.length()) {
                        patternToMatch.reverse();
                        patternToMatch.append(textBeforeProposal.charAt(currentIndex));
                        patternToMatch.reverse();
                        if (proposalContent.toLowerCase().startsWith(patternToMatch.toString().toLowerCase())) {
                            matchedString = patternToMatch.toString();
                        }
                        --currentIndex;
                    }
                    textField.setText(String.valueOf(textBeforeProposal.substring(0, textBeforeProposal.length() - matchedString.length())) + proposalContent);
                    adapter.getControlContentAdapter().setCursorPosition((Control)textField, textField.getText().length());
                }
            });
            adapter.getControlContentAdapter().setCursorPosition((Control)textField, 5);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public static List<DAnnotation> getAllAnnotationsForTitleBlock(DAnnotation titleBlock) {
        ArrayList<DAnnotation> pieces = new ArrayList<DAnnotation>();
        if (TitleBlockHelper.isTitleBlock(titleBlock)) {
            for (EObject element : titleBlock.getReferences()) {
                if (!(element instanceof DAnnotation) || !TitleBlockHelper.isTitleBlockLine((DAnnotation)element)) continue;
                pieces.add((DAnnotation)element);
                for (EObject elementCol : ((DAnnotation)element).getReferences()) {
                    if (!(elementCol instanceof DAnnotation)) continue;
                    pieces.add((DAnnotation)elementCol);
                    for (EObject elementCel : ((DAnnotation)elementCol).getReferences()) {
                        if (!(elementCel instanceof DAnnotation)) continue;
                        pieces.add((DAnnotation)elementCel);
                        for (EObject elementContent : ((DAnnotation)elementCel).getReferences()) {
                            if (!(elementContent instanceof DAnnotation)) continue;
                            pieces.add((DAnnotation)elementContent);
                        }
                    }
                }
            }
        }
        return pieces;
    }

    public static List<Object> getAllContents(DAnnotation titleBlock) {
        ArrayList<Object> allContents = new ArrayList<Object>();
        if (TitleBlockHelper.isTitleBlock(titleBlock)) {
            for (DAnnotation line : TitleBlockHelper.getTitleBlockLines(titleBlock)) {
                allContents.add(line);
                for (DAnnotation cell : TitleBlockHelper.getTitleBlockCells(line)) {
                    allContents.add(cell);
                    for (EObject cellReference : cell.getReferences()) {
                        if (!(cellReference instanceof DAnnotation)) continue;
                        DAnnotation cellContent = (DAnnotation)cellReference;
                        allContents.add(cellContent);
                        allContents.addAll((Collection<Object>)cellContent.getDetails());
                    }
                }
            }
        }
        return allContents;
    }

    public static boolean isTitleBlockAnnotation(EObject object) {
        if (object instanceof DAnnotation) {
            DAnnotation annotation = (DAnnotation)object;
            return TitleBlockHelper.isDiagramTitleBlock(annotation) || TitleBlockHelper.isElementTitleBlock(annotation) || TitleBlockHelper.isTitleBlockCell(annotation) || TitleBlockHelper.isContentTitleBlock(annotation) || TitleBlockHelper.isTitleBlockLine(annotation);
        }
        return false;
    }

    public static String getTitleBlockAnnotationLabel(EObject object) {
        if (object instanceof DAnnotation) {
            String label = ((DAnnotation)object).getSource();
            label = label.replaceAll("([^_])([A-Z])", "$1 $2");
            return label;
        }
        return "";
    }

    public static EObject getReferencedElement(EObject object) {
        EObject target = null;
        if (object instanceof DAnnotation) {
            DAnnotation annotation = (DAnnotation)object;
            if (TitleBlockHelper.isElementTitleBlock(annotation)) {
                target = (EObject)annotation.getReferences().get(0);
            } else if (TitleBlockHelper.isDiagramTitleBlock(annotation)) {
                target = annotation.eContainer();
            } else if (TitleBlockHelper.isTitleBlockCell(annotation)) {
                target = TitleBlockHelper.getReferencedElement((EObject)TitleBlockHelper.getParentTitleBlock(annotation));
            }
            if (target instanceof DRepresentation) {
                target = RepresentationHelper.getRepresentationDescriptor((DRepresentation)((DRepresentation)target));
            }
        }
        return target;
    }

    public static String getReferencedElementLabel(EObject object) {
        EObject referencedElement = TitleBlockHelper.getReferencedElement(object);
        return EObjectLabelProviderHelper.getText((Object)referencedElement);
    }

    public static String getServiceName(String service) {
        String text = service.replaceAll(CAPELLA_PREFIX, "").replaceAll("([^_])([A-Z])", "$1 $2");
        text = text.length() > 1 ? String.valueOf(text.substring(0, 1).toUpperCase()) + text.substring(1) : text;
        return text;
    }

    public static String getTitleBlockName(String type) {
        if (type.equals(DIAGRAM_TITLE_BLOCK)) {
            return "Diagram Title Block";
        }
        if (type.equals(ELEMENT_TITLE_BLOCK)) {
            return "Element Title Block";
        }
        return "";
    }

    public static Object getResultOfExpression(DRepresentationDescriptor descriptor, String expression, DAnnotation titleBlock) {
        IInterpreterProvider provider;
        EObject semanticElement = TitleBlockHelper.getSemanticElementReference(titleBlock);
        if (semanticElement == null) {
            semanticElement = descriptor;
        }
        if ((provider = CompoundInterpreter.INSTANCE.getProviderForExpression(expression)) instanceof DefaultInterpreterProvider) {
            return new EvaluationException();
        }
        IInterpreter interpreter = provider.createInterpreter();
        Object result = null;
        try {
            result = interpreter.evaluate(semanticElement, expression);
        }
        catch (EvaluationException e) {
            return e;
        }
        if (result instanceof Collection) {
            Collection originalResult = (Collection)result;
            return TitleBlockHelper.sanitizeResultItems(originalResult);
        }
        return TitleBlockHelper.sanitizeResultItem(result);
    }

    private static boolean isValidResultItem(Object item) {
        if (item instanceof EObject) {
            EObject eObject = (EObject)item;
            return eObject instanceof Element || eObject instanceof DRepresentationDescriptor || TitleBlockHelper.isViewpointElement(eObject);
        }
        return true;
    }

    private static boolean isViewpointElement(EObject eObject) {
        EPackage ePackage = eObject.eClass().getEPackage();
        return ViewpointHelper.getViewpointPackages().contains(ePackage);
    }

    private static Object sanitizeResultItem(Object resultItem) {
        if (TitleBlockHelper.isValidResultItem(resultItem)) {
            return resultItem;
        }
        String sanitizedText = EObjectLabelProviderHelper.getText((Object)resultItem);
        if (sanitizedText != null && !sanitizedText.isEmpty()) {
            return sanitizedText;
        }
        return resultItem != null ? resultItem.toString() : "";
    }

    private static Object sanitizeResultItems(Collection<?> originalResult) {
        return originalResult.stream().map(TitleBlockHelper::sanitizeResultItem).collect(Collectors.toList());
    }
}

