/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.common.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.core.transition.common.constants.Messages;
import org.polarsys.capella.core.transition.common.handlers.attachment.AttachmentHelper;
import org.polarsys.capella.core.transition.common.handlers.log.LogHelper;
import org.polarsys.capella.core.transition.common.handlers.scope.IScopeHandler;
import org.polarsys.capella.core.transition.common.handlers.scope.ScopeHandlerHelper;
import org.polarsys.capella.core.transition.common.handlers.selection.ISelectionContext;
import org.polarsys.capella.core.transition.common.handlers.selection.SelectionContextHandlerHelper;
import org.polarsys.capella.core.transition.common.handlers.traceability.TraceabilityHandlerHelper;
import org.polarsys.capella.core.transition.common.handlers.transformation.TransformationHandlerHelper;
import org.polarsys.capella.core.transition.common.rules.IRuleAttachment;
import org.polarsys.capella.core.transition.common.rules.IRuleScope;
import org.polarsys.capella.core.transition.common.rules.IRuleTransformation;
import org.polarsys.kitalpha.transposer.rules.handler.business.premises.ContainmentPremise;
import org.polarsys.kitalpha.transposer.rules.handler.business.premises.PrecedencePremise;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IPremise;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IRule;

public abstract class AbstractRule
implements IRule<EObject>,
IRuleScope,
IRuleTransformation,
IRuleAttachment {
    @Deprecated
    protected IContext currentContext;

    @Override
    public List<EObject> retrieveRootElements(EObject source, IContext context) {
        this.setCurrentContext(context);
        ArrayList<EObject> result = new ArrayList<EObject>();
        this.retrieveRootElement(source, result, context);
        return result;
    }

    @Override
    public List<EObject> retrieveContainers(EObject source, IContext context) {
        this.setCurrentContext(context);
        ArrayList<EObject> result = new ArrayList<EObject>();
        this.retrieveContainer(source, result, context);
        return result;
    }

    @Override
    public List<EObject> retrieveRequiredElements(EObject element, IContext context) {
        this.setCurrentContext(context);
        ArrayList<EObject> result = new ArrayList<EObject>();
        this.retrieveRequired(element, result, context);
        return result;
    }

    @Override
    public List<EObject> retrieveRelatedElements(EObject element, IContext context) {
        this.setCurrentContext(context);
        ArrayList<EObject> result = new ArrayList<EObject>();
        this.retrieveCurrent(element, result, context);
        this.retrieveGoDeep(element, result, context);
        return result;
    }

    protected void retrieveCurrent(EObject source, List<EObject> result, IContext context) {
        this.setCurrentContext(context);
        result.add(source);
    }

    protected void retrieveRequired(EObject element, List<EObject> result, IContext context) {
    }

    protected void retrieveRootElement(EObject source, List<EObject> result, IContext context) {
        EObject container = TransformationHandlerHelper.getInstance(context).getLevelElement(source, context);
        if (container != null) {
            result.add(container);
        }
    }

    protected void retrieveGoDeep(EObject source, List<EObject> result, IContext context) {
    }

    protected void retrieveContainer(EObject element, List<EObject> result, IContext context) {
        EObject container = element.eContainer();
        if (container != null) {
            result.add(container);
        }
    }

    public List<IPremise> getPremises(EObject element) {
        ArrayList<IPremise> needed = new ArrayList<IPremise>();
        ArrayList<EObject> previous = new ArrayList<EObject>();
        this.premicesContainement(element, needed);
        this.premicesRelated(element, needed);
        previous.add(element);
        IContext context = this.getCurrentContext();
        IScopeHandler scope = ScopeHandlerHelper.getInstance(context);
        if (scope != null) {
            for (IPremise premise : new ArrayList<IPremise>(needed)) {
                Object result = null;
                if (!(premise instanceof PrecedencePremise)) continue;
                result = ((PrecedencePremise)premise).getFirstElement();
                if (result != null && result instanceof EObject) {
                    previous.add((EObject)result);
                    continue;
                }
                if (result == null || !(result instanceof EObject) || scope.isInScope((EObject)result, context)) continue;
                LogHelper.getInstance().warn(NLS.bind((String)"Element ''{0}'' is premise of ''{1}'' but not in scope.", (Object)LogHelper.getInstance().getText(result), (Object)LogHelper.getInstance().getText(element)), Messages.Activity_Transformation);
            }
        }
        if (LogHelper.getInstance().hasDebug()) {
            LogHelper.getInstance().debug(NLS.bind((String)"Premises of ''{0}'' .", (Object)LogHelper.getInstance().getText(element)), previous, Messages.Activity_Transformation);
        }
        return needed;
    }

    protected void premicesRelated(EObject element, ArrayList<IPremise> needed) {
    }

    protected void premicesContainement(EObject element, ArrayList<IPremise> needed) {
        ContainmentPremise<EObject> premise = this.createDefaultContainementPremice(element);
        if (premise != null) {
            needed.add((IPremise)premise);
        }
    }

    protected ContainmentPremise<EObject> createDefaultContainementPremice(EObject eObject) {
        IScopeHandler scope;
        EObject parent = eObject.eContainer();
        IContext context = this.getCurrentContext();
        if (context != null && (scope = ScopeHandlerHelper.getInstance(context)) != null) {
            parent = eObject.eContainer();
            while (parent != null) {
                if (scope.isInScope(parent, context)) break;
                parent = parent.eContainer();
            }
        }
        if (parent != null) {
            return this.createContainmentPremice(parent);
        }
        return null;
    }

    protected List<PrecedencePremise<EObject>> createDefaultPrecedencePremices(Collection<EObject> referencedElements, String name) {
        IScopeHandler scope;
        ArrayList<PrecedencePremise<EObject>> premices = new ArrayList<PrecedencePremise<EObject>>();
        IContext context = this.getCurrentContext();
        if (context != null && (scope = ScopeHandlerHelper.getInstance(context)) != null) {
            for (EObject obj : referencedElements) {
                if (!scope.isInScope(obj, context)) continue;
                premices.add(this.createPrecedencePremice(obj, name));
            }
        }
        return premices;
    }

    protected List<PrecedencePremise<EObject>> createDefaultCriticalPremices(Collection<EObject> referencedElements, String name) {
        IScopeHandler scope;
        ArrayList<PrecedencePremise<EObject>> premices = new ArrayList<PrecedencePremise<EObject>>();
        IContext context = this.getCurrentContext();
        if (context != null && (scope = ScopeHandlerHelper.getInstance(context)) != null) {
            for (EObject obj : referencedElements) {
                if (!scope.isInScope(obj, context)) continue;
                premices.add((PrecedencePremise<EObject>)this.createCriticalPremice(obj, name));
            }
        }
        return premices;
    }

    public List<PrecedencePremise<EObject>> createDefaultPrecedencePremices(EObject eObject, EReference reference) {
        IScopeHandler scope;
        ArrayList<PrecedencePremise<EObject>> premices = new ArrayList<PrecedencePremise<EObject>>();
        IContext context = this.getCurrentContext();
        if (context != null && (scope = ScopeHandlerHelper.getInstance(context)) != null) {
            if (reference.isMany()) {
                for (Object obj : (EList)eObject.eGet((EStructuralFeature)reference)) {
                    if (obj == null || !(obj instanceof EObject) || !scope.isInScope((EObject)obj, context)) continue;
                    premices.add(this.createPrecedencePremice((EObject)obj, reference.getName()));
                }
            } else {
                Object obj = eObject.eGet((EStructuralFeature)reference);
                if (obj != null && obj instanceof EObject && scope.isInScope((EObject)obj, context)) {
                    premices.add(this.createPrecedencePremice((EObject)obj, reference.getName()));
                }
            }
        }
        return premices;
    }

    public List<PrecedencePremise<EObject>> createDefaultCriticalPremices(EObject eObject, EReference reference) {
        List<PrecedencePremise<EObject>> premices = this.createDefaultPrecedencePremices(eObject, reference);
        for (PrecedencePremise<EObject> premice : premices) {
            premice.setCritical(true);
        }
        return premices;
    }

    protected PrecedencePremise<EObject> createPrecedencePremice(EObject eObject, String string) {
        PrecedencePremise premice = null;
        premice = new PrecedencePremise((Object)eObject, string);
        return premice;
    }

    protected ContainmentPremise<EObject> createContainmentPremice(EObject eObject) {
        ContainmentPremise premice = null;
        premice = new ContainmentPremise((Object)eObject);
        return premice;
    }

    protected ContainmentPremise<EObject> createCriticalPremice(EObject eObject, String string) {
        ContainmentPremise premice = null;
        premice = new ContainmentPremise((Object)eObject);
        return premice;
    }

    public void apply(EObject element, IContext context) throws Exception {
        boolean isCompleteRule;
        Boolean isComplete = (Boolean)context.get((Object)"TRANSPOSER_APPLY_IS_COMPLETE");
        boolean bl = isCompleteRule = isComplete == null ? true : isComplete;
        if (!isCompleteRule) {
            this.registerAsIncomplete(element, context);
        }
        try {
            if (this.applyRequired(element, context).isOK()) {
                if (!isCompleteRule || isCompleteRule && !this.isIncomplete(element, context)) {
                    IStatus transformRequired = this.transformRequired(element, context);
                    if (transformRequired.isOK()) {
                        for (EObject result : this.transformElement(element, context)) {
                            this.postTransformElement(element, result, context);
                            if (!this.isValidTargetElement(element, result, context) || this.isRegisteredTargetElement(element, result, context)) continue;
                            this.registerTargetElement(element, result, context);
                        }
                    } else {
                        LogHelper.getInstance().log("Element is not transitioned: " + transformRequired.getMessage(), transformRequired, element, transformRequired.getPlugin());
                    }
                }
                if (isCompleteRule) {
                    for (EObject result : this.retrieveTracedElements(element, context)) {
                        if (!this.isValidTargetElement(element, result, context)) continue;
                        this.updateElement(element, result, context);
                        if (!this.isContainementAttached(element, result, context)) {
                            this.attachContainement(element, result, context);
                        }
                        if (this.isRelatedAttached(element, result, context)) continue;
                        this.attachRelated(element, result, context);
                    }
                }
            }
        }
        catch (Exception e) {
            LogHelper.getInstance().error(String.valueOf(e.getClass().getName()) + " [" + e.getMessage() + "]", e.getCause(), Messages.Activity_Transformation);
            e.printStackTrace();
            throw e;
        }
    }

    protected void postTransformElement(EObject element, EObject result, IContext context) {
        TransformationHandlerHelper.getInstance(context).postTransformElement(element, result, context);
    }

    protected void updateElement(EObject element, EObject result, IContext context) {
    }

    @Override
    public IStatus applyRequired(EObject element, IContext context) {
        Object applyRequired = context.get((Object)"TRANSPOSER_APPLY_REQUIRED");
        if (applyRequired != null && ((Boolean)applyRequired).booleanValue()) {
            return Status.OK_STATUS;
        }
        return new Status(2, Messages.Activity_Transformation, "Apply is not required for this transition");
    }

    protected Collection<EObject> retrieveTracedElements(EObject source, IContext context) {
        return TraceabilityHandlerHelper.getInstance(context).retrieveTracedElements(source, context);
    }

    protected boolean isValidTargetElement(EObject element, EObject result, IContext context) {
        return result != null;
    }

    protected boolean isRegisteredTargetElement(EObject element, EObject result, IContext context) {
        return false;
    }

    protected void registerTargetElement(EObject sourceElement, EObject targetElement, IContext context) {
        if (targetElement != null) {
            ((Collection)context.get((Object)"TRANSFORMED_ELEMENTS")).add(targetElement);
        }
        TraceabilityHandlerHelper.getInstance(context).attachTraceability(sourceElement, targetElement, context);
    }

    protected boolean isRelatedAttached(EObject element, EObject result, IContext context) {
        return false;
    }

    protected boolean isContainementAttached(EObject element, EObject result, IContext context) {
        return result.eContainer() != null;
    }

    protected void attachContainement(EObject element, EObject result, IContext context) {
        EObject container = this.getBestContainer(element, result, context);
        if (container == null) {
            container = this.getDefaultContainer(element, result, context);
        }
        EStructuralFeature sourceFeature = this.getSourceContainementFeature(element, result, context);
        EStructuralFeature targetFeature = this.getTargetContainementFeature(element, result, container, context);
        if (container != null && AttachmentHelper.getInstance(context).isApplicable(container.eClass(), targetFeature)) {
            AttachmentHelper.getInstance(context).attachElementByReference(element.eContainer(), container, element, result, (EReference)sourceFeature, (EReference)targetFeature);
        }
    }

    protected EObject getBestContainer(EObject element, EObject result, IContext context) {
        EObject bestContainer = null;
        EObject container = this.getSourceContainer(element, result, context);
        if (container != null) {
            ISelectionContext sContext = SelectionContextHandlerHelper.getHandler(context).getSelectionContext(context, "SC__T", element, result);
            bestContainer = TransformationHandlerHelper.getInstance(context).getBestTracedElement(container, context, sContext);
        }
        return bestContainer;
    }

    protected EObject getSourceContainer(EObject element, EObject result, IContext context) {
        return element.eContainer();
    }

    @Override
    public EObject retrieveDefaultContainer(EObject element, EObject result, IContext context) {
        return this.getDefaultContainer(element, result, context);
    }

    protected EObject getDefaultContainer(EObject element, EObject result, IContext context) {
        return null;
    }

    protected EStructuralFeature getSourceContainementFeature(EObject element, EObject result, IContext context) {
        return element.eContainingFeature();
    }

    protected EStructuralFeature getTargetContainementFeature(EObject element, EObject result, EObject container, IContext context) {
        return element.eContainingFeature();
    }

    @Override
    public EStructuralFeature retrieveTargetContainementFeature(EObject element, EObject result, EObject container, IContext context) {
        return this.getTargetContainementFeature(element, result, container, context);
    }

    protected void attachRelated(EObject element, EObject result, IContext context) {
    }

    protected Collection<EObject> transformElement(EObject element, IContext context) {
        EObject transitioned = this.transformDirectElement(element, context);
        if (LogHelper.getInstance().hasDebug()) {
            LogHelper.getInstance().debug(NLS.bind((String)"Element ''{0}'' {1} is transformed to ''{2}'' {3} [{4}]", (Object[])new Object[]{LogHelper.getInstance().getText(element), EObjectLabelProviderHelper.getMetaclassLabel((EObject)element, (boolean)true), LogHelper.getInstance().getText(transitioned), EObjectLabelProviderHelper.getMetaclassLabel((EObject)transitioned, (boolean)true), this.getClass().getSimpleName()}), new Object[]{element, transitioned}, Messages.Activity_Transformation);
        }
        return Collections.singleton(transitioned);
    }

    protected abstract EClass getSourceType();

    @Override
    public abstract EClass getTargetType(EObject var1, IContext var2);

    protected EObject transformDirectElement(EObject element, IContext context) {
        EClass clazz = this.getTargetType(element, context);
        EObject result = null;
        if (clazz != null) {
            EPackage pkg = (EPackage)clazz.eContainer();
            result = pkg.getEFactoryInstance().create(clazz);
        }
        return result;
    }

    public boolean isApplicableOn(EObject element) {
        EClass sourceType = this.getSourceType();
        return sourceType != null && sourceType.isInstance((Object)element);
    }

    protected boolean isFirstAttach(EObject element, EObject result, IContext context) {
        return result.eContainer() == null;
    }

    @Override
    public IStatus transformRequired(EObject source, IContext context) {
        EClass clazz = this.getTargetType(source, context);
        if (clazz == null) {
            return new Status(2, Messages.Activity_Transformation, NLS.bind((String)"No rule is defined for the element ''{0}'' [{1}]", (Object)LogHelper.getInstance().getText(source), (Object)source.eClass().getName()));
        }
        ISelectionContext sContext = SelectionContextHandlerHelper.getHandler(context).getSelectionContext(context, "SC__T");
        EObject result = TransformationHandlerHelper.getInstance(context).getBestTracedElement(source, context, sContext);
        if (result != null && clazz.isInstance((Object)result)) {
            return new Status(2, Messages.Activity_Transformation, NLS.bind((String)"Element ''{0}'' is already transformed [{1}]", (Object)LogHelper.getInstance().getText(source), (Object)source.eClass().getName()));
        }
        return Status.OK_STATUS;
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    protected void registerAsIncomplete(EObject element, IContext context) {
        Object rest = context.get((Object)"INCOMPLETE_ELEMENTS");
        if (rest == null) {
            context.put((Object)"INCOMPLETE_ELEMENTS", new HashSet());
        }
        ((Collection)context.get((Object)"INCOMPLETE_ELEMENTS")).add(element);
    }

    protected boolean isIncomplete(EObject element, IContext context) {
        Object rest = context.get((Object)"INCOMPLETE_ELEMENTS");
        if (rest != null) {
            return ((Collection)context.get((Object)"INCOMPLETE_ELEMENTS")).contains(element);
        }
        return false;
    }

    @Deprecated
    public void setCurrentContext(IContext context) {
        this.currentContext = context;
    }

    @Deprecated
    protected IContext getCurrentContext() {
        return this.currentContext;
    }
}

