/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.common.handlers.traceability.config;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.transition.common.handlers.traceability.ITraceabilityHandler;
import org.polarsys.capella.core.transition.common.handlers.traceability.config.ITraceabilityConfiguration;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class TraceabilityConfiguration
implements ITraceabilityConfiguration {
    private List<ITraceabilityHandler> _handlers;

    protected String getIdentifier(IContext context) {
        return this.getClass().getSimpleName();
    }

    protected void addHandler(IContext fContext, ITraceabilityHandler handler) {
        this.getDefinedHandlers(fContext).add(handler);
        handler.init(fContext);
    }

    public ITraceabilityHandler getDefinedHandler(IContext context, Class clazz) {
        for (ITraceabilityHandler handler : this.getDefinedHandlers(context)) {
            if (!clazz.isInstance(handler)) continue;
            return handler;
        }
        return null;
    }

    protected void initHandlers(IContext fContext) {
    }

    @Override
    public IStatus init(IContext context) {
        this.initHandlers(context);
        return Status.OK_STATUS;
    }

    @Override
    public IStatus dispose(IContext context) {
        if (this._handlers != null) {
            for (ITraceabilityHandler handler : this._handlers) {
                handler.dispose(context);
            }
            this._handlers.clear();
            this._handlers = null;
        }
        return Status.OK_STATUS;
    }

    @Override
    public List<ITraceabilityHandler> getDefinedHandlers(IContext context) {
        if (this._handlers == null) {
            this._handlers = new LinkedList<ITraceabilityHandler>();
        }
        return this._handlers;
    }

    @Override
    public boolean useHandlerForAttachment(EObject source, EObject target, ITraceabilityHandler handler, IContext context) {
        return true;
    }

    @Override
    public boolean useHandlerForTracedElements(EObject source, ITraceabilityHandler handler, IContext context) {
        return true;
    }

    @Override
    public boolean useHandlerForSourceElements(EObject source, ITraceabilityHandler handler, IContext context) {
        return true;
    }
}

