/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.tiger.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.Structure;
import org.polarsys.capella.core.data.capellacore.Trace;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.model.handler.helpers.HoldingResourceHelper;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.tiger.ITransfo;
import org.polarsys.capella.core.tiger.Messages;
import org.polarsys.capella.core.tiger.TransfoException;
import org.polarsys.capella.core.tiger.helpers.Query;
import org.polarsys.capella.core.tiger.impl.Transfo;

public final class TigerRelationshipHelper {
    protected static final Logger logger = ReportManagerRegistry.getInstance().subscribe("Refinement");
    public static final String PROPERTY_TRANSFO_UID = "TransfoUID";

    private TigerRelationshipHelper() {
    }

    public static boolean attachElementByRel(EObject element, EObject relatedElement, EReference relationship) {
        String nlsKey;
        if (element == null) {
            throw new NullPointerException(Messages.TigerRelationshipHelper_CannotAttachNull);
        }
        if (relationship == null) {
            return false;
        }
        boolean done = false;
        boolean alreadyExist = false;
        if (TigerRelationshipHelper.isApplicable(element.eClass(), (EStructuralFeature)relationship)) {
            if (relationship.isContainment()) {
                HoldingResourceHelper.ensureMoveElement((EObject)relatedElement, (EObject)element);
            }
            if (!relationship.isMany()) {
                if (element.eGet((EStructuralFeature)relationship) == null && relatedElement != null || element.eGet((EStructuralFeature)relationship) != null && !element.eGet((EStructuralFeature)relationship).equals(relatedElement)) {
                    element.eSet((EStructuralFeature)relationship, (Object)relatedElement);
                    done = true;
                } else if (element.eGet((EStructuralFeature)relationship) == null && relatedElement == null || element.eGet((EStructuralFeature)relationship) != null && element.eGet((EStructuralFeature)relationship).equals(relatedElement)) {
                    alreadyExist = true;
                }
            } else {
                EList list = (EList)element.eGet((EStructuralFeature)relationship);
                if (list.contains((Object)relatedElement)) {
                    done = false;
                    alreadyExist = true;
                } else {
                    try {
                        list.add((Object)relatedElement);
                        done = true;
                    }
                    catch (ArrayStoreException | IllegalArgumentException ex) {
                        done = false;
                    }
                }
            }
        }
        if (done && logger.isInfoEnabled()) {
            nlsKey = null;
            nlsKey = relationship.isContainment() ? Messages.TigerRelationshipHelper_ContainedBy : Messages.TigerRelationshipHelper_ReferencedBy;
            String text = NLS.bind((String)nlsKey, (Object[])new Object[]{EObjectLabelProviderHelper.getText((Object)relatedElement), EObjectLabelProviderHelper.getText((Object)element), relationship.getName()});
            logger.info((Object)new EmbeddedMessage(text, logger.getName(), (Object)new Object[]{relatedElement, element}));
        } else if (!alreadyExist) {
            nlsKey = null;
            nlsKey = relationship.isContainment() ? Messages.TigerRelationshipHelper_ShouldBeContainedBy : Messages.TigerRelationshipHelper_ShouldBeReferencedBy;
            String text = NLS.bind((String)nlsKey, (Object[])new Object[]{EObjectLabelProviderHelper.getText((Object)relatedElement), EObjectLabelProviderHelper.getText((Object)element), relationship.getName()});
            logger.warn((Object)new EmbeddedMessage(text, logger.getName(), (Object)new Object[]{relatedElement, element}));
        }
        if (logger.isDebugEnabled()) {
            String message = "          => Attempt attach " + EObjectExt.getText((EObject)element) + "---" + relationship.getName() + "--->" + EObjectExt.getText((EObject)relatedElement);
            message = done ? String.valueOf(message) + " -> [OK] " : String.valueOf(message) + " -> [KO] ";
            logger.debug((Object)message);
        }
        return done;
    }

    public static void attachIemeWithIeme(EObject sourceElement, EClass sourceEClass, EClass targetEClass, EReference relationshipMapping, ITransfo transfo) {
        int i = 0;
        for (EObject eObject : Query.retrieveTransformedElements(sourceElement, transfo, sourceEClass)) {
            int j = 0;
            for (EObject eObject2 : Query.retrieveTransformedElements((EObject)sourceElement.eGet((EStructuralFeature)relationshipMapping), transfo, targetEClass)) {
                if (i == j) {
                    TigerRelationshipHelper.attachElementByRel(eObject, eObject2, relationshipMapping);
                }
                ++j;
            }
            ++i;
        }
    }

    @Deprecated
    public static void attachLikeSourceContainerRelation(EObject srcElt, ITransfo transfo) {
        for (EObject eObject : Query.retrieveTransformedElements(srcElt, transfo)) {
            for (EObject eObject2 : Query.retrieveTransformedElements(srcElt.eContainer(), transfo)) {
                EcoreUtil2.attachLikeSourceContainmentFeature((EObject)srcElt, (EObject)eObject, (EObject)eObject2);
            }
        }
    }

    public static void attachToBestElement(EObject element, EReference reference, ITransfo transfo) {
        if (element == null || !TigerRelationshipHelper.isApplicable(element.eClass(), (EStructuralFeature)reference)) {
            return;
        }
        for (EObject eObject : Query.retrieveTransformedElements(element, transfo)) {
            if (!TigerRelationshipHelper.isApplicable(eObject.eClass(), (EStructuralFeature)reference)) continue;
            Object resultTarget = eObject.eGet((EStructuralFeature)reference);
            for (EObject sourceElement : TigerRelationshipHelper.retrieveReferenceAsList(element, reference)) {
                for (EObject bestElement : TigerRelationshipHelper.retrieveBestElements(eObject, sourceElement, (EClass)reference.getEType(), transfo)) {
                    if (!reference.isMany() && resultTarget != null && !resultTarget.equals(sourceElement) && !resultTarget.equals(bestElement)) continue;
                    if (bestElement != sourceElement) {
                        TigerRelationshipHelper.detachElementByRel(eObject, sourceElement, reference);
                    }
                    TigerRelationshipHelper.attachElementByRel(eObject, bestElement, reference);
                }
            }
        }
    }

    public static boolean attachTraceToNearestContainer(EObject object, Trace trace) {
        Structure container = null;
        EObject currentObject = object;
        while (currentObject != null) {
            if (object instanceof Structure) {
                container = (Structure)object;
            }
            currentObject = currentObject.eContainer();
        }
        if (container != null) {
            container.getOwnedTraces().add((Object)trace);
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean attachTransformedContainedElements(EObject sourceElement, ITransfo transfo, EReference relationship) {
        return TigerRelationshipHelper.attachTransformedContainedElementsByMapping(sourceElement, transfo, relationship, relationship);
    }

    @Deprecated
    public static boolean attachTransformedContainedElementsByMapping(EObject sourceElement, ITransfo transfo, EReference sourceRelationship, EReference targetRelationship) {
        return TigerRelationshipHelper.attachTransformedContainedElementsByMapping(sourceElement, transfo, sourceRelationship, targetRelationship, null, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public static boolean attachTransformedContainedElementsByMapping(EObject sourceElement, ITransfo transfo, EReference sourceRelationship, EReference targetRelationship, EClass expectedTarget, EClass expectedTargetContainer) {
        if (!sourceElement.eContainmentFeature().equals(sourceRelationship)) {
            return false;
        }
        Object te = Query.retrieveTransformedElement(sourceElement, transfo, expectedTarget);
        if (te == null) {
            return false;
        }
        if (te instanceof EObject) {
            EObject targetElement = (EObject)te;
            EObject currentTgtContainerElt = targetElement.eContainer();
            EObject srcContainerElt = sourceElement.eContainer();
            Object tgtContainerElt = Query.retrieveTransformedElement(srcContainerElt, transfo, expectedTargetContainer);
            if (tgtContainerElt instanceof EObject) {
                if (currentTgtContainerElt == tgtContainerElt) {
                    return true;
                }
                if (TigerRelationshipHelper.attachElementByRel((EObject)tgtContainerElt, targetElement, targetRelationship)) return true;
                return false;
            }
            boolean isAttached = false;
            for (EObject tgtContainerE : (List)tgtContainerElt) {
                if (currentTgtContainerElt == tgtContainerE) {
                    return true;
                }
                if (!TigerRelationshipHelper.attachElementByRel(tgtContainerE, targetElement, targetRelationship)) continue;
                isAttached = true;
                if (!targetRelationship.isContainment()) continue;
                return true;
            }
            return isAttached;
        }
        List tes = (List)te;
        for (EObject targetElement : tes) {
            EObject srcContainerElt;
            EObject tgtContainerElt;
            EObject currentTgtContainerElt = targetElement.eContainer();
            if (currentTgtContainerElt == (tgtContainerElt = Query.retrieveFirstTransformedElement(srcContainerElt = sourceElement.eContainer(), transfo, expectedTargetContainer))) {
                return true;
            }
            if (TigerRelationshipHelper.attachElementByRel(tgtContainerElt, targetElement, targetRelationship)) continue;
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean attachTransformedContainedElementsInBestContainer(EObject sourceElement, ITransfo transfo, EReference sourceRelationship, EReference targetRelationship, EClass expectedTarget, EClass expectedTargetContainer) {
        if (!sourceElement.eContainmentFeature().equals(sourceRelationship)) {
            return false;
        }
        targetElement = Query.retrieveFirstTransformedElement(sourceElement, transfo, expectedTarget);
        if (targetElement == null) {
            return false;
        }
        currentTgtContainerElt = targetElement.eContainer();
        srcContainerElt = sourceElement.eContainer();
        tgtContainerElt = Query.retrieveFirstTransformedElement(srcContainerElt, transfo, expectedTargetContainer);
        if (tgtContainerElt == null || currentTgtContainerElt != tgtContainerElt) ** GOTO lbl15
        return true;
lbl-1000:
        // 1 sources

        {
            if (tgtContainerElt != null && EcoreUtil2.isEqualOrSuperClass((EClass)expectedTargetContainer, (EClass)tgtContainerElt.eClass()) && TigerRelationshipHelper.attachElementByRel(tgtContainerElt, targetElement, targetRelationship)) {
                return true;
            }
            srcContainerElt = srcContainerElt.eContainer();
            tgtContainerElt = Query.retrieveFirstTransformedElement(srcContainerElt, transfo, expectedTargetContainer);
lbl15:
            // 2 sources

            ** while (srcContainerElt != null)
        }
lbl16:
        // 1 sources

        return false;
    }

    @Deprecated
    public static boolean attachTransformedContainedElementsPreserveOrder(EObject element, ITransfo transfo, EReference relationship) {
        return TigerRelationshipHelper.attachTransformedContainedElementsPreserveOrder(element, transfo, relationship, relationship);
    }

    @Deprecated
    public static boolean attachTransformedContainedElementsPreserveOrder(EObject sourceElement, ITransfo transfo, EReference sourceRelationship, EReference targetRelationship) {
        EObject sourceContainerElement;
        EObject targetContainerElement;
        if (!sourceElement.eContainmentFeature().equals(sourceRelationship)) {
            return false;
        }
        EObject targetElement = (EObject)Query.retrieveTransformedElement(sourceElement, transfo);
        if (targetElement == null) {
            return false;
        }
        EObject currentTargetContainerElement = targetElement.eContainer();
        if (currentTargetContainerElement == (targetContainerElement = (EObject)Query.retrieveTransformedElement(sourceContainerElement = sourceElement.eContainer(), transfo))) {
            return true;
        }
        if (!sourceRelationship.isMany()) {
            return TigerRelationshipHelper.attachElementByRel(targetContainerElement, targetElement, targetRelationship);
        }
        EList srcList = (EList)sourceContainerElement.eGet((EStructuralFeature)sourceRelationship);
        EList tgtList = (EList)targetContainerElement.eGet((EStructuralFeature)targetRelationship);
        int indiceOfElementToAddInSource = srcList.indexOf((Object)sourceElement);
        if (tgtList.isEmpty()) {
            return TigerRelationshipHelper.attachElementByRel(targetContainerElement, targetElement, targetRelationship);
        }
        HashMap<EObject, EObject> inverseTransfo = new HashMap<EObject, EObject>();
        for (EObject srcObj : srcList) {
            EObject tgtObj = (EObject)Query.retrieveTransformedElement(srcObj, transfo);
            inverseTransfo.put(tgtObj, srcObj);
        }
        int indice = tgtList.size() - 1;
        while (indice >= 0) {
            EObject tgtObject = (EObject)tgtList.get(indice);
            EObject srcObject = (EObject)inverseTransfo.get(tgtObject);
            if (srcList.indexOf((Object)srcObject) < indiceOfElementToAddInSource) break;
            --indice;
        }
        tgtList.add(indice + 1, (Object)targetElement);
        return true;
    }

    public static void attachTransformedRelatedElements(EObject sourceElement, EReference relationship, ITransfo transfo) {
        TigerRelationshipHelper.attachTransformedRelatedElementsByMapping(sourceElement, relationship, relationship, transfo);
    }

    public static void attachTransformedRelatedElements(EObject sourceElement, EReference[] relationships, ITransfo transfo) {
        EReference[] eReferenceArray = relationships;
        int n = relationships.length;
        int n2 = 0;
        while (n2 < n) {
            EReference relationship = eReferenceArray[n2];
            TigerRelationshipHelper.attachTransformedRelatedElements(sourceElement, relationship, transfo);
            ++n2;
        }
    }

    public static void attachTransformedRelatedElements(EObject sourceElement, ITransfo transfo, EReference relationship) {
        TigerRelationshipHelper.attachTransformedRelatedElementsByMapping(sourceElement, relationship, relationship, transfo);
    }

    public static void attachTransformedRelatedElementsByMapping(EObject sourceElement, EReference relationshipInSource, EReference relationshipInTarget, ITransfo transfo) {
        List<EObject> sourceRelatedElements = Query.retrieveRelatedElements(sourceElement, relationshipInSource);
        ArrayList<EObject> targetRelatedElements = new ArrayList<EObject>();
        for (EObject sourceRelatedElement : sourceRelatedElements) {
            Object tre;
            if (sourceRelatedElement == null || (tre = Query.retrieveTransformedElement(sourceRelatedElement, transfo)) == null) continue;
            if (tre instanceof EObject) {
                EObject eObject = (EObject)tre;
                targetRelatedElements.add(eObject);
                continue;
            }
            List list = (List)tre;
            for (EObject targetRelatedElement : list) {
                targetRelatedElements.add(targetRelatedElement);
            }
        }
        List<? extends EObject> targetElements = Query.retrieveTransformedElements(sourceElement, transfo);
        for (EObject newlyCreatedElement : targetRelatedElements) {
            for (EObject eObject : targetElements) {
                if (!TigerRelationshipHelper.isApplicable(eObject.eClass(), (EStructuralFeature)relationshipInTarget)) continue;
                TigerRelationshipHelper.attachElementByRel(eObject, newlyCreatedElement, relationshipInTarget);
            }
        }
    }

    public static void invertedAttachTransformedRelatedElements(EObject sourceElement, EReference sourceReference, EReference targetReference, ITransfo transfo) {
        List<EObject> sourceRelatedElements = Query.retrieveRelatedElements(sourceElement, sourceReference);
        ArrayList<EObject> targetRelatedElements = new ArrayList<EObject>();
        for (EObject sourceRelatedElement : sourceRelatedElements) {
            Object tre;
            if (sourceRelatedElement == null || (tre = Query.retrieveTransformedElement(sourceRelatedElement, transfo)) == null) continue;
            if (tre instanceof EObject) {
                EObject targetRelatedElement = (EObject)tre;
                targetRelatedElements.add(targetRelatedElement);
                continue;
            }
            List tres = (List)tre;
            for (EObject targetRelatedElement : tres) {
                targetRelatedElements.add(targetRelatedElement);
            }
        }
        List<? extends EObject> targetElements = Query.retrieveTransformedElements(sourceElement, transfo);
        for (EObject eObject : targetElements) {
            for (EObject newlyCreatedElement : targetRelatedElements) {
                if (!TigerRelationshipHelper.isApplicable(eObject.eClass(), (EStructuralFeature)targetReference)) continue;
                TigerRelationshipHelper.attachElementByRel(newlyCreatedElement, eObject, targetReference);
            }
        }
    }

    public static void attachTransformedRelatedElementsByMapping(EObject sourceElement, ITransfo transfo, EReference relationshipInSource, EReference relationshipInTarget) {
        TigerRelationshipHelper.attachTransformedRelatedElementsByMapping(sourceElement, relationshipInSource, relationshipInTarget, transfo);
    }

    public static void attachTransformedRelatedElementsByMapping(EObject sourceElement, List<EReference[]> relationshipMapping, ITransfo transfo) {
        for (EReference[] mapping : relationshipMapping) {
            TigerRelationshipHelper.attachTransformedRelatedElementsByMapping(sourceElement, mapping[0], mapping[1], transfo);
        }
    }

    public static void attachUnattachedIntoSameContainer(EObject source, EClass targetEClass, EReference relationship, ITransfo transfo) {
        EObject newContainer = source.eContainer();
        for (EObject eObject : Query.retrieveUnattachedTransformedElements(source, transfo, targetEClass)) {
            TigerRelationshipHelper.attachElementByRel(newContainer, eObject, relationship);
        }
    }

    public static void attachUnattachedIntoTransformedContainer(EObject source, EClass targetEClass, EReference relationship, ITransfo transfo) {
        for (EObject eObject : Query.retrieveTransformedElements(source.eContainer(), transfo)) {
            if (!TigerRelationshipHelper.isApplicable(eObject.eClass(), (EStructuralFeature)relationship)) continue;
            for (EObject eObject2 : Query.retrieveUnattachedTransformedElements(source, transfo, targetEClass)) {
                TigerRelationshipHelper.attachElementByRel(eObject, eObject2, relationship);
            }
        }
    }

    public static void attachUnattachedIntoTransformedContainer(EObject source, EClass targetEClass, EReference[] relationships, ITransfo transfo) {
        block0: for (EObject eObject : Query.retrieveTransformedElements(source.eContainer(), transfo)) {
            boolean isAttached = false;
            EReference[] eReferenceArray = relationships;
            int n = relationships.length;
            int n2 = 0;
            while (n2 < n) {
                EReference relationship = eReferenceArray[n2];
                if (TigerRelationshipHelper.isApplicable(eObject.eClass(), (EStructuralFeature)relationship)) {
                    for (EObject eObject2 : Query.retrieveUnattachedTransformedElements(source, transfo, targetEClass)) {
                        TigerRelationshipHelper.attachElementByRel(eObject, eObject2, relationship);
                    }
                    isAttached = true;
                }
                if (isAttached) continue block0;
                ++n2;
            }
        }
    }

    public static void attachUnattachedIntoTransformedContainer(EObject source, EObject targetElement, EReference relationship, ITransfo transfo) {
        for (EObject eObject : Query.retrieveTransformedElements(source.eContainer(), transfo)) {
            if (!TigerRelationshipHelper.isApplicable(eObject.eClass(), (EStructuralFeature)relationship)) continue;
            TigerRelationshipHelper.attachElementByRel(eObject, targetElement, relationship);
            break;
        }
    }

    public static void attachUnattachedIntoTransformedContainerLikeSource(EObject source, EClass targetEClass, ITransfo transfo) {
        TigerRelationshipHelper.attachUnattachedIntoTransformedContainer(source, targetEClass, (EReference)source.eContainingFeature(), transfo);
    }

    public static void attachUnattachedIntoTransformedGivenContainer(EObject source, EObject givenContainer, EClass targetEClass, EReference relationship, ITransfo transfo) {
        for (EObject eObject : Query.retrieveTransformedElements(givenContainer, transfo)) {
            boolean isAttached = false;
            if (TigerRelationshipHelper.isApplicable(eObject.eClass(), (EStructuralFeature)relationship)) {
                for (EObject eObject2 : Query.retrieveUnattachedTransformedElements(source, transfo, targetEClass)) {
                    TigerRelationshipHelper.attachElementByRel(eObject, eObject2, relationship);
                }
                isAttached = true;
            }
            if (isAttached) break;
        }
    }

    private static AbstractTrace createAbstractTrace(EObject sourceType, EObject targetType, ITransfo transfo) throws TransfoException {
        AbstractTrace abstractTrace = null;
        EClass eGenericTraceFound = null;
        if (transfo instanceof Transfo && (eGenericTraceFound = ((Transfo)transfo).getSpecificLinkKindFromMap(sourceType, targetType)) == null) {
            eGenericTraceFound = ((Transfo)transfo).get_eDefaultTrace();
        }
        if (eGenericTraceFound != null) {
            EFactory factory = eGenericTraceFound.getEPackage().getEFactoryInstance();
            abstractTrace = TigerRelationshipHelper.traceExists(targetType, sourceType, eGenericTraceFound);
            if (abstractTrace == null) {
                EObject eObject = factory.create(eGenericTraceFound);
                if (eObject == null) {
                    throw new TransfoException(eGenericTraceFound);
                }
                if (eObject instanceof AbstractTrace) {
                    abstractTrace = (AbstractTrace)eObject;
                }
            }
        }
        return abstractTrace;
    }

    public static AbstractTrace createTransfoLink(EObject sourceObject, EObject targetObject, ITransfo transfo) throws TransfoException {
        CapellaElement targetElement;
        CapellaElement sourceElement;
        AbstractTrace abstractTrace = null;
        if (sourceObject instanceof CapellaElement && targetObject instanceof CapellaElement && (abstractTrace = TigerRelationshipHelper.createAbstractTrace((EObject)(sourceElement = (CapellaElement)sourceObject), (EObject)(targetElement = (CapellaElement)targetObject), transfo)) != null) {
            abstractTrace.setSourceElement((TraceableElement)targetElement);
            abstractTrace.setTargetElement((TraceableElement)sourceElement);
        }
        return abstractTrace;
    }

    public static boolean detachElementByRel(EObject element, EObject relatedElement, EReference relationship) {
        if (element == null || relatedElement == null) {
            throw new NullPointerException(Messages.TigerRelationshipHelper_CannotAttachNull);
        }
        boolean done = false;
        if (!relationship.isMany()) {
            element.eUnset((EStructuralFeature)relationship);
            done = true;
        } else {
            EList list = (EList)element.eGet((EStructuralFeature)relationship);
            if (!list.contains((Object)relatedElement)) {
                done = false;
            } else {
                list.remove((Object)relatedElement);
                done = true;
            }
        }
        if (done && logger.isInfoEnabled()) {
            String text = NLS.bind((String)"Element ''{0}'' has been removed from ''{1}'' ({2})", (Object[])new Object[]{EObjectLabelProviderHelper.getText((Object)relatedElement), EObjectLabelProviderHelper.getText((Object)element), relationship.getName()});
            logger.info((Object)new EmbeddedMessage(text, logger.getName(), (Object)new Object[]{relatedElement, element}));
        }
        return done;
    }

    public static List<EObject> getJustContainer(EObject element) {
        ArrayList<EObject> relatedElements = new ArrayList<EObject>();
        relatedElements.add(element.eContainer());
        return relatedElements;
    }

    public static boolean isApplicable(EClass clazz, EStructuralFeature feature) {
        return EcoreUtil2.isEqualOrSuperClass((EClass)feature.getEContainingClass(), (EClass)clazz);
    }

    public static Collection<EObject> retrieveBestElements(EObject source, EObject object, EClass clazz, ITransfo transfo) {
        List<? extends EObject> objects = Query.retrieveTransformedElements(object, transfo, clazz);
        Collection<EObject> result = new LinkedList<EObject>();
        BlockArchitecture sourceArchitecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)source);
        for (EObject eObject : objects) {
            BlockArchitecture targetArchitecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)eObject);
            if (sourceArchitecture != null && targetArchitecture != null && !targetArchitecture.equals(sourceArchitecture) && !BlockArchitectureExt.getPreviousBlockArchitectures((BlockArchitecture)sourceArchitecture).contains(targetArchitecture)) continue;
            result.add(eObject);
        }
        if (result.isEmpty()) {
            result = Collections.singleton(object);
        }
        return result;
    }

    public static Collection<EObject> retrieveReferenceAsList(EObject object, EReference reference) {
        Object sourceReference = object.eGet((EStructuralFeature)reference);
        if (sourceReference instanceof Collection) {
            return (Collection)sourceReference;
        }
        return Collections.singleton((EObject)sourceReference);
    }

    private static AbstractTrace traceExists(EObject sourceTypeP, EObject targetTypeP, EClass eGenericTraceFound) {
        TraceableElement source = (TraceableElement)sourceTypeP;
        TraceableElement target = (TraceableElement)targetTypeP;
        for (AbstractTrace trace : source.getOutgoingTraces()) {
            if (trace.eClass() != eGenericTraceFound || trace.getTargetElement() != target) continue;
            return trace;
        }
        return null;
    }

    public static void updateElementByAttribute(EObject sourceElement, EObject targetElement, EAttribute attribute, ITransfo transfo) {
        EClass clazz;
        EClass clazzAttribute;
        if (targetElement != null && (clazzAttribute = (EClass)attribute.eContainer()).isSuperTypeOf(clazz = sourceElement.eClass())) {
            Object value = sourceElement.eGet((EStructuralFeature)attribute);
            targetElement.eSet((EStructuralFeature)attribute, value);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("       => Update attribute " + attribute.getName() + " on element " + EObjectExt.getText((EObject)targetElement)));
            }
        }
    }

    public static void updateElementByAttributeIfEmpty(EObject sourceElement, EObject targetElement, EAttribute attribute, ITransfo transfo) {
        if (targetElement != null) {
            EClass clazzAttribute = (EClass)attribute.eContainer();
            EClass clazzSource = sourceElement.eClass();
            EClass clazzTarget = targetElement.eClass();
            if (clazzAttribute.isSuperTypeOf(clazzSource) && clazzAttribute.isSuperTypeOf(clazzTarget)) {
                Object valueSource = sourceElement.eGet((EStructuralFeature)attribute);
                Object valueTarget = targetElement.eGet((EStructuralFeature)attribute);
                if (valueSource != null && valueSource != "" && (valueTarget == null || valueTarget instanceof String && ((String)valueTarget).length() == 0) && !valueSource.equals(valueTarget)) {
                    targetElement.eSet((EStructuralFeature)attribute, valueSource);
                    if (valueTarget != null && ((String)valueTarget).length() != 0 && logger.isInfoEnabled()) {
                        String text = NLS.bind((String)Messages.TigerRelationshipHelper_UpdateAttribute, (Object[])new Object[]{attribute.getName(), EObjectLabelProviderHelper.getText((Object)targetElement), Objects.toString(valueTarget), Objects.toString(valueSource)});
                        logger.info((Object)new EmbeddedMessage(text, logger.getName(), (Object)targetElement));
                    }
                }
            }
        }
    }

    public static void updateElementByProperty(EObject sourceElement, List<String> properties, ITransfo transfo) {
        for (String property : properties) {
            TigerRelationshipHelper.updateElementByProperty(sourceElement, property, transfo);
        }
    }

    public static void updateElementByProperty(EObject sourceElement, String property, ITransfo transfo) {
        EStructuralFeature featureSource;
        List<? extends EObject> targetElements = Query.retrieveTransformedElements(sourceElement, transfo);
        if (!targetElements.isEmpty() && (featureSource = sourceElement.eClass().getEStructuralFeature(property)) instanceof EAttribute) {
            EAttribute attribute = (EAttribute)featureSource;
            Object valueSource = sourceElement.eGet((EStructuralFeature)attribute);
            for (EObject eObject : targetElements) {
                EStructuralFeature featureTarget = eObject.eClass().getEStructuralFeature(property);
                if (featureTarget == null) continue;
                Object valueTarget = eObject.eGet((EStructuralFeature)attribute);
                if ((valueSource != null || valueTarget == null) && (valueSource == null || valueSource.equals(valueTarget))) continue;
                if (valueTarget != null && logger.isInfoEnabled()) {
                    String text = NLS.bind((String)Messages.TigerRelationshipHelper_UpdateAttribute, (Object[])new Object[]{attribute.getName(), EObjectLabelProviderHelper.getText((Object)eObject), Objects.toString(valueTarget), Objects.toString(valueSource)});
                    logger.info((Object)new EmbeddedMessage(text, logger.getName(), (Object)eObject));
                }
                eObject.eSet((EStructuralFeature)attribute, valueSource);
            }
        }
    }

    public static void attachToBestAndValidElements(EObject element, EReference reference, Collection<EObject> objects, ITransfo transfo) {
        if (element == null || !TigerRelationshipHelper.isApplicable(element.eClass(), (EStructuralFeature)reference)) {
            return;
        }
        for (EObject eObject : Query.retrieveTransformedElements(element, transfo)) {
            if (!TigerRelationshipHelper.isApplicable(eObject.eClass(), (EStructuralFeature)reference)) continue;
            Object resultTarget = eObject.eGet((EStructuralFeature)reference);
            for (EObject sourceElement : TigerRelationshipHelper.retrieveReferenceAsList(element, reference)) {
                for (EObject bestElement : TigerRelationshipHelper.retrieveBestElements(eObject, sourceElement, (EClass)reference.getEType(), transfo)) {
                    if (!objects.contains(bestElement) || !reference.isMany() && resultTarget != null && !resultTarget.equals(sourceElement) && !resultTarget.equals(bestElement)) continue;
                    if (bestElement != sourceElement) {
                        TigerRelationshipHelper.detachElementByRel(eObject, sourceElement, reference);
                    }
                    TigerRelationshipHelper.attachElementByRel(eObject, bestElement, reference);
                }
            }
        }
    }
}

