/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.pa;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum PhysicalComponentKind implements Enumerator
{
    UNSET(0, "UNSET", "UNSET"),
    HARDWARE(1, "HARDWARE", "HARDWARE"),
    HARDWARE_COMPUTER(2, "HARDWARE_COMPUTER", "HARDWARE_COMPUTER"),
    SOFTWARE(3, "SOFTWARE", "SOFTWARE"),
    SOFTWARE_DEPLOYMENT_UNIT(4, "SOFTWARE_DEPLOYMENT_UNIT", "SOFTWARE_DEPLOYMENT_UNIT"),
    SOFTWARE_EXECUTION_UNIT(5, "SOFTWARE_EXECUTION_UNIT", "SOFTWARE_EXECUTION_UNIT"),
    SOFTWARE_APPLICATION(6, "SOFTWARE_APPLICATION", "SOFTWARE_APPLICATION"),
    FIRMWARE(7, "FIRMWARE", "FIRMWARE"),
    PERSON(8, "PERSON", "PERSON"),
    FACILITIES(9, "FACILITIES", "FACILITIES"),
    DATA(10, "DATA", "DATA"),
    MATERIALS(11, "MATERIALS", "MATERIALS"),
    SERVICES(12, "SERVICES", "SERVICES"),
    PROCESSES(13, "PROCESSES", "PROCESSES");

    public static final int UNSET_VALUE = 0;
    public static final int HARDWARE_VALUE = 1;
    public static final int HARDWARE_COMPUTER_VALUE = 2;
    public static final int SOFTWARE_VALUE = 3;
    public static final int SOFTWARE_DEPLOYMENT_UNIT_VALUE = 4;
    public static final int SOFTWARE_EXECUTION_UNIT_VALUE = 5;
    public static final int SOFTWARE_APPLICATION_VALUE = 6;
    public static final int FIRMWARE_VALUE = 7;
    public static final int PERSON_VALUE = 8;
    public static final int FACILITIES_VALUE = 9;
    public static final int DATA_VALUE = 10;
    public static final int MATERIALS_VALUE = 11;
    public static final int SERVICES_VALUE = 12;
    public static final int PROCESSES_VALUE = 13;
    private static final PhysicalComponentKind[] VALUES_ARRAY;
    public static final List<PhysicalComponentKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new PhysicalComponentKind[]{UNSET, HARDWARE, HARDWARE_COMPUTER, SOFTWARE, SOFTWARE_DEPLOYMENT_UNIT, SOFTWARE_EXECUTION_UNIT, SOFTWARE_APPLICATION, FIRMWARE, PERSON, FACILITIES, DATA, MATERIALS, SERVICES, PROCESSES};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static PhysicalComponentKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PhysicalComponentKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PhysicalComponentKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PhysicalComponentKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PhysicalComponentKind get(int value) {
        switch (value) {
            case 0: {
                return UNSET;
            }
            case 1: {
                return HARDWARE;
            }
            case 2: {
                return HARDWARE_COMPUTER;
            }
            case 3: {
                return SOFTWARE;
            }
            case 4: {
                return SOFTWARE_DEPLOYMENT_UNIT;
            }
            case 5: {
                return SOFTWARE_EXECUTION_UNIT;
            }
            case 6: {
                return SOFTWARE_APPLICATION;
            }
            case 7: {
                return FIRMWARE;
            }
            case 8: {
                return PERSON;
            }
            case 9: {
                return FACILITIES;
            }
            case 10: {
                return DATA;
            }
            case 11: {
                return MATERIALS;
            }
            case 12: {
                return SERVICES;
            }
            case 13: {
                return PROCESSES;
            }
        }
        return null;
    }

    private PhysicalComponentKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

