/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.viewers;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.emf.diffmerge.generic.api.IMatch;
import org.eclipse.emf.diffmerge.generic.api.Role;
import org.eclipse.emf.diffmerge.generic.api.diff.IDifference;
import org.eclipse.emf.diffmerge.generic.api.diff.IReferenceValuePresence;
import org.eclipse.emf.diffmerge.generic.api.diff.IValuePresence;
import org.eclipse.emf.diffmerge.generic.api.scopes.IEditableTreeDataScope;
import org.eclipse.emf.diffmerge.generic.api.scopes.IRawDataScope;
import org.eclipse.emf.diffmerge.generic.api.scopes.ITreeDataScope;
import org.eclipse.emf.diffmerge.generic.gdiffdata.GComparison;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.diffuidata.UIComparison;
import org.eclipse.emf.diffmerge.ui.diffuidata.impl.UIComparisonImpl;
import org.eclipse.emf.diffmerge.ui.setup.ModelScopeTypedElement;
import org.eclipse.emf.diffmerge.ui.util.CompositeUndoContext;
import org.eclipse.emf.diffmerge.ui.util.IUserPropertyOwner;
import org.eclipse.emf.diffmerge.ui.util.UserProperty;
import org.eclipse.emf.diffmerge.ui.util.UserPropertyOwner;
import org.eclipse.emf.diffmerge.ui.viewers.CategoryManager;
import org.eclipse.emf.diffmerge.ui.viewers.ComparisonResourceManager;
import org.eclipse.emf.diffmerge.ui.viewers.DefaultUserProperties;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.emf.workspace.ResourceUndoContext;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.ui.IEditorInput;

public class EMFDiffNode
extends DiffNode
implements IEditingDomainProvider,
IUserPropertyOwner {
    private final ComparisonResourceManager _resourceManager = new ComparisonResourceManager();
    private final UIComparison _contents;
    private final EditingDomain _editingDomain;
    protected IOperationHistoryListener _domainChangeListener;
    private IEditorInput _editorInput;
    private Role _drivingRole;
    private Role _leftRole;
    private Role _twoWayReferenceRole;
    private final CategoryManager _categoryManager;
    private boolean _isTargetEditable;
    private boolean _isReferenceEditable;
    private boolean _isTargetEditionPossible;
    private boolean _isReferenceEditionPossible;
    private boolean _isTargetModified;
    private boolean _isReferenceModified;
    private final IUserPropertyOwner _userPropertyOwnerDelegate;

    public EMFDiffNode(GComparison<?, ?, ?> comparison_p) {
        this(comparison_p, null);
    }

    public EMFDiffNode(GComparison<?, ?, ?> comparison_p, EditingDomain domain_p) {
        this(comparison_p, domain_p, true, true);
    }

    public EMFDiffNode(GComparison<?, ?, ?> comparison_p, EditingDomain domain_p, boolean isLeftEditionPossible_p, boolean isRightEditionPossible_p) {
        this(comparison_p, domain_p, isLeftEditionPossible_p, isRightEditionPossible_p, EMFDiffMergeUIPlugin.getDefault().getDefaultLeftRole());
    }

    public EMFDiffNode(GComparison<?, ?, ?> comparison_p, EditingDomain domain_p, boolean isLeftEditionPossible_p, boolean isRightEditionPossible_p, Role leftRole_p) {
        super(3, (ITypedElement)(comparison_p.isThreeWay() ? new ModelScopeTypedElement((IRawDataScope<?>)comparison_p.getScope(Role.ANCESTOR)) : null), (ITypedElement)new ModelScopeTypedElement((IRawDataScope<?>)comparison_p.getScope(leftRole_p)), (ITypedElement)new ModelScopeTypedElement((IRawDataScope<?>)comparison_p.getScope(leftRole_p.opposite())));
        this._contents = this.createContents(comparison_p);
        this._editingDomain = domain_p;
        this._editorInput = null;
        this._leftRole = leftRole_p;
        this._twoWayReferenceRole = null;
        this._categoryManager = new CategoryManager(this);
        this._isTargetEditionPossible = leftRole_p == Role.TARGET ? isLeftEditionPossible_p : isRightEditionPossible_p;
        this._isReferenceEditionPossible = leftRole_p == Role.TARGET ? isRightEditionPossible_p : isLeftEditionPossible_p;
        this._isTargetEditable = true;
        this._isReferenceEditable = true;
        this._isTargetModified = false;
        this._isReferenceModified = false;
        this._drivingRole = this.getTargetRole() != null ? this.getTargetRole() : this._leftRole;
        this._domainChangeListener = domain_p == null ? null : this.createDomainListener(domain_p);
        this._userPropertyOwnerDelegate = new UserPropertyOwner();
    }

    @Override
    public <T> boolean addUserProperty(UserProperty.Identifier<T> id_p, T initialValue_p) {
        return this.getUserPropertyOwnerDelegate().addUserProperty(id_p, initialValue_p);
    }

    @Override
    public boolean addUserPropertyChangeListener(UserProperty.Identifier<?> id_p, IPropertyChangeListener listener_p) {
        return this.getUserPropertyOwnerDelegate().addUserPropertyChangeListener(id_p, listener_p);
    }

    protected UIComparison createContents(GComparison<?, ?, ?> comparison_p) {
        return new UIComparisonImpl(comparison_p);
    }

    protected IOperationHistoryListener createDomainListener(EditingDomain domain_p) {
        IOperationHistoryListener result = null;
        if (domain_p.getCommandStack() instanceof IWorkspaceCommandStack) {
            IOperationHistory opHistory = ((IWorkspaceCommandStack)domain_p.getCommandStack()).getOperationHistory();
            result = new IOperationHistoryListener(){

                public void historyNotification(OperationHistoryEvent event_p) {
                    IUndoContext undoContext = EMFDiffNode.this.getUndoContext();
                    if (undoContext != null && event_p.getOperation().hasContext(undoContext)) {
                        switch (event_p.getEventType()) {
                            case 5: 
                            case 9: 
                            case 10: {
                                EMFDiffNode.this.updateDifferenceNumbers();
                            }
                        }
                    }
                }
            };
            opHistory.addOperationHistoryListener(result);
        }
        return result;
    }

    public void dispose() {
        this._resourceManager.dispose();
        this.getUserPropertyOwnerDelegate().dispose();
        EditingDomain domain = this.getEditingDomain();
        if (domain != null && this._domainChangeListener != null) {
            IOperationHistory opHistory = ((IWorkspaceCommandStack)domain.getCommandStack()).getOperationHistory();
            opHistory.removeOperationHistoryListener(this._domainChangeListener);
            this._domainChangeListener = null;
        }
        this._editorInput = null;
    }

    public GComparison getActualComparison() {
        return this.getUIComparison().getActualComparison();
    }

    public CategoryManager getCategoryManager() {
        return this._categoryManager;
    }

    protected IMatch<?> getContainerOf(IMatch<?> match_p) {
        IMatch result = null;
        GComparison comparison = this.getActualComparison();
        if (comparison != null) {
            Role drivingRole = this.getDrivingRole();
            Role containerSide = match_p.getUncoveredRole() == drivingRole ? drivingRole.opposite() : drivingRole;
            result = comparison.getContainerOf(match_p, containerSide);
        }
        return result;
    }

    public Role getDrivingRole() {
        return this._drivingRole;
    }

    public EditingDomain getEditingDomain() {
        return this._editingDomain;
    }

    public IEditorInput getEditorInput() {
        return this._editorInput;
    }

    public Role getReferenceRole() {
        return this.isThreeWay() ? Role.ANCESTOR : this._twoWayReferenceRole;
    }

    public ComparisonResourceManager getResourceManager() {
        return this._resourceManager;
    }

    public Role getRoleForSide(boolean left_p) {
        return left_p ? this._leftRole : this._leftRole.opposite();
    }

    public IEditableTreeDataScope<?> getScope(boolean left_p) {
        GComparison comparison = this.getActualComparison();
        return comparison != null ? comparison.getScope(this.getRoleForSide(left_p)) : null;
    }

    public Role getTargetRole() {
        Role result = null;
        boolean leftEditable = this.isEditable(true);
        boolean rightEditable = this.isEditable(false);
        if (leftEditable && !rightEditable) {
            result = this.getRoleForSide(true);
        } else if (!leftEditable && rightEditable) {
            result = this.getRoleForSide(false);
        }
        return result;
    }

    public UIComparison getUIComparison() {
        return this._contents;
    }

    public IUndoContext getUndoContext() {
        CompositeUndoContext result = null;
        if (this.isReactive()) {
            Resource coreResource;
            Resource uiResource;
            HashSet<IUndoContext> contexts = new HashSet<IUndoContext>();
            TransactionalEditingDomain tDomain = (TransactionalEditingDomain)this.getEditingDomain();
            IWorkspaceCommandStack cmdStack = (IWorkspaceCommandStack)tDomain.getCommandStack();
            IUndoContext defaultContext = cmdStack.getDefaultUndoContext();
            if (defaultContext != null) {
                contexts.add(defaultContext);
            }
            if ((uiResource = this.getUIComparison().eResource()) != null) {
                contexts.add((IUndoContext)new ResourceUndoContext(tDomain, uiResource));
            }
            if ((coreResource = this.getActualComparison().eResource()) != null) {
                contexts.add((IUndoContext)new ResourceUndoContext(tDomain, coreResource));
            }
            result = new CompositeUndoContext(contexts);
        }
        return result;
    }

    @Override
    public Collection<UserProperty.Identifier<?>> getUserProperties() {
        return this.getUserPropertyOwnerDelegate().getUserProperties();
    }

    protected IUserPropertyOwner getUserPropertyOwnerDelegate() {
        return this._userPropertyOwnerDelegate;
    }

    @Override
    public <T> T getUserPropertyValue(UserProperty.Identifier<T> id_p) {
        return this.getUserPropertyOwnerDelegate().getUserPropertyValue(id_p);
    }

    public boolean hasChildren() {
        GComparison comparison = this.getActualComparison();
        return comparison != null ? comparison.hasRemainingDifferences() : false;
    }

    public boolean isReactive() {
        boolean result;
        boolean bl = result = this._domainChangeListener != null;
        if (result) {
            Resource mainResource = this.getUIComparison().eResource();
            result = mainResource != null && this.getEditingDomain().getResourceSet().getResources().contains((Object)mainResource);
        }
        return result;
    }

    @Override
    public boolean hasUserProperty(UserProperty.Identifier<?> id_p) {
        return this.getUserPropertyOwnerDelegate().hasUserProperty(id_p);
    }

    public void ignore(Collection<? extends IDifference<?>> differences_p) {
        for (IDifference<?> difference : differences_p) {
            IReferenceValuePresence symmetricalOwnership;
            if (!(difference instanceof IDifference.Editable)) continue;
            ((IDifference.Editable)difference).setIgnored(true);
            if (!(difference instanceof IValuePresence)) continue;
            IValuePresence symmetrical = ((IValuePresence)difference).getSymmetrical();
            if (symmetrical instanceof IDifference.Editable) {
                ((IDifference.Editable)symmetrical).setIgnored(true);
            }
            if (!(difference instanceof IReferenceValuePresence) || !((symmetricalOwnership = ((IReferenceValuePresence)difference).getSymmetricalOwnership()) instanceof IDifference.Editable)) continue;
            ((IDifference.Editable)symmetricalOwnership).setIgnored(true);
        }
    }

    public boolean isContainer(Object reference_p) {
        boolean result = false;
        GComparison comparison = this.getActualComparison();
        if (comparison != null) {
            ITreeDataScope scope = comparison.getScope(this.getDrivingRole());
            result = scope.mIsContainerReference(reference_p);
        }
        return result;
    }

    public boolean isContainment(Object reference_p) {
        boolean result = false;
        GComparison comparison = this.getActualComparison();
        if (comparison != null) {
            ITreeDataScope scope = comparison.getScope(this.getDrivingRole());
            result = scope.mIsContainmentReference(reference_p);
        }
        return result;
    }

    public boolean isEditable(boolean left_p) {
        boolean result = this.isEditionPossible(left_p);
        if (result) {
            result = this.getRoleForSide(left_p) == Role.TARGET ? this._isTargetEditable : this._isReferenceEditable;
        }
        return result;
    }

    public boolean isEditionPossible(boolean left_p) {
        return this.getRoleForSide(left_p) == Role.TARGET ? this._isTargetEditionPossible : this._isReferenceEditionPossible;
    }

    public boolean isEmpty() {
        return this.getCategoryManager().isEmpty();
    }

    public boolean isModified(boolean left_p) {
        return this.getRoleForSide(left_p) == Role.TARGET ? this._isTargetModified : this._isReferenceModified;
    }

    public boolean isThreeWay() {
        GComparison comparison = this.getActualComparison();
        return comparison != null ? comparison.isThreeWay() : false;
    }

    public boolean isUndoRedoSupported() {
        return this.getEditingDomain() != null && (!this.hasUserProperty(DefaultUserProperties.P_SUPPORT_UNDO_REDO) || this.isUserPropertyTrue(DefaultUserProperties.P_SUPPORT_UNDO_REDO));
    }

    @Override
    public boolean isUserPropertyFalse(UserProperty.Identifier<Boolean> id_p) {
        return this.getUserPropertyOwnerDelegate().isUserPropertyFalse(id_p);
    }

    @Override
    public boolean isUserPropertyTrue(UserProperty.Identifier<Boolean> id_p) {
        return this.getUserPropertyOwnerDelegate().isUserPropertyTrue(id_p);
    }

    @Override
    public boolean removeUserProperty(UserProperty.Identifier<?> id_p) {
        return this.getUserPropertyOwnerDelegate().removeUserProperty(id_p);
    }

    @Override
    public boolean removeUserPropertyChangeListener(UserProperty.Identifier<?> id_p, IPropertyChangeListener listener_p) {
        return this.getUserPropertyOwnerDelegate().removeUserPropertyChangeListener(id_p, listener_p);
    }

    @Override
    public void removeUserPropertyChangeListener(IPropertyChangeListener listener_p) {
        this.getUserPropertyOwnerDelegate().removeUserPropertyChangeListener(listener_p);
    }

    public void setDrivingRole(Role drivingRole_p) {
        if (Role.TARGET == drivingRole_p || Role.REFERENCE == drivingRole_p) {
            this._drivingRole = drivingRole_p;
        }
    }

    public void setEditable(boolean isEditable_p, boolean left_p) {
        if (this.isEditionPossible(left_p)) {
            if (this.getRoleForSide(left_p) == Role.TARGET) {
                this._isTargetEditable = isEditable_p;
            } else {
                this._isReferenceEditable = isEditable_p;
            }
        }
    }

    public void setEditionPossible(boolean possible_p, boolean left_p) {
        if (this.getRoleForSide(left_p) == Role.TARGET) {
            this._isTargetEditionPossible = possible_p;
        } else {
            this._isReferenceEditionPossible = possible_p;
        }
    }

    public void setEditorInput(IEditorInput editorInput_p) {
        this._editorInput = editorInput_p;
    }

    public void setLeftRole(Role leftRole_p) {
        if (Role.TARGET == leftRole_p || Role.REFERENCE == leftRole_p) {
            this._leftRole = leftRole_p;
        }
    }

    public void setModified(boolean isModified_p, boolean left_p) {
        if (this.getRoleForSide(left_p) == Role.TARGET) {
            this._isTargetModified = isModified_p;
        } else {
            this._isReferenceModified = isModified_p;
        }
    }

    public void setReferenceRole(Role role_p) {
        if (!this.isThreeWay()) {
            this._twoWayReferenceRole = role_p;
        }
    }

    @Override
    public <T> boolean setUserPropertyValue(UserProperty.Identifier<T> id_p, T newValue_p) {
        return this.getUserPropertyOwnerDelegate().setUserPropertyValue(id_p, newValue_p);
    }

    @Override
    public boolean setUserPropertyValue(UserProperty.Identifier<Boolean> id_p, boolean newValue_p) {
        return this.getUserPropertyOwnerDelegate().setUserPropertyValue(id_p, newValue_p);
    }

    public void updateDifferenceNumbers() {
        this.getCategoryManager().update();
        this.fireChange();
    }
}

