/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.skeleton.helpers;

import org.eclipse.emf.common.util.EList;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.core.data.capellacore.VisibilityKind;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.InformationFactory;
import org.polarsys.capella.core.data.information.datatype.BooleanType;
import org.polarsys.capella.core.data.information.datatype.DatatypeFactory;
import org.polarsys.capella.core.data.information.datatype.NumericType;
import org.polarsys.capella.core.data.information.datatype.NumericTypeKind;
import org.polarsys.capella.core.data.information.datatype.StringType;
import org.polarsys.capella.core.data.information.datavalue.BinaryExpression;
import org.polarsys.capella.core.data.information.datavalue.BinaryOperator;
import org.polarsys.capella.core.data.information.datavalue.DataValue;
import org.polarsys.capella.core.data.information.datavalue.DatavalueFactory;
import org.polarsys.capella.core.data.information.datavalue.LiteralBooleanValue;
import org.polarsys.capella.core.data.information.datavalue.LiteralNumericValue;
import org.polarsys.capella.core.data.information.datavalue.NumericValue;
import org.polarsys.capella.core.model.helpers.naming.NamingConstants;

public class PredefinedTypesHelper {
    private static final String __MIN_NAME = "";
    private static final String __MAX_NAME = "";
    private static final String __MIN_LENGTH_NAME = "";
    private static final String __MAX_LENGTH_NAME = "";
    private static final VisibilityKind __PREDEFINED_TYPE_VISIBILITY = VisibilityKind.PUBLIC;
    protected static final String __ZERO_VALUE = "0";
    protected static final String __ONE_VALUE = "1";
    protected static final String __8BITS_MAX_VALUE = "255";

    public static void createPredefinedDataTypes(DataPkg dtRootPkg_p) {
        DataPkg dtRootPkg = InformationFactory.eINSTANCE.createDataPkg(NamingConstants.PredefinedTypesCmd_predefinedDataTypePkg_name);
        dtRootPkg_p.getOwnedDataPkgs().add((Object)dtRootPkg);
        NumericType unsignedShort = PredefinedTypesHelper.newNumericType(NamingConstants.PredefinedTypesCmd_unsignedShort_name, true, NumericTypeKind.INTEGER, true, PredefinedTypesHelper.newLiteralNumericValue("", __ZERO_VALUE), false, null);
        EList predefinedDataTypes = dtRootPkg.getOwnedDataTypes();
        predefinedDataTypes.add(PredefinedTypesHelper.newPredefinedBoolean());
        predefinedDataTypes.add(PredefinedTypesHelper.newNumericType(NamingConstants.PredefinedTypesCmd_byte_name, true, NumericTypeKind.INTEGER, true, PredefinedTypesHelper.newLiteralNumericValue("", __ZERO_VALUE), true, (NumericValue)PredefinedTypesHelper.newLiteralNumericValue("", __8BITS_MAX_VALUE)));
        predefinedDataTypes.add(PredefinedTypesHelper.newPredefinedChar(unsignedShort));
        predefinedDataTypes.add(PredefinedTypesHelper.newNumericType(NamingConstants.PredefinedTypesCmd_double_name, false, NumericTypeKind.FLOAT));
        predefinedDataTypes.add(PredefinedTypesHelper.newNumericType(NamingConstants.PredefinedTypesCmd_float_name, false, NumericTypeKind.FLOAT));
        predefinedDataTypes.add(PredefinedTypesHelper.newNumericType(NamingConstants.PredefinedTypesCmd_hexadecimal_name, true, NumericTypeKind.INTEGER, true, PredefinedTypesHelper.newLiteralNumericValue("", __ZERO_VALUE), true, (NumericValue)PredefinedTypesHelper.newHexadecimalMaxValue()));
        predefinedDataTypes.add(PredefinedTypesHelper.newNumericType(NamingConstants.PredefinedTypesCmd_integer_name, true, NumericTypeKind.INTEGER));
        predefinedDataTypes.add(PredefinedTypesHelper.newNumericType(NamingConstants.PredefinedTypesCmd_long_name, true, NumericTypeKind.INTEGER));
        predefinedDataTypes.add(PredefinedTypesHelper.newNumericType(NamingConstants.PredefinedTypesCmd_longLong_name, true, NumericTypeKind.INTEGER));
        predefinedDataTypes.add(PredefinedTypesHelper.newNumericType(NamingConstants.PredefinedTypesCmd_short_name, true, NumericTypeKind.INTEGER));
        predefinedDataTypes.add(PredefinedTypesHelper.newPredefinedString(NamingConstants.PredefinedTypesCmd_string_name));
        predefinedDataTypes.add(PredefinedTypesHelper.newNumericType(NamingConstants.PredefinedTypesCmd_unsignedInteger_name, true, NumericTypeKind.INTEGER, true, PredefinedTypesHelper.newLiteralNumericValue("", __ZERO_VALUE), false, null));
        predefinedDataTypes.add(unsignedShort);
        predefinedDataTypes.add(PredefinedTypesHelper.newNumericType(NamingConstants.PredefinedTypesCmd_unsignedLong_name, true, NumericTypeKind.INTEGER, true, PredefinedTypesHelper.newLiteralNumericValue("", __ZERO_VALUE), false, null));
        predefinedDataTypes.add(PredefinedTypesHelper.newNumericType(NamingConstants.PredefinedTypesCmd_unsignedLongLong_name, true, NumericTypeKind.INTEGER, true, PredefinedTypesHelper.newLiteralNumericValue("", __ZERO_VALUE), false, null));
    }

    private static BooleanType newPredefinedBoolean() {
        BooleanType result = DatatypeFactory.eINSTANCE.createBooleanType();
        result.setVisibility(__PREDEFINED_TYPE_VISIBILITY);
        result.setName(NamingConstants.PredefinedTypesCmd_boolean_name);
        result.setDiscrete(true);
        LiteralBooleanValue tValue = DatavalueFactory.eINSTANCE.createLiteralBooleanValue();
        tValue.setName(NamingConstants.PredefinedTypesCmd_trueValue_name);
        tValue.setValue(true);
        tValue.setAbstractType((AbstractType)result);
        result.getOwnedLiterals().add((Object)tValue);
        LiteralBooleanValue fValue = DatavalueFactory.eINSTANCE.createLiteralBooleanValue();
        fValue.setName(NamingConstants.PredefinedTypesCmd_falseValue_name);
        fValue.setValue(false);
        fValue.setAbstractType((AbstractType)result);
        result.getOwnedLiterals().add((Object)fValue);
        return result;
    }

    private static NumericType newNumericType(String name_p, boolean discrete_p, NumericTypeKind kind_p, boolean minInclusive_p, LiteralNumericValue minValue_p, boolean maxInclusive_p, NumericValue maxValue_p) {
        NumericType result = PredefinedTypesHelper.newNumericType(name_p, discrete_p, kind_p);
        if (minValue_p != null) {
            minValue_p.setAbstractType((AbstractType)result);
            result.setOwnedMinValue((NumericValue)minValue_p);
        }
        if (maxValue_p != null) {
            maxValue_p.setAbstractType((AbstractType)result);
            result.setOwnedMaxValue(maxValue_p);
        }
        result.setMinInclusive(minInclusive_p);
        result.setMaxInclusive(maxInclusive_p);
        return result;
    }

    private static NumericType newNumericType(String name_p, boolean discrete_p, NumericTypeKind kind_p) {
        NumericType result = DatatypeFactory.eINSTANCE.createNumericType();
        result.setVisibility(__PREDEFINED_TYPE_VISIBILITY);
        result.setName(name_p);
        result.setDiscrete(discrete_p);
        result.setKind(kind_p);
        return result;
    }

    private static StringType newPredefinedChar(NumericType cardType_p) {
        StringType result = PredefinedTypesHelper.newPredefinedString(NamingConstants.PredefinedTypesCmd_char_name);
        result.setOwnedMinLength((NumericValue)PredefinedTypesHelper.newLiteralNumericValue("", __ONE_VALUE, cardType_p));
        result.setOwnedMaxLength((NumericValue)PredefinedTypesHelper.newLiteralNumericValue("", __ONE_VALUE, cardType_p));
        return result;
    }

    private static StringType newPredefinedString(String name_p) {
        StringType result = DatatypeFactory.eINSTANCE.createStringType();
        result.setVisibility(__PREDEFINED_TYPE_VISIBILITY);
        result.setName(name_p);
        result.setDiscrete(true);
        return result;
    }

    private static LiteralNumericValue newLiteralNumericValue(String name_p, String value_p, NumericType type_p) {
        LiteralNumericValue result = PredefinedTypesHelper.newLiteralNumericValue(name_p, value_p);
        result.setAbstractType((AbstractType)type_p);
        return result;
    }

    private static LiteralNumericValue newLiteralNumericValue(String name_p, String value_p) {
        LiteralNumericValue result = DatavalueFactory.eINSTANCE.createLiteralNumericValue();
        result.setName(name_p);
        result.setValue(value_p);
        return result;
    }

    private static BinaryExpression newHexadecimalMaxValue() {
        BinaryExpression subExp = DatavalueFactory.eINSTANCE.createBinaryExpression();
        subExp.setOperator(BinaryOperator.SUB);
        BinaryExpression powExp = DatavalueFactory.eINSTANCE.createBinaryExpression();
        powExp.setOperator(BinaryOperator.POW);
        LiteralNumericValue subExp_rightExp = DatavalueFactory.eINSTANCE.createLiteralNumericValue();
        subExp_rightExp.setValue(__ONE_VALUE);
        LiteralNumericValue powExp_leftExp = DatavalueFactory.eINSTANCE.createLiteralNumericValue();
        powExp_leftExp.setValue("2");
        LiteralNumericValue powExp_rightExp = DatavalueFactory.eINSTANCE.createLiteralNumericValue();
        powExp_rightExp.setValue("64");
        subExp.setOwnedLeftOperand((DataValue)powExp);
        subExp.setOwnedRightOperand((DataValue)subExp_rightExp);
        powExp.setOwnedLeftOperand((DataValue)powExp_leftExp);
        powExp.setOwnedRightOperand((DataValue)powExp_rightExp);
        return subExp;
    }
}

