/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.ui;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.tools.api.command.semantic.AddSemanticResourceCommand;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.business.api.session.SessionHelper;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelection;
import org.eclipse.sirius.ui.tools.internal.wizards.CreateSessionResourceWizard;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.polarsys.capella.common.helpers.EcoreUtil2;

public class ModelDropTargetAdapter
extends ViewerDropAdapter {
    private static final String ERROR_CREATING_SESSION = "Error creating session";

    protected ModelDropTargetAdapter(Viewer viewer) {
        super(viewer);
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        return true;
    }

    public boolean performDrop(Object data) {
        try {
            this.tryToCreateSession(data);
        }
        catch (PartInitException e) {
            SiriusPlugin.getDefault().error(ERROR_CREATING_SESSION, (Throwable)e);
        }
        catch (IOException e) {
            SiriusPlugin.getDefault().error(ERROR_CREATING_SESSION, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            SiriusPlugin.getDefault().error(ERROR_CREATING_SESSION, (Throwable)e);
        }
        catch (InterruptedException e) {
            SiriusPlugin.getDefault().error(ERROR_CREATING_SESSION, (Throwable)e);
        }
        return false;
    }

    private void tryToCreateSession(Object data) throws IOException, PartInitException, InvocationTargetException, InterruptedException {
        TreeSelection currentTreeSelection = null;
        if (data instanceof TreeSelection) {
            currentTreeSelection = (TreeSelection)data;
            Collection<URI> uris = this.getURIs(currentTreeSelection);
            final Collection<URI> sessionModelURIs = this.filterSessionURIs(uris);
            final ArrayList<URI> otherURIs = new ArrayList<URI>(uris);
            otherURIs.removeAll(sessionModelURIs);
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    monitor.beginTask("Model importation", -1);
                    ModelDropTargetAdapter.this.openSelectedSessionModelFiles(sessionModelURIs, monitor);
                    if (!otherURIs.isEmpty()) {
                        ModelDropTargetAdapter.this.createSessionModelFromSemanticModels(otherURIs, monitor);
                    }
                    monitor.done();
                }
            };
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            try {
                dialog.run(false, false, (IRunnableWithProgress)operation);
            }
            catch (InvocationTargetException e) {
                SiriusPlugin.getDefault().error(ERROR_CREATING_SESSION, (Throwable)e);
            }
            catch (InterruptedException e) {
                SiriusPlugin.getDefault().error(ERROR_CREATING_SESSION, (Throwable)e);
            }
        }
    }

    private Collection<URI> getURIs(TreeSelection currentTreeSelection) {
        ArrayList<URI> result = new ArrayList<URI>(0);
        for (Object obj : currentTreeSelection) {
            if (!(obj instanceof IFile)) continue;
            IFile file = (IFile)obj;
            result.add(EcoreUtil2.getURI((IFile)file));
        }
        return result;
    }

    private Collection<URI> filterSessionURIs(Collection<URI> uris) {
        ArrayList<URI> sessionURIs = new ArrayList<URI>(0);
        for (URI uri : uris) {
            String fileExtension = uri.fileExtension();
            if (!"aird".equals(fileExtension)) continue;
            sessionURIs.add(uri);
        }
        return sessionURIs;
    }

    protected void openSelectedSessionModelFiles(Collection<URI> sessionModelURIs, IProgressMonitor monitor) {
        monitor.subTask("Open selected Session model");
        for (URI sessionModelURI : sessionModelURIs) {
            Session session = SessionManager.INSTANCE.getSession(sessionModelURI, monitor);
            monitor.worked(1);
            if (session == null) {
                monitor.subTask("Load session");
                session = SessionManager.INSTANCE.getSession(sessionModelURI, monitor);
                monitor.worked(1);
                session.save((IProgressMonitor)new NullProgressMonitor());
                monitor.done();
            }
            if (!session.isOpen()) {
                monitor.subTask("Open session " + session.getID());
                session.open((IProgressMonitor)new NullProgressMonitor());
                monitor.done();
            }
            ViewpointSelection.openViewpointsSelectionDialog((Session)session);
            monitor.worked(1);
            Collection startupCandidates = SessionHelper.findAllStartupCandidates((Session)session);
            Collection selection = SessionHelper.selectRepresentationsToOpen(null, (Collection)startupCandidates);
            for (DRepresentation repr : selection) {
                DialectUIManager.INSTANCE.openEditor(session, repr, monitor);
                monitor.worked(1);
            }
        }
        monitor.done();
    }

    protected void createSessionModelFromSemanticModels(Collection<URI> otherURIs, IProgressMonitor monitor) {
        monitor.subTask("Open selected Session model");
        for (URI semanticModelURI : otherURIs) {
            Path path = new Path(semanticModelURI.toPlatformString(true));
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
            CreateSessionResourceWizard wizard = new CreateSessionResourceWizard((IStructuredSelection)new StructuredSelection((Object)file));
            WizardDialog dlg = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
            dlg.create();
            dlg.getShell().setText("Create a new Session");
            dlg.setTitle("Enter session file name");
            dlg.setBlockOnOpen(true);
            if (dlg.open() != 0) continue;
            Session session = wizard.getCreatedSession();
            AddSemanticResourceCommand addSemanticResourceCmd = new AddSemanticResourceCommand(session, semanticModelURI, monitor);
            session.getTransactionalEditingDomain().getCommandStack().execute((Command)addSemanticResourceCmd);
            ViewpointSelection.openViewpointsSelectionDialog((Session)session);
            Collection startupCandidates = SessionHelper.findAllStartupCandidates((Session)session);
            Collection selection = SessionHelper.selectRepresentationsToOpen(null, (Collection)startupCandidates);
            for (DRepresentation repr : selection) {
                DialectUIManager.INSTANCE.openEditor(session, repr, monitor);
            }
        }
        monitor.done();
    }
}

