/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.migration.cmdline;

import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.sirius.business.api.preferences.SiriusPreferencesKeys;
import org.eclipse.sirius.ui.business.api.preferences.SiriusUIPreferencesKeys;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.polarsys.capella.core.commandline.core.CommandLineException;
import org.polarsys.capella.core.commandline.core.DefaultCommandLine;
import org.polarsys.capella.core.data.migration.MigrationConstants;
import org.polarsys.capella.core.data.migration.MigrationHelpers;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;

public class MigrationCommandLine
extends DefaultCommandLine {
    private Display display;
    private boolean initialValue_RefreshOnOpening;
    private boolean initialValue_AutoRefresh;

    public boolean execute(IApplicationContext context) throws CommandLineException {
        this.display = PlatformUI.createDisplay();
        PlatformUI.createAndRunWorkbench((Display)this.display, (WorkbenchAdvisor)new WorkbenchAdvisor(){

            public String getInitialWindowPerspectiveId() {
                return null;
            }

            public void postStartup() {
                super.postStartup();
                MigrationCommandLine.this.setRefreshPrefs();
                MigrationCommandLine.this.migrateAllImportedProjects(MigrationCommandLine.this.display.getActiveShell());
                MigrationCommandLine.this.resetRefreshPrefs();
                PlatformUI.getWorkbench().close();
            }
        });
        return true;
    }

    public void migrateAllImportedProjects(Shell shell) {
        Set capellaProjects = this.getProjectsFromInput().stream().filter(CapellaResourceHelper::isCapellaProject).collect(Collectors.toSet());
        for (IProject project : capellaProjects) {
            try {
                if (this.argHelper.isBackupNeeded()) {
                    MigrationHelpers.getInstance().trigger((IResource)project, shell, true, false, MigrationConstants.DEFAULT_KIND_ORDER);
                    continue;
                }
                MigrationHelpers.getInstance().trigger((IResource)project, shell, true, true, false, false, MigrationConstants.DEFAULT_KIND_ORDER);
            }
            catch (Exception e) {
                this.logError("Error during migration of " + project.getName());
            }
        }
    }

    public void setRefreshPrefs() {
        IPreferenceStore preferenceStore = SiriusEditPlugin.getPlugin().getPreferenceStore();
        this.initialValue_RefreshOnOpening = preferenceStore.getBoolean(SiriusUIPreferencesKeys.PREF_REFRESH_ON_REPRESENTATION_OPENING.name());
        preferenceStore = SiriusEditPlugin.getPlugin().getCorePreferenceStore();
        this.initialValue_AutoRefresh = preferenceStore.getBoolean(SiriusPreferencesKeys.PREF_AUTO_REFRESH.name());
        this.doSetSiriusPrefs(true, true);
    }

    private void resetRefreshPrefs() {
        this.doSetSiriusPrefs(this.initialValue_RefreshOnOpening, this.initialValue_AutoRefresh);
    }

    private void doSetSiriusPrefs(boolean refreshOnOpening, boolean autoRefresh) {
        IEclipsePreferences siriusUIPluginPreferences = InstanceScope.INSTANCE.getNode("org.eclipse.sirius.ui");
        siriusUIPluginPreferences.putBoolean(SiriusUIPreferencesKeys.PREF_REFRESH_ON_REPRESENTATION_OPENING.name(), refreshOnOpening);
        IEclipsePreferences siriusPluginPreferences = InstanceScope.INSTANCE.getNode("org.eclipse.sirius");
        siriusPluginPreferences.putBoolean(SiriusPreferencesKeys.PREF_AUTO_REFRESH.name(), autoRefresh);
    }

    public void printHelp() {
        super.printHelp();
        this.printArgumentsFromTable("migrationParameters", false, Collections.emptyList());
    }

    public void compliancyCheck(IFile modeller) throws CommandLineException {
    }
}

