/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.semantic.browser.sirius.handlers;

import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.menus.UIElement;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.common.mdsofa.common.helper.StringHelper;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.common.ui.services.commands.AbstractLocateInViewPartHandler;
import org.polarsys.capella.core.ui.semantic.browser.sirius.handlers.Messages;
import org.polarsys.capella.core.ui.semantic.browser.sirius.helpers.SiriusSelectionHelper;
import org.polarsys.capella.core.ui.semantic.browser.sirius.view.SiriusSemanticBrowserView;
import org.polarsys.capella.core.ui.semantic.browser.view.SemanticBrowserView;

public class SemanticBrowserSetSelectionHandler
extends AbstractLocateInViewPartHandler {
    private static final Logger __logger = ReportManagerRegistry.getInstance().subscribe("User Interface");

    protected String getTargetedPartId() {
        return "org.polarsys.capella.core.ui.semantic.browser.view.SemanticBrowserID";
    }

    protected IViewPart handleSelection(ISelection selection, IWorkbenchPart activePart, ExecutionEvent event) {
        IViewPart targetedPart = super.handleSelection(selection, activePart, event);
        Object objectToSelect = SiriusSelectionHelper.handleSelection(activePart, selection, true);
        if (objectToSelect == null) {
            if (__logger.isDebugEnabled()) {
                StringBuilder loggerMessage = new StringBuilder("SemanticBrowserSetSelectionHandler.handleSelection(..) _ No Object to select !");
                __logger.debug((Object)loggerMessage.toString());
                __logger.debug((Object)new EmbeddedMessage(loggerMessage.toString(), "User Interface"));
            }
            return null;
        }
        if (targetedPart instanceof SiriusSemanticBrowserView) {
            SiriusSemanticBrowserView semanticBrowserView = (SiriusSemanticBrowserView)targetedPart;
            semanticBrowserView.setInput(objectToSelect);
        }
        return targetedPart;
    }

    public void updateElement(UIElement element_p, Map parameters_p) {
        IWorkbenchWindow workbenchWindow = (IWorkbenchWindow)parameters_p.get("org.eclipse.ui.IWorkbenchWindow");
        if (workbenchWindow != null) {
            if (workbenchWindow.getActivePage() == null) {
                return;
            }
            IWorkbenchPart activePart = workbenchWindow.getActivePage().getActivePart();
            if (activePart == null || activePart.getSite() == null) {
                return;
            }
            IWorkbenchPartSite site = activePart.getSite();
            if (site.getSelectionProvider() == null) {
                return;
            }
            Object object = SiriusSelectionHelper.handleSelection(activePart, site.getSelectionProvider().getSelection(), true);
            if (object instanceof EObject) {
                String title = Messages.SelectInSemanticBrowserAction_LongTitle;
                if (activePart instanceof SemanticBrowserView) {
                    title = Messages.SelectInSemanticBrowserAction_ShortTitle;
                }
                title = StringHelper.formatMessage((String)title, (Object[])new String[]{EObjectLabelProviderHelper.getText((Object)((EObject)object))});
                element_p.setText(title);
            }
        }
    }
}

