/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.semantic.queries.basic.queries;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.polarsys.capella.common.data.modellingcore.AbstractConstraint;
import org.polarsys.capella.common.data.modellingcore.AbstractTypedElement;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.helpers.query.IQuery;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.helpers.cache.ModelCache;
import org.polarsys.capella.core.model.helpers.ComponentExt;

public class ModelElementConstraints
implements IQuery {
    public List<Object> compute(Object object) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (object instanceof ModelElement) {
            BasicEList constraints = ECollections.newBasicEList();
            if (object instanceof Component) {
                constraints.addAll(this.compute((Component)object));
            } else {
                ModelElement current = (ModelElement)object;
                constraints.addAll((Collection)current.getConstraints());
            }
            if (!constraints.isEmpty()) {
                result.addAll((Collection<Object>)constraints);
            }
        }
        return result;
    }

    private Set<AbstractConstraint> compute(Component component) {
        HashSet<AbstractConstraint> result = new HashSet<AbstractConstraint>();
        Collection parts = (Collection)ModelCache.getCache(ComponentExt::getRepresentingParts, (Object)component);
        for (AbstractTypedElement part : parts) {
            for (AbstractConstraint constraint : part.getConstraints()) {
                result.add(constraint);
            }
        }
        for (AbstractConstraint constraint : component.getConstraints()) {
            result.add(constraint);
        }
        return result;
    }
}

