/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.flexibility.properties.loader;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.polarsys.capella.common.flexibility.properties.loader.ILoadableProperty;
import org.polarsys.capella.common.flexibility.properties.property.Properties;
import org.polarsys.capella.common.flexibility.properties.property.PropertyGroup;
import org.polarsys.capella.common.flexibility.properties.property.PropertyOption;
import org.polarsys.capella.common.flexibility.properties.schema.IProperties;
import org.polarsys.capella.common.flexibility.properties.schema.PropertiesSchemaConstants;

public class PropertiesLoader {
    private HashMap<String, Properties> propertiesMap = new HashMap();
    protected Collection<IConfigurationElement> extensions = new ArrayList<IConfigurationElement>();

    public PropertiesLoader() {
        this.extensions.addAll(Arrays.asList(Platform.getExtensionRegistry().getConfigurationElementsFor(PropertiesSchemaConstants.PropertiesSchema_ID)));
        for (IConfigurationElement element : this.extensions) {
            System.out.println("flexibility.properties: migration is required for " + element.getNamespaceIdentifier());
        }
        this.extensions.addAll(Arrays.asList(Platform.getExtensionRegistry().getConfigurationElementsFor(PropertiesSchemaConstants.PropertiesSchema_SCHEMA_ID)));
    }

    protected Properties getStoredProperties(String idProperties) {
        return this.propertiesMap.get(idProperties);
    }

    protected void setStoredProperties(String idProperties, Properties properties) {
        this.propertiesMap.put(idProperties, properties);
    }

    public IProperties getProperties(String idProperties) {
        String idVisit;
        Properties storedProperties = this.getStoredProperties(idProperties);
        if (storedProperties != null) {
            return storedProperties;
        }
        LinkedList<String> initialIds = new LinkedList<String>();
        LinkedList<String> toVisitId = new LinkedList<String>();
        LinkedList<String> visitedId = new LinkedList<String>();
        LinkedList<IConfigurationElement> toVisit = new LinkedList<IConfigurationElement>();
        LinkedList<Properties> createdProperties = new LinkedList<Properties>();
        LinkedList<String> createPropertiesId = new LinkedList<String>();
        Properties rootProperties = this.getStoredProperties(idProperties);
        if (rootProperties == null) {
            rootProperties = new Properties(idProperties);
            createdProperties.add(rootProperties);
            createPropertiesId.add(idProperties);
            this.setStoredProperties(idProperties, rootProperties);
        }
        this.initToVisit(initialIds, idProperties);
        toVisitId.addAll(initialIds);
        HashMap mapInheritancy = new HashMap();
        while (toVisitId.size() > 0) {
            idVisit = (String)toVisitId.removeFirst();
            if (visitedId.contains(idVisit)) continue;
            visitedId.add(idVisit);
            Properties properties = this.getStoredProperties(idVisit);
            if (properties == null) {
                properties = new Properties(idVisit);
                createdProperties.add(properties);
                createPropertiesId.add(idVisit);
                this.setStoredProperties(idVisit, properties);
            }
            if (!createdProperties.contains(properties)) continue;
            if (!mapInheritancy.containsKey(properties)) {
                mapInheritancy.put(properties, new HashSet());
            }
            for (String string : this.computeInheritancy(properties)) {
                toVisitId.add(string);
                ((HashSet)mapInheritancy.get(properties)).add(string);
            }
        }
        visitedId.clear();
        while (createPropertiesId.size() > 0) {
            idVisit = (String)createPropertiesId.removeFirst();
            if (visitedId.contains(idVisit)) continue;
            visitedId.add(idVisit);
            for (IConfigurationElement extension : this.extensions) {
                Object id;
                if (!PropertiesSchemaConstants.PropertiesSchema_PROPERTIES.equals(extension.getName()) || !((String)(id = extension.getAttribute(PropertiesSchemaConstants.PropertiesSchema_PROPERTIES__ID))).equals(idVisit)) continue;
                toVisit.addFirst(extension);
            }
        }
        for (Properties properties : mapInheritancy.keySet()) {
            for (String string : (HashSet)mapInheritancy.get(properties)) {
                Properties parentProperties = this.getStoredProperties(string);
                properties.addParent(parentProperties);
            }
        }
        visitedId.clear();
        for (IConfigurationElement element : toVisit) {
            String string = element.getAttribute(PropertiesSchemaConstants.PropertiesSchema_PROPERTIES__ID);
            Properties properties = this.getStoredProperties(string);
            if (!createdProperties.contains(properties)) continue;
            IConfigurationElement[] iConfigurationElementArray = element.getChildren();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name;
                IConfigurationElement extension = iConfigurationElementArray[n2];
                if (PropertiesSchemaConstants.PropertiesSchema_GROUP.equals(extension.getName())) {
                    String groupId = extension.getAttribute(PropertiesSchemaConstants.PropertiesSchema_GROUP__ID);
                    name = extension.getAttribute(PropertiesSchemaConstants.PropertiesSchema_GROUP__NAME);
                    String parentId = extension.getAttribute(PropertiesSchemaConstants.PropertiesSchema_GROUP__PARENT);
                    if (parentId == null && (parentId = extension.getAttribute(PropertiesSchemaConstants.PropertiesSchema_GROUP__PARENT_ID)) != null) {
                        System.out.println("flexibility.properties: migration is required on " + groupId + "> 'parendId' attribute instead of 'parent'" + parentId);
                    }
                    properties.addGroup(new PropertyGroup(groupId, name, parentId));
                }
                if (PropertiesSchemaConstants.PropertiesSchema_PROPERTY.equals(extension.getName())) {
                    String propertyId = extension.getAttribute(PropertiesSchemaConstants.PropertiesSchema_PROPERTY__ID);
                    name = extension.getAttribute(PropertiesSchemaConstants.PropertiesSchema_PROPERTY__NAME);
                    String description = extension.getAttribute(PropertiesSchemaConstants.PropertiesSchema_PROPERTY__DESCRIPTION);
                    String group_id = extension.getAttribute(PropertiesSchemaConstants.PropertiesSchema_PROPERTY__GROUP);
                    if (group_id == null && (group_id = extension.getAttribute(PropertiesSchemaConstants.PropertiesSchema_PROPERTY__GROUP_ID)) != null) {
                        System.out.println("flexibility.properties: migration is required on " + propertyId + "> 'group_id' attribute instead of 'group'" + group_id);
                    }
                    String enabled = extension.getAttribute(PropertiesSchemaConstants.PropertiesSchema_PROPERTY__ENABLED);
                    ILoadableProperty item = null;
                    try {
                        item = (ILoadableProperty)extension.createExecutableExtension(PropertiesSchemaConstants.PropertiesSchema_PROPERTY__CLASS);
                        item.setName(name);
                        item.setDescription(description);
                        item.setId(propertyId);
                        item.setGroupId(group_id);
                        item.setEnabled(Boolean.valueOf(enabled));
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                    if (item != null) {
                        IConfigurationElement argument;
                        properties.addItem(item);
                        IConfigurationElement[] iConfigurationElementArray2 = extension.getChildren(PropertiesSchemaConstants.PropertiesSchema_OPTION);
                        int n3 = iConfigurationElementArray2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IConfigurationElement option = iConfigurationElementArray2[n4];
                            String id2 = option.getAttribute(PropertiesSchemaConstants.PropertiesSchema_OPTION__ID);
                            String name2 = option.getAttribute(PropertiesSchemaConstants.PropertiesSchema_OPTION__NAME);
                            String description2 = option.getAttribute(PropertiesSchemaConstants.PropertiesSchema_OPTION__DESCRIPTION);
                            String value2 = option.getAttribute(PropertiesSchemaConstants.PropertiesSchema_OPTION__VALUE);
                            String enabled2 = option.getAttribute(PropertiesSchemaConstants.PropertiesSchema_OPTION__ENABLED);
                            PropertyOption item2 = new PropertyOption(id2, value2, name2, description2, Boolean.valueOf(enabled2));
                            item.addOption(item2);
                            ++n4;
                        }
                        iConfigurationElementArray2 = extension.getChildren(PropertiesSchemaConstants.PropertiesSchema_ARGUMENT);
                        n3 = iConfigurationElementArray2.length;
                        n4 = 0;
                        while (n4 < n3) {
                            argument = iConfigurationElementArray2[n4];
                            item.addParameter(argument.getAttribute(PropertiesSchemaConstants.PropertiesSchema_ARGUMENT__ID), argument.getAttribute(PropertiesSchemaConstants.PropertiesSchema_ARGUMENT__VALUE));
                            ++n4;
                        }
                        iConfigurationElementArray2 = extension.getChildren(PropertiesSchemaConstants.PropertiesSchema_PARAMETER);
                        n3 = iConfigurationElementArray2.length;
                        n4 = 0;
                        while (n4 < n3) {
                            argument = iConfigurationElementArray2[n4];
                            item.addParameter(argument.getAttribute(PropertiesSchemaConstants.PropertiesSchema_PARAMETER__ID), argument.getAttribute(PropertiesSchemaConstants.PropertiesSchema_PARAMETER__VALUE));
                            ++n4;
                        }
                    }
                }
                ++n2;
            }
        }
        if (createdProperties.contains(rootProperties)) {
            for (String id : initialIds) {
                Properties properties = this.getStoredProperties(id);
                if (properties == null || properties == rootProperties) continue;
                rootProperties.addParent(properties);
            }
        }
        HashSet<Properties> toPack = new HashSet<Properties>();
        for (Properties properties : createdProperties) {
            if (!properties.getGroups().isEmpty() || !properties.getItems().isEmpty()) continue;
            toPack.add(properties);
        }
        for (Properties properties : createdProperties) {
            boolean isPacked = false;
            while (!isPacked) {
                isPacked = true;
                HashSet<IProperties> toPackParent = new HashSet<IProperties>();
                for (IProperties parent : properties.getParents()) {
                    if (!toPack.contains(parent)) continue;
                    toPackParent.add(parent);
                }
                for (IProperties parent : toPackParent) {
                    for (IProperties parentParent : parent.getParents()) {
                        properties.addParent(parentParent);
                        if (!isPacked || !toPack.contains(parentParent)) continue;
                        isPacked = false;
                    }
                    properties.removeParent(parent);
                }
            }
        }
        return rootProperties;
    }

    protected Collection<String> computeInheritancy(Properties properties) {
        ArrayList<String> parents = new ArrayList<String>();
        for (IConfigurationElement extension : this.extensions) {
            String id;
            if (!PropertiesSchemaConstants.PropertiesSchema_PROPERTIES.equals(extension.getName()) || !(id = extension.getAttribute(PropertiesSchemaConstants.PropertiesSchema_PROPERTIES__ID)).equals(properties.getPropertiesId())) continue;
            IConfigurationElement[] iConfigurationElementArray = extension.getChildren(PropertiesSchemaConstants.PropertiesSchema_INHERITANCE);
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement parent = iConfigurationElementArray[n2];
                String propertiesId = parent.getAttribute(PropertiesSchemaConstants.PropertiesSchema_INHERITANCE__PROPERTIES);
                if (propertiesId == null) {
                    propertiesId = parent.getAttribute(PropertiesSchemaConstants.PropertiesSchema_INHERITANCE__PROPERTIESID);
                }
                parents.add(propertiesId);
                ++n2;
            }
        }
        return parents;
    }

    protected void initToVisit(LinkedList<String> toVisitId, String idProperties) {
        toVisitId.add(idProperties);
    }
}

