/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.explorer.activity.ui.viewer;

import java.util.Collection;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.BasicSessionActivityExplorerPage;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.helper.SelectionHelper;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.viewers.DiagramViewer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.polarsys.capella.core.explorer.activity.ui.pages.AbstractCapellaPage;
import org.polarsys.capella.core.explorer.activity.ui.viewer.CapellaArchitectureContentProvider;
import org.polarsys.capella.core.explorer.activity.ui.viewer.Messages;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;
import org.polarsys.capella.core.platform.sirius.ui.navigator.CapellaNavigatorPlugin;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.CloneAction;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.LocateInCapellaExplorerAction;
import org.polarsys.capella.core.platform.sirius.ui.navigator.viewer.CapellaNavigatorLabelProvider;
import org.polarsys.capella.core.sirius.ui.actions.DeleteRepresentationAction;
import org.polarsys.capella.core.sirius.ui.actions.MoveRepresentationsAction;
import org.polarsys.capella.core.sirius.ui.actions.OpenRepresentationsAction;
import org.polarsys.capella.core.sirius.ui.actions.RenameRepresentationAction;

public class CapellaDiagramViewer
extends DiagramViewer {
    private static final String GROUP_MOVE = "Move";
    private MoveRepresentationsAction moveRepresentation;
    private OpenRepresentationsAction openRepresentation;
    private RenameRepresentationAction renameRepresentationAction;
    private ShowInProjectExplorerAction showInCapellaExplorerAction;
    private CloneAction cloneAction;
    private DeleteRepresentationAction deleteRepresentationAction;
    private MenuManager menuManager;

    public CapellaDiagramViewer(BasicSessionActivityExplorerPage page) {
        super(page);
    }

    protected void addListenersOnViewer(TreeViewer viewer) {
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                OpenRepresentationsAction action = new OpenRepresentationsAction();
                action.selectionChanged(selection);
                action.run();
            }
        });
    }

    protected MenuManager initMenuToViewer(TreeViewer treeViewer) {
        this.menuManager = new MenuManager("viewerPopup");
        Control control = treeViewer.getControl();
        this.declareViewerActions(this.menuManager, treeViewer);
        Menu contextMenu = this.menuManager.createContextMenu(control);
        control.setMenu(contextMenu);
        return this.menuManager;
    }

    protected void declareViewerActions(MenuManager contextMenuManager, TreeViewer treeViewer) {
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        ISelectionProvider selectionProvider = this.page.getEditorSite().getSelectionProvider();
        this.showInCapellaExplorerAction = new ShowInProjectExplorerAction();
        this.showInCapellaExplorerAction.setActionDefinitionId("org.polarsys.capella.core.platform.sirius.ui.navigator.locateInCapellaExplorerCommand");
        this.showInCapellaExplorerAction.setImageDescriptor(CapellaNavigatorPlugin.getDefault().getImageDescriptor("eview16/project_explorer.png"));
        SelectionHelper.registerToSelectionChanges((ISelectionChangedListener)this.showInCapellaExplorerAction, (ISelectionProvider)selectionProvider);
        contextMenuManager.add((IAction)this.showInCapellaExplorerAction);
        contextMenuManager.add((IContributionItem)new Separator());
        this.openRepresentation = new OpenRepresentationsAction(){

            protected boolean updateSelection(IStructuredSelection selection) {
                return CapellaDiagramViewer.this.containsOnlyRepresentations(selection);
            }
        };
        SelectionHelper.registerToSelectionChanges((ISelectionChangedListener)this.openRepresentation, (ISelectionProvider)selectionProvider);
        contextMenuManager.add((IAction)this.openRepresentation);
        contextMenuManager.add((IContributionItem)new Separator());
        this.cloneAction = new CloneAction(treeViewer);
        this.cloneAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        SelectionHelper.registerToSelectionChanges((ISelectionChangedListener)this.cloneAction, (ISelectionProvider)selectionProvider);
        contextMenuManager.add((IAction)this.cloneAction);
        this.deleteRepresentationAction = new DeleteRepresentationAction(){

            protected boolean updateSelection(IStructuredSelection selection) {
                return CapellaDiagramViewer.this.containsOnlyRepresentations(selection);
            }
        };
        this.deleteRepresentationAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.deleteRepresentationAction.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        SelectionHelper.registerToSelectionChanges((ISelectionChangedListener)this.deleteRepresentationAction, (ISelectionProvider)selectionProvider);
        contextMenuManager.add((IAction)this.deleteRepresentationAction);
        contextMenuManager.add((IContributionItem)new Separator(GROUP_MOVE));
        this.moveRepresentation = new MoveRepresentationsAction();
        this.moveRepresentation.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sirius.ui", (String)"/icons/full/others/forward.gif"));
        SelectionHelper.registerToSelectionChanges((ISelectionChangedListener)this.moveRepresentation, (ISelectionProvider)selectionProvider);
        contextMenuManager.appendToGroup(GROUP_MOVE, (IAction)this.moveRepresentation);
        this.renameRepresentationAction = new RenameRepresentationAction(){

            protected boolean updateSelection(IStructuredSelection selection) {
                return CapellaDiagramViewer.this.containsOnlyRepresentations(selection);
            }
        };
        SelectionHelper.registerToSelectionChanges((ISelectionChangedListener)this.renameRepresentationAction, (ISelectionProvider)selectionProvider);
        contextMenuManager.add((IAction)this.renameRepresentationAction);
        this.updateActionBars();
    }

    protected ILabelProvider getLabelProvider() {
        return new CapellaNavigatorLabelProvider();
    }

    protected IContentProvider getContentProvider() {
        return new CapellaArchitectureContentProvider(((AbstractCapellaPage)this.page).getFilteringMetaClassForCommonViewpoint());
    }

    public void dispose() {
        ISelectionProvider selectionProvider = this.page.getEditorSite().getSelectionProvider();
        if (this.renameRepresentationAction != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.renameRepresentationAction);
            this.renameRepresentationAction = null;
        }
        if (this.deleteRepresentationAction != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.deleteRepresentationAction);
            this.deleteRepresentationAction = null;
        }
        if (this.openRepresentation != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.openRepresentation);
            this.openRepresentation = null;
        }
        if (this.moveRepresentation != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.moveRepresentation);
            this.moveRepresentation = null;
        }
        if (this.cloneAction != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.cloneAction);
            this.cloneAction = null;
        }
        if (this.showInCapellaExplorerAction != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.showInCapellaExplorerAction);
            this.showInCapellaExplorerAction = null;
        }
        if (this.menuManager != null) {
            this.menuManager.dispose();
        }
    }

    private void updateActionBars() {
        IActionBars editorActionBars = this.page.getEditorSite().getActionBars();
        editorActionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteRepresentationAction);
        editorActionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this.renameRepresentationAction);
        editorActionBars.updateActionBars();
    }

    public MenuManager getMenuManager() {
        return this.menuManager;
    }

    protected class DelegatedViewerFilter
    extends ViewerFilter {
        private ViewerFilter delegatedFilter;

        protected DelegatedViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            boolean selected = true;
            if (this.delegatedFilter != null) {
                selected = this.delegatedFilter.select(viewer, parentElement, element);
            }
            return selected;
        }

        public void setDelegatedFilter(ViewerFilter delegatedFilter) {
            this.delegatedFilter = delegatedFilter;
        }
    }

    public class ShowInProjectExplorerAction
    extends BaseSelectionListenerAction {
        public ShowInProjectExplorerAction() {
            super(Messages.AbstractCapellaArchitectureActivityExplorerPage_ShowInCapellaExplorerAction_Title);
        }

        public void run() {
            IStructuredSelection selection = this.getStructuredSelection();
            Collection selectedDescriptors = RepresentationHelper.getSelectedDescriptors((Collection)selection.toList());
            IAction locatingAction = LocateInCapellaExplorerAction.createLocateTowards((EObject)((EObject)selectedDescriptors.toArray()[0]), (String)"", (boolean)false);
            locatingAction.run();
        }

        protected boolean updateSelection(IStructuredSelection selection) {
            return CapellaDiagramViewer.this.containsOnlyRepresentations(selection);
        }
    }
}

