/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.explorer.activity.ui.hyperlinkadapter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.data.capellacommon.AbstractCapabilityPkg;
import org.polarsys.capella.core.data.capellacommon.CapellacommonFactory;
import org.polarsys.capella.core.data.capellacommon.Region;
import org.polarsys.capella.core.data.capellacommon.StateMachine;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.cs.Block;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.ctx.Capability;
import org.polarsys.capella.core.data.ctx.CapabilityPkg;
import org.polarsys.capella.core.data.ctx.CtxFactory;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.interaction.InteractionFactory;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.ScenarioKind;
import org.polarsys.capella.core.data.la.CapabilityRealization;
import org.polarsys.capella.core.data.la.CapabilityRealizationPkg;
import org.polarsys.capella.core.data.la.LaFactory;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.oa.OaFactory;
import org.polarsys.capella.core.data.oa.OaPackage;
import org.polarsys.capella.core.data.oa.OperationalCapability;
import org.polarsys.capella.core.data.oa.OperationalCapabilityPkg;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.model.helpers.ModelQueryHelper;
import org.polarsys.capella.core.ui.toolkit.helpers.SelectionDialogHelper;

public class ModelCreationHelper {
    protected static Scenario createScenario(AbstractCapability abstractCapability, ScenarioKind scenarioKind) {
        if (abstractCapability != null) {
            Scenario sc = InteractionFactory.eINSTANCE.createScenario();
            sc.setKind(scenarioKind);
            abstractCapability.getOwnedScenarios().add((Object)sc);
            CapellaElementExt.creationService((EObject)sc);
            return sc;
        }
        return null;
    }

    protected static void createStateMachineRegion(Block block) {
        StateMachine defaultSM = null;
        Iterator iterator = block.getOwnedStateMachines().iterator();
        if (iterator.hasNext()) {
            StateMachine sm;
            defaultSM = sm = (StateMachine)iterator.next();
        }
        if (defaultSM == null) {
            defaultSM = CapellacommonFactory.eINSTANCE.createStateMachine();
            block.getOwnedStateMachines().add((Object)defaultSM);
            CapellaElementExt.creationService((EObject)defaultSM);
        }
        Region defaultRegion = null;
        Iterator iterator2 = defaultSM.getOwnedRegions().iterator();
        while (iterator2.hasNext()) {
            Region region;
            defaultRegion = region = (Region)iterator2.next();
        }
        if (defaultRegion == null) {
            defaultRegion = CapellacommonFactory.eINSTANCE.createRegion();
            defaultSM.getOwnedRegions().add((Object)defaultRegion);
            CapellaElementExt.creationService((EObject)defaultRegion);
        }
    }

    public static AbstractCapability selectCapability(Project project, BlockArchitecture architecture) {
        final AbstractCapability[] result = new AbstractCapability[1];
        final AbstractCapabilityPkg capabilityPkg = BlockArchitectureExt.getAbstractCapabilityPkg((BlockArchitecture)architecture);
        if (capabilityPkg != null) {
            EClass clazz = CtxPackage.Literals.CAPABILITY;
            if (capabilityPkg instanceof CapabilityRealizationPkg) {
                clazz = LaPackage.Literals.CAPABILITY_REALIZATION;
            } else if (capabilityPkg instanceof OperationalCapabilityPkg) {
                clazz = OaPackage.Literals.OPERATIONAL_CAPABILITY;
            }
            Set all = EObjectExt.getAll((EObject)capabilityPkg, (EClass)clazz);
            if (!all.isEmpty()) {
                Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                result[0] = (AbstractCapability)SelectionDialogHelper.simplePropertySelectionDialogWizard(new ArrayList(all), (Shell)shell);
                return result[0];
            }
            AbstractReadWriteCommand cmd = new AbstractReadWriteCommand(){

                public void run() {
                    result[0] = ModelCreationHelper.createAbstractCapability(capabilityPkg);
                }
            };
            TransactionHelper.getExecutionManager((EObject)project).execute((ICommand)cmd);
        }
        return result[0];
    }

    public static AbstractCapability createAbstractCapability(AbstractCapabilityPkg capabilityPkg) {
        Capability result = null;
        if (capabilityPkg instanceof CapabilityPkg) {
            result = CtxFactory.eINSTANCE.createCapability();
            ((CapabilityPkg)capabilityPkg).getOwnedCapabilities().add((Object)result);
        } else if (capabilityPkg instanceof CapabilityRealizationPkg) {
            result = LaFactory.eINSTANCE.createCapabilityRealization();
            ((CapabilityRealizationPkg)capabilityPkg).getOwnedCapabilityRealizations().add((Object)((CapabilityRealization)result));
        } else if (capabilityPkg instanceof OperationalCapabilityPkg) {
            result = OaFactory.eINSTANCE.createOperationalCapability();
            ((OperationalCapabilityPkg)capabilityPkg).getOwnedOperationalCapabilities().add((Object)((OperationalCapability)result));
        }
        CapellaElementExt.creationService((EObject)result);
        return result;
    }

    public static Scenario selectCapabilityAndCreateScenario(final Project project, final BlockArchitecture architecture, final ScenarioKind scenarioKind) {
        AbstractReadWriteCommand cmd = new AbstractReadWriteCommand(){
            private Scenario scenario;

            public Collection<?> getAffectedObjects() {
                return Collections.singletonList(this.scenario);
            }

            public void run() {
                AbstractCapability capability = ModelCreationHelper.selectCapability(project, architecture);
                if (capability != null) {
                    this.scenario = ModelCreationHelper.createScenario(capability, scenarioKind);
                }
            }
        };
        TransactionHelper.getExecutionManager((EObject)project).execute((ICommand)cmd);
        return (Scenario)cmd.getAffectedObjects().iterator().next();
    }

    @Deprecated
    public static Scenario selectLACapabilityRealizationAndCreateDataFlowScenario(Project project) {
        return ModelCreationHelper.selectCapabilityAndCreateScenario(project, (BlockArchitecture)ModelQueryHelper.getLogicalArchitecture((Project)project), ScenarioKind.DATA_FLOW);
    }

    @Deprecated
    public static Scenario selectOperationalCapabilityAndCreateInteractionScenario(Project project) {
        return ModelCreationHelper.selectCapabilityAndCreateScenario(project, (BlockArchitecture)ModelQueryHelper.getOperationalAnalysis((Project)project), ScenarioKind.INTERACTION);
    }

    @Deprecated
    public static Scenario selectPACapabilityRealizationAndCreateDataFlowScenario(Project project) {
        return ModelCreationHelper.selectCapabilityAndCreateScenario(project, (BlockArchitecture)ModelQueryHelper.getPhysicalArchitecture((Project)project), ScenarioKind.DATA_FLOW);
    }

    @Deprecated
    public static Region selectOperationalEntityAndCreateStateMachineRegion(Project project) {
        return ModelCreationHelper.selectComponentCreateStateMachineRegion(project, (BlockArchitecture)ModelQueryHelper.getOperationalAnalysis((Project)project));
    }

    @Deprecated
    public static Region selectComponentAtSALevelAndCreateStateMachineRegion(Project project) {
        return ModelCreationHelper.selectComponentCreateStateMachineRegion(project, (BlockArchitecture)ModelQueryHelper.getSystemAnalysis((Project)project));
    }

    @Deprecated
    public static Region selectComponentAtLALevelAndCreateStateMachineRegion(Project project) {
        return ModelCreationHelper.selectComponentCreateStateMachineRegion(project, (BlockArchitecture)ModelQueryHelper.getLogicalArchitecture((Project)project));
    }

    @Deprecated
    public static Region selectComponentAtPALevelAndCreateStateMachineRegion(Project project) {
        return ModelCreationHelper.selectComponentCreateStateMachineRegion(project, (BlockArchitecture)ModelQueryHelper.getPhysicalArchitecture((Project)project));
    }

    public static Region selectComponentCreateStateMachineRegion(Project project, final BlockArchitecture architecture) {
        final Component[] components = new Component[1];
        AbstractReadWriteCommand cmd = new AbstractReadWriteCommand(){

            public void run() {
                components[0] = ModelCreationHelper.selectComponent(architecture);
                if (components[0] != null) {
                    ModelCreationHelper.createStateMachineRegion((Block)components[0]);
                }
            }
        };
        TransactionHelper.getExecutionManager((EObject)project).execute((ICommand)cmd);
        return components[0] != null ? ModelQueryHelper.getStateMachineRegion((Block)components[0]) : null;
    }

    @Deprecated
    public static Region selectComponentAtAPBSLevelAndCreateStateMachineRegion(Project project) {
        return ModelCreationHelper.selectComponentCreateStateMachineRegion(project, (BlockArchitecture)ModelQueryHelper.getEPBSArchitecture((Project)project));
    }

    protected static Component selectComponent(BlockArchitecture architecture) {
        ArrayList components = new ArrayList();
        components.addAll(BlockArchitectureExt.getAllComponents((BlockArchitecture)architecture));
        if (!components.isEmpty()) {
            return (Component)SelectionDialogHelper.simplePropertySelectionDialogWizard(new ArrayList(components), (Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell());
        }
        return BlockArchitectureExt.getOrCreateSystem((BlockArchitecture)architecture);
    }
}

