/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.validation.export;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.validation.model.Category;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.polarsys.capella.common.helpers.export.DataExporter;
import org.polarsys.capella.core.validation.CapellaValidationActivator;
import org.polarsys.capella.core.validation.export.ExportMessages;
import org.polarsys.capella.core.validation.utils.ValidationHelper;

public class ExportUtils {
    private static final int COMPARATOR_IDX = 0;

    private ExportUtils() {
    }

    public static boolean exportValidationRules(DataExporter dataExporter, String filename) {
        boolean result = false;
        ArrayList<String[]> data = new ArrayList<String[]>();
        IEclipsePreferences preferences = new InstanceScope().getNode(CapellaValidationActivator.getDefault().getPluginId());
        boolean onlyActiveRules = preferences.getBoolean("validation.rules.export.active.only.exe", false);
        boolean onlyCapellaRules = preferences.getBoolean("validation.rules.export.capella.only.exe", false);
        boolean addit = false;
        for (IConstraintDescriptor icd : ValidationHelper.getAllConstraintDescriptors()) {
            boolean bl = addit = !(onlyActiveRules && !icd.isEnabled() || onlyCapellaRules && !ExportUtils.getCategory(icd).getPath().startsWith("capella.category"));
            if (!addit) continue;
            data.add(ExportUtils.prepareCSVTXT(icd));
        }
        Comparator<String[]> comparator = new Comparator<String[]>(){

            @Override
            public int compare(String[] o1, String[] o2) {
                return o1[0].compareTo(o2[0]);
            }
        };
        Collections.sort(data, comparator);
        String[] header = new String[]{ExportMessages.exportHeaderCategoryPath, ExportMessages.exportHeaderCategoryName, ExportMessages.exportHeaderRuleId, ExportMessages.exportHeaderRuleSeverity, ExportMessages.exportHeaderIsRuleEnabled, ExportMessages.exportHeaderRuleMode, ExportMessages.exportHeaderRuleDescription};
        data.add(0, header);
        result = dataExporter.exportToFile(filename, data);
        return result;
    }

    private static String[] prepareCSVTXT(IConstraintDescriptor icd) {
        Category category = ExportUtils.getCategory(icd);
        return new String[]{category.getPath(), category.getName(), icd.getId(), icd.getSeverity().getLocalizedName(), String.valueOf(icd.isEnabled()), icd.getEvaluationMode().getLocalizedName(), icd.getDescription()};
    }

    private static IConfigurationElement[] getAllContributions() {
        String point = "org.polarsys.capella.core.validation.ui.ide.capellaQuickFix";
        return Platform.getExtensionRegistry().getConfigurationElementsFor(point);
    }

    private static Category getCategory(IConstraintDescriptor icd) {
        return (Category)icd.getCategories().iterator().next();
    }
}

