/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.util.Comparator;
import org.assertj.core.internal.TypeComparators;
import org.assertj.core.util.Objects;

public class ExtendedByTypesComparator
implements Comparator<Object> {
    private final Comparator<Object> comparator;
    private final TypeComparators comparatorsByType;

    public ExtendedByTypesComparator(TypeComparators comparatorsByType) {
        this(new Comparator<Object>(){

            @Override
            public int compare(Object actual, Object other) {
                return Objects.areEqual(actual, other) ? 0 : -1;
            }

            public String toString() {
                return "AssertJ Object comparator";
            }
        }, comparatorsByType);
    }

    public ExtendedByTypesComparator(Comparator<Object> comparator, TypeComparators comparatorsByType) {
        this.comparator = comparator;
        this.comparatorsByType = comparatorsByType;
    }

    @Override
    public int compare(Object actual, Object other) {
        Comparator<?> comparatorByType;
        if (actual == null && other == null) {
            return 0;
        }
        if (actual == null || other == null) {
            return -1;
        }
        Comparator<?> comparator = comparatorByType = this.comparatorsByType == null ? null : this.comparatorsByType.get(actual.getClass());
        if (comparatorByType != null) {
            return other.getClass().isInstance(actual) ? comparatorByType.compare(actual, other) : -1;
        }
        return this.comparator.compare(actual, other);
    }

    public Comparator<Object> getComparator() {
        return this.comparator;
    }

    public String toString() {
        return this.comparatorsByType.isEmpty() ? String.format("%s", this.comparator) : String.format("%s%n- for elements (by type): %s", this.comparator, this.comparatorsByType);
    }
}

