/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error.uri;

import java.net.URI;
import java.net.URL;
import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.util.Strings;

public class ShouldHavePath
extends BasicErrorMessageFactory {
    private static final String SHOULD_NOT_HAVE_PATH = "%nExpecting:%n  <%s>%nnot to have a path but had:%n  <%s>";
    private static final String SHOULD_HAVE_PATH = "%nExpecting path of%n  <%s>%nto be:%n  <%s>%nbut was:%n  <%s>";

    public static ErrorMessageFactory shouldHavePath(URI actual, String expectedPath) {
        return expectedPath == null ? new ShouldHavePath(actual) : new ShouldHavePath(actual, expectedPath);
    }

    private ShouldHavePath(URI actual, String expectedPath) {
        super(SHOULD_HAVE_PATH, actual, expectedPath, actual.getPath());
    }

    private ShouldHavePath(URI actual) {
        super(SHOULD_NOT_HAVE_PATH, actual, actual.getPath());
    }

    public static ErrorMessageFactory shouldHavePath(URL actual, String expectedPath) {
        return Strings.isNullOrEmpty(expectedPath) ? new ShouldHavePath(actual) : new ShouldHavePath(actual, expectedPath);
    }

    private ShouldHavePath(URL actual, String expectedPath) {
        super(SHOULD_HAVE_PATH, actual, expectedPath, actual.getPath());
    }

    private ShouldHavePath(URL actual) {
        super(SHOULD_NOT_HAVE_PATH, actual, actual.getPath());
    }
}

