/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.tools.report.appenders.usage;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.polarsys.capella.common.tools.report.appenders.usage.UsageAppenderPlugin;
import org.polarsys.capella.common.tools.report.appenders.usage.preferences.IUsagePreferences;
import org.polarsys.capella.common.tools.report.appenders.usage.util.UsageLogger;
import org.polarsys.capella.common.tools.report.appenders.usage.util.UsageMonitoring;
import org.polarsys.capella.core.commands.preferences.service.AbstractPreferencesInitializer;

public class UsageMonitoringLogger {
    private static UsageMonitoringLogger instance;
    private final UsageLogger logger;
    public static String USAGE_PATH;
    private final String pathRegex = ".*\\$\\{[^\\}]+\\}.*";
    private final String varRegex = "(\\$\\{[^\\}]+\\})";

    static {
        USAGE_PATH = "UsagePath";
    }

    public static UsageMonitoringLogger getInstance() {
        if (instance == null) {
            instance = new UsageMonitoringLogger();
        }
        return instance;
    }

    private void setUsagePath() {
        String usagePathProperty = System.getProperty(USAGE_PATH);
        if (usagePathProperty == null || "".equals(usagePathProperty)) {
            System.setProperty(USAGE_PATH, ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString());
        } else if (usagePathProperty.matches(".*\\$\\{[^\\}]+\\}.*")) {
            boolean unresolvableVar = false;
            Matcher matcher = Pattern.compile("(\\$\\{[^\\}]+\\})").matcher(usagePathProperty);
            while (matcher.find()) {
                String variableName = this.getVariableName(matcher.group());
                String varValue = this.getVariableValue(variableName);
                if (varValue == null) {
                    UsageAppenderPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.polarsys.capella.common.tools.report.appenders.usage", "Undefined environment variable: " + variableName + " found in -DUsagePath configuration. The log file will be put in the workspace."));
                    unresolvableVar = true;
                    break;
                }
                usagePathProperty = usagePathProperty.replaceFirst("(\\$\\{[^\\}]+\\})", Matcher.quoteReplacement(varValue));
            }
            if (!unresolvableVar) {
                System.setProperty(USAGE_PATH, usagePathProperty);
            } else {
                System.setProperty(USAGE_PATH, ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString());
            }
        }
    }

    private String getVariableName(String match) {
        return match.substring(2, match.lastIndexOf(125));
    }

    private String getVariableValue(String varName) {
        String value = System.getenv(varName);
        return value != null ? value : System.getProperty(varName);
    }

    private UsageMonitoringLogger() {
        this.setUsagePath();
        if (Platform.getProduct() != null) {
            String productName = Platform.getProduct().getName().toString();
            String productVersion = Platform.getProduct().getDefiningBundle().getVersion().toString();
            this.logger = new UsageLogger(productName, productVersion);
        } else {
            this.logger = new UsageLogger("", "");
        }
    }

    public void log(String eventName, UsageMonitoring.EventStatus eventStatus) {
        if (this.isUsageMonitoringActivated()) {
            this.logger.log(eventName, eventStatus);
        }
    }

    public void log(String eventName, String eventContext, UsageMonitoring.EventStatus eventStatus) {
        if (this.isUsageMonitoringActivated()) {
            this.logger.log(eventName, eventContext, eventStatus);
        }
    }

    public void log(String eventName, String eventContext, UsageMonitoring.EventStatus eventStatus, String addendum) {
        if (this.isUsageMonitoringActivated()) {
            this.logger.log(eventName, eventContext, eventStatus, addendum);
        }
    }

    public boolean isUsageMonitoringActivated() {
        return AbstractPreferencesInitializer.getBoolean((String)"usage.activated", (boolean)IUsagePreferences.PREFERENCES_ACTIVATE_USAGE_MONITORING_DEFAULT);
    }
}

