/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.capellacore.services;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.common.util.EList;
import org.polarsys.capella.core.data.capellacore.CapellacoreFactory;
import org.polarsys.capella.core.data.capellacore.GeneralizableElement;
import org.polarsys.capella.core.data.capellacore.Generalization;

public class GeneralizableElementExt {
    public static void removeSuperGeneralizableElement(GeneralizableElement generalizableElement, GeneralizableElement superGeneralizableElement) {
        if (generalizableElement != null && superGeneralizableElement != null) {
            Generalization generalization = null;
            ListIterator it = generalizableElement.getSuperGeneralizations().listIterator();
            while (it.hasNext()) {
                Generalization gen = (Generalization)it.next();
                if (!gen.getSuper().equals(superGeneralizableElement)) continue;
                generalization = gen;
            }
            if (generalization != null) {
                generalization.destroy();
            }
        }
    }

    public static boolean isInheritancyCycleCompatible(GeneralizableElement elementA, GeneralizableElement elementB) {
        return !GeneralizableElementExt.getAllSuperGeneralizableElements(elementA).contains(elementB) && !GeneralizableElementExt.getAllSuperGeneralizableElements(elementB).contains(elementA);
    }

    public static List<GeneralizableElement> getAllSuperGeneralizableElements(GeneralizableElement generalizableElement) {
        ArrayList<GeneralizableElement> superGeneralizableElements = new ArrayList<GeneralizableElement>();
        if (generalizableElement != null) {
            GeneralizableElementExt.getAllSuperGeneralizableElements2(generalizableElement, superGeneralizableElements);
        }
        return superGeneralizableElements;
    }

    private static void getAllSuperGeneralizableElements2(GeneralizableElement generalizableElement1, List<GeneralizableElement> list) {
        for (GeneralizableElement generalizableElement : generalizableElement1.getSuper()) {
            if (list.contains(generalizableElement)) continue;
            list.add(generalizableElement);
            GeneralizableElementExt.getAllSuperGeneralizableElements2(generalizableElement, list);
        }
    }

    public static List<GeneralizableElement> getAllSubGeneralizableElements(GeneralizableElement generalizableElement) {
        ArrayList<GeneralizableElement> subGeneralizableElements = new ArrayList<GeneralizableElement>();
        if (generalizableElement != null) {
            GeneralizableElementExt.getAllSubGeneralizableElements2(generalizableElement, subGeneralizableElements);
        }
        return subGeneralizableElements;
    }

    private static void getAllSubGeneralizableElements2(GeneralizableElement generalizableElement1, List<GeneralizableElement> list) {
        for (GeneralizableElement generalizableElement : generalizableElement1.getSub()) {
            if (list.contains(generalizableElement)) continue;
            list.add(generalizableElement);
            GeneralizableElementExt.getAllSubGeneralizableElements2(generalizableElement, list);
        }
    }

    public static void addSuperGeneralizableElement(GeneralizableElement generalizableElement, GeneralizableElement superGeneralizableElement) {
        if (generalizableElement != null && superGeneralizableElement != null) {
            Generalization generalization = CapellacoreFactory.eINSTANCE.createGeneralization();
            generalizableElement.getOwnedGeneralizations().add((Object)generalization);
            generalization.setSub(generalizableElement);
            generalization.setSuper(superGeneralizableElement);
        }
    }

    public static List<GeneralizableElement> getRootSupertypes(GeneralizableElement classifier) {
        ArrayList<GeneralizableElement> list = new ArrayList<GeneralizableElement>();
        if (classifier != null) {
            for (Generalization generalization : classifier.getSuperGeneralizations()) {
                GeneralizableElement superCls = generalization.getSuper();
                if (superCls == null) continue;
                EList supertypes = superCls.getSuper();
                if (supertypes == null || supertypes.isEmpty()) {
                    list.add(superCls);
                    continue;
                }
                list.addAll(GeneralizableElementExt.getRootSupertypes(superCls));
            }
        }
        if (list.isEmpty()) {
            list.add(classifier);
        }
        return list;
    }
}

