/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.mdsofa.common.misc;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class ExtensionClassDescriptor {
    private static final String ATTR_CLASS = "class";
    private String className;
    private String contributorPluginId;

    public ExtensionClassDescriptor(IConfigurationElement configurationElement) {
        Assert.isNotNull((Object)configurationElement);
        this.contributorPluginId = configurationElement.getContributor().getName();
        Assert.isNotNull((Object)this.contributorPluginId);
        this.className = configurationElement.getAttribute(ATTR_CLASS);
        Assert.isNotNull((Object)this.className);
    }

    public String getContributorPluginId() {
        return this.contributorPluginId;
    }

    public String getClassName() {
        return this.className;
    }

    public Class<?> loadClass() throws Exception {
        Bundle bundle = Platform.getBundle((String)this.contributorPluginId);
        if (bundle == null) {
            throw new IllegalStateException("Cannot locate contributor plug-in '" + this.contributorPluginId + "'");
        }
        return bundle.loadClass(this.className);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + (this.contributorPluginId == null ? 0 : this.contributorPluginId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExtensionClassDescriptor other = (ExtensionClassDescriptor)obj;
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        return !(this.contributorPluginId == null ? other.contributorPluginId != null : !this.contributorPluginId.equals(other.contributorPluginId));
    }
}

