/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.properties.sections;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.core.data.capellacore.BooleanPropertyValue;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.capellacore.EnumerationPropertyLiteral;
import org.polarsys.capella.core.data.capellacore.EnumerationPropertyValue;
import org.polarsys.capella.core.data.capellacore.FloatPropertyValue;
import org.polarsys.capella.core.data.capellacore.IntegerPropertyValue;
import org.polarsys.capella.core.data.capellacore.PropertyValueGroup;
import org.polarsys.capella.core.data.capellacore.StringPropertyValue;
import org.polarsys.capella.core.model.handler.helpers.CapellaAdapterHelper;
import org.polarsys.capella.core.ui.properties.controllers.CapellaElement_AppliedPropertyValueGroups;
import org.polarsys.capella.core.ui.properties.controllers.CapellaElement_AppliedPropertyValues;
import org.polarsys.capella.core.ui.properties.fields.AbstractSemanticField;
import org.polarsys.capella.core.ui.properties.fields.ReferenceTableField;
import org.polarsys.capella.core.ui.properties.sections.AbstractSection;
import org.polarsys.capella.core.ui.properties.sections.Messages;
import org.polarsys.capella.core.ui.properties.viewers.AbstractPropertyValueCellEditorProvider;
import org.polarsys.capella.core.ui.properties.viewers.TableDelegatedViewer;
import org.polarsys.capella.core.ui.properties.viewers.TreeDelegatedViewer;

public class CapellaExtensionsPropertySection
extends AbstractSection
implements IFilter {
    private ReferenceTableField _appliedPropertyValuesTableField;
    private ReferenceTableField _appliedPropertyValueGroupsTableField;
    protected final String[] _columnProperties = new String[]{Messages.Name_ColumnViewer_Label, Messages.Value_ColumnViewer_Label, Messages.Summary_ColumnViewer_Label};

    @Override
    protected int getColumnCount() {
        return 1;
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    @Override
    public void createContents(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        boolean displayedInWizard = this.isDisplayedInWizard();
        Group grp = this.getWidgetFactory().createGroup(parent, "");
        grp.setLayout((Layout)new GridLayout(1, false));
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.horizontalSpan = 2;
        grp.setLayoutData((Object)layoutData);
        this._appliedPropertyValuesTableField = new ReferenceTableField((Composite)grp, this.getWidgetFactory(), null, Messages.AppliedPropertyValues_Label, new CapellaElement_AppliedPropertyValues(), new TableDelegatedViewer(this.getWidgetFactory(), new AbstractPropertyValueCellEditorProvider()){

            @Override
            protected String[] getColumnProperties() {
                return CapellaExtensionsPropertySection.this._columnProperties;
            }

            @Override
            protected boolean createViewerColumns() {
                this.createTableViewerColumn(0, new NameColumnLabelProvider());
                this.createTableViewerColumn(1, new ValueColumnLabelProvider());
                this.createTableViewerColumn(2, new SummaryColumnLabelProvider());
                return true;
            }

            @Override
            protected void modifyElement(final EObject element, final int column, final Object value) {
                CapellaExtensionsPropertySection.this.executeCommmand((ICommand)new AbstractReadWriteCommand(){

                    public void run() {
                        this.getCellEditorProvider().modifyElement(element, column, value);
                    }
                });
            }
        });
        this._appliedPropertyValuesTableField.setDisplayedInWizard(displayedInWizard);
        grp = this.getWidgetFactory().createGroup(parent, "");
        grp.setLayout((Layout)new GridLayout(1, false));
        layoutData = new GridData(4, 4, true, true);
        layoutData.horizontalSpan = 2;
        grp.setLayoutData((Object)layoutData);
        this._appliedPropertyValueGroupsTableField = new ReferenceTableField((Composite)grp, this.getWidgetFactory(), null, Messages.AppliedPropertyValueGroups_Label, new CapellaElement_AppliedPropertyValueGroups(), new TreeDelegatedViewer(this.getWidgetFactory(), new AbstractPropertyValueCellEditorProvider()){

            @Override
            protected String[] getColumnProperties() {
                return CapellaExtensionsPropertySection.this._columnProperties;
            }

            @Override
            protected boolean createViewerColumns() {
                this.createTreeViewerColumn(0, (CellLabelProvider)new NameColumnLabelProvider());
                this.createTreeViewerColumn(1, (CellLabelProvider)new ValueColumnLabelProvider());
                this.createTreeViewerColumn(2, (CellLabelProvider)new SummaryColumnLabelProvider());
                return true;
            }

            @Override
            protected void modifyElement(final EObject element, final int column, final Object value) {
                CapellaExtensionsPropertySection.this.executeCommmand((ICommand)new AbstractReadWriteCommand(){

                    public void run() {
                        this.getCellEditorProvider().modifyElement(element, column, value);
                    }
                });
            }
        }){

            @Override
            protected boolean isSelectionValid(Object selection) {
                return selection instanceof PropertyValueGroup;
            }
        };
        this._appliedPropertyValueGroupsTableField.setDisplayedInWizard(displayedInWizard);
    }

    @Override
    public void loadData(EObject capellaElement) {
        super.loadData(capellaElement);
        this._appliedPropertyValuesTableField.loadData(capellaElement, (EStructuralFeature)CapellacorePackage.eINSTANCE.getCapellaElement_AppliedPropertyValues());
        this._appliedPropertyValueGroupsTableField.loadData(capellaElement, (EStructuralFeature)CapellacorePackage.eINSTANCE.getCapellaElement_AppliedPropertyValueGroups());
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        EObject selectedElement;
        if (selection instanceof StructuredSelection && (selectedElement = CapellaAdapterHelper.resolveBusinessObject((Object)((StructuredSelection)selection).getFirstElement())) instanceof CapellaElement) {
            this.loadData((EObject)((CapellaElement)selectedElement));
        }
        super.setInput(part, selection);
    }

    @Override
    public boolean select(Object toTest) {
        EObject eObj = CapellaAdapterHelper.resolveDescriptorOrBusinessObject((Object)toTest);
        return eObj instanceof CapellaElement;
    }

    @Override
    public List<AbstractSemanticField> getSemanticFields() {
        ArrayList<AbstractSemanticField> fields = new ArrayList<AbstractSemanticField>();
        fields.add(this._appliedPropertyValuesTableField);
        fields.add(this._appliedPropertyValueGroupsTableField);
        return fields;
    }

    protected class NameColumnLabelProvider
    extends ColumnLabelProvider {
        protected NameColumnLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof AbstractNamedElement) {
                return ((AbstractNamedElement)element).getName();
            }
            return "";
        }

        public Image getImage(Object element) {
            if (element instanceof EObject) {
                return ExtendedImageRegistry.getInstance().getImage(EObjectLabelProviderHelper.getImage((EObject)((EObject)element)));
            }
            return super.getImage(element);
        }
    }

    protected class SummaryColumnLabelProvider
    extends ColumnLabelProvider {
        protected SummaryColumnLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof CapellaElement) {
                return ((CapellaElement)element).getSummary();
            }
            return "";
        }
    }

    protected class ValueColumnLabelProvider
    extends ColumnLabelProvider {
        protected ValueColumnLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof BooleanPropertyValue) {
                return Boolean.toString(((BooleanPropertyValue)element).isValue());
            }
            if (element instanceof EnumerationPropertyValue) {
                EnumerationPropertyLiteral literal = ((EnumerationPropertyValue)element).getValue();
                return literal != null ? literal.getName() : Messages.UndefinedValue;
            }
            if (element instanceof FloatPropertyValue) {
                return Float.toString(((FloatPropertyValue)element).getValue());
            }
            if (element instanceof IntegerPropertyValue) {
                return Integer.toString(((IntegerPropertyValue)element).getValue());
            }
            if (element instanceof StringPropertyValue) {
                return ((StringPropertyValue)element).getValue();
            }
            return "";
        }
    }
}

