/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.properties.property;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.polarsys.capella.common.flexibility.properties.schema.IProperty;
import org.polarsys.capella.common.flexibility.properties.schema.IPropertyContext;
import org.polarsys.capella.common.flexibility.properties.schema.PropertiesSchemaConstants;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.ui.properties.property.PropertiesServices;
import org.polarsys.capella.core.ui.properties.property.PropertyValueProperty;

public abstract class StringPropertyValueProperty
extends PropertyValueProperty {
    @Override
    protected abstract String[] getPathProperty();

    @Override
    protected void unsetPropertyValue(NamedElement element) {
        PropertiesServices.unsetProperty((CapellaElement)element, this.getPathProperty());
    }

    @Override
    protected void setPropertyValue(NamedElement element, String value) {
        PropertiesServices.setPropertyValue((CapellaElement)element, this.getPathProperty(), value, true);
    }

    @Override
    protected String getPropertyValue(NamedElement element) {
        return PropertiesServices.getPropertyValue((CapellaElement)element, this.getPathProperty(), "");
    }

    @Override
    public Object getType() {
        return String.class;
    }

    @Override
    public Object toType(Object value, IPropertyContext context) {
        if (value != null && !"".equals(value)) {
            return String.valueOf(value.toString());
        }
        return null;
    }

    @Override
    public Object getValue(IPropertyContext context) {
        NamedElement element = (NamedElement)this.getSource(context);
        return new String(this.getPropertyValue(element));
    }

    @Override
    public void setValue(IPropertyContext context) {
        Object value = context.getCurrentValue((IProperty)this);
        NamedElement element = (NamedElement)this.getSource(context);
        if (value != null && value instanceof String) {
            this.setPropertyValue(element, (String)value);
        } else {
            this.unsetPropertyValue(element);
        }
    }

    @Override
    public IStatus validate(Object newValue, IPropertyContext context) {
        try {
            if (newValue != null) {
                String value = String.valueOf(newValue);
                String validOnEmpty = this.getParameter(PropertiesSchemaConstants.PropertiesSchema_STRING_PROPERTY__EMPTY_IS_VALID);
                if (validOnEmpty != null && "false".equals(validOnEmpty) && value.length() == 0) {
                    return new Status(4, this.getId(), "Empty value isn't valid");
                }
            }
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            return new Status(4, this.getId(), e.getMessage());
        }
    }
}

