/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.commands.preferences.service;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.polarsys.capella.core.commands.preferences.util.PreferencesHelper;
import org.polarsys.capella.core.preferences.Activator;

public class PreferenceDirectoryFieldEditor
extends DirectoryFieldEditor {
    private File _filterPath = null;

    public PreferenceDirectoryFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
    }

    protected boolean doCheckState() {
        String fileName = this.getText();
        if ((fileName = fileName.trim()).length() == 0 && this.isEmptyStringAllowed()) {
            return true;
        }
        File file = new File(fileName);
        return file.isDirectory();
    }

    protected String changePressed() {
        File d;
        File f = new File(this.getText());
        if (!f.exists()) {
            f = null;
        }
        return (d = this.getDirectory2(f)) == null ? null : d.getAbsolutePath();
    }

    public void setFilterPath(File path) {
        super.setFilterPath(path);
        this._filterPath = path;
    }

    private File getDirectory2(File startingDirectory) {
        DirectoryDialog fileDialog = new DirectoryDialog(this.getShell(), 0x10001000);
        if (startingDirectory != null) {
            fileDialog.setFilterPath(startingDirectory.getPath());
        } else if (this._filterPath != null) {
            fileDialog.setFilterPath(this._filterPath.getPath());
        }
        String dir = fileDialog.open();
        if (dir != null && (dir = dir.trim()).length() > 0) {
            return new File(dir);
        }
        return null;
    }

    private String getText() {
        String fileName;
        IStringVariableManager svm = VariablesPlugin.getDefault().getStringVariableManager();
        try {
            fileName = svm.performStringSubstitution(this.getTextControl().getText());
        }
        catch (CoreException exception_p) {
            fileName = this.getTextControl().getText();
        }
        return fileName;
    }

    public IPreferenceStore getPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    protected void fireValueChanged(String property_p, Object oldValue_p, Object newValue_p) {
        super.fireValueChanged(property_p, oldValue_p, newValue_p);
    }

    public String getPreferenceName() {
        IProject selectedProject;
        IProject iProject = selectedProject = PreferencesHelper.getSelectedEclipseProject() != null ? PreferencesHelper.getSelectedEclipseProject() : PreferencesHelper.getSelectedCapellaProject();
        if (selectedProject != null) {
            return String.valueOf(selectedProject.getName()) + "." + super.getPreferenceName();
        }
        return super.getPreferenceName();
    }
}

