/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.exchanges;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.sirius.common.tools.api.util.SiriusCrossReferenceAdapter;
import org.polarsys.capella.common.data.activity.ActivityNode;
import org.polarsys.capella.common.data.modellingcore.InformationsExchanger;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.platform.sirius.ted.SemanticEditingDomainFactory;
import org.polarsys.capella.core.data.capellacore.Type;
import org.polarsys.capella.core.data.cs.AbstractDeploymentLink;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsFactory;
import org.polarsys.capella.core.data.cs.DeployableElement;
import org.polarsys.capella.core.data.cs.DeploymentTarget;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.cs.PhysicalPort;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentExchangeAllocation;
import org.polarsys.capella.core.data.fa.ComponentExchangeKind;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.fa.ComponentPortAllocation;
import org.polarsys.capella.core.data.fa.ExchangeSpecification;
import org.polarsys.capella.core.data.fa.FaFactory;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.helpers.cache.ModelCache;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionalExt;
import org.polarsys.capella.core.data.information.AbstractEventOperation;
import org.polarsys.capella.core.data.information.Port;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentNature;
import org.polarsys.capella.core.data.pa.deployment.PartDeploymentLink;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.PartExt;
import org.polarsys.capella.core.model.helpers.PhysicalLinkExt;
import org.polarsys.capella.core.model.helpers.PortExt;
import org.polarsys.capella.core.projection.exchanges.DefaultExchangesCreator;

public class NodePhysicalComponentExchangesCreator
extends DefaultExchangesCreator {
    private Part part = null;

    public NodePhysicalComponentExchangesCreator(Component component, Part part) {
        super(component);
        if (part != null) {
            this.part = part;
        }
    }

    @Override
    public void createExchanges() {
        if (this._component instanceof PhysicalComponent) {
            PhysicalComponent node = (PhysicalComponent)this._component;
            this.createExchangesForPhysicalComponents(node);
            super.createExchanges();
        }
    }

    @Override
    protected boolean isValidBound(Component component) {
        if (component instanceof PhysicalComponent) {
            PhysicalComponent cpnt = (PhysicalComponent)component;
            PhysicalComponentNature nature = cpnt.getNature();
            if (cpnt instanceof PhysicalComponent && nature == PhysicalComponentNature.NODE) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean isValidCreation(AbstractEventOperation fe, Component component, Component allocating) {
        return this.isValidBound(component) && this.isValidBound(allocating);
    }

    protected void createExchangesForPhysicalComponents(PhysicalComponent containerPC) {
        EList deployments = this.part.getDeploymentLinks();
        for (AbstractDeploymentLink deployment : deployments) {
            if (!(deployment instanceof PartDeploymentLink)) continue;
            PartDeploymentLink deploymentLink = (PartDeploymentLink)deployment;
            DeployableElement deployedElement = deploymentLink.getDeployedElement();
            if (deployedElement instanceof Part) {
                Part part = (Part)deployedElement;
                Type containedPC = part.getType();
                if (containedPC == null) continue;
                this.createExchangesForPhysicalComponents(containerPC, containedPC);
                continue;
            }
            if (!(deployedElement instanceof PhysicalComponent)) continue;
            this.createExchangesForPhysicalComponents(containerPC, (Type)((PhysicalComponent)deployedElement));
        }
        containerPC.getOwnedPhysicalComponents().stream().filter(c -> ComponentExt.isActor((Component)c)).forEach(actor -> this.createExchangesForPhysicalComponents(containerPC, (Type)actor));
    }

    private void createExchangesForPhysicalComponents(PhysicalComponent sourceContainerPC, Type sourceContainedPC) {
        if (sourceContainedPC instanceof PhysicalComponent) {
            PhysicalComponent containedPhysicalComponent = (PhysicalComponent)sourceContainedPC;
            for (ComponentPort port : ComponentExt.getOwnedComponentPort((Component)containedPhysicalComponent)) {
                for (ComponentExchange connection : port.getComponentExchanges()) {
                    EObject targetContainedPC;
                    InformationsExchanger target;
                    if (connection.getKind() == ComponentExchangeKind.DELEGATION || connection.getKind() == ComponentExchangeKind.UNSET || this.doesNodeAlreadyHaveAPhysicalLinkForComponentExchange(sourceContainerPC, connection) || !((target = FunctionalExt.getOtherBound((ExchangeSpecification)connection, (InformationsExchanger)port)) instanceof ComponentPort) || !((targetContainedPC = target.eContainer()) instanceof PhysicalComponent)) continue;
                    for (Part partition : ((PhysicalComponent)targetContainedPC).getRepresentingParts()) {
                        for (DeploymentTarget deploying : (List)ModelCache.getCache(PartExt::getDeployingElements, (Object)partition)) {
                            Part deployingPart;
                            if (!(deploying instanceof Part) || !((deployingPart = (Part)deploying).getAbstractType() instanceof PhysicalComponent)) continue;
                            PhysicalComponent targetContainerPC = (PhysicalComponent)deployingPart.getAbstractType();
                            this.createPhysicalLink(connection, sourceContainerPC, targetContainerPC, port);
                        }
                    }
                    if (!ComponentExt.isActor((EObject)targetContainedPC) || !(targetContainedPC.eContainer() instanceof PhysicalComponent)) continue;
                    PhysicalComponent targetContainerPC = (PhysicalComponent)targetContainedPC.eContainer();
                    this.createPhysicalLink(connection, sourceContainerPC, targetContainerPC, port);
                }
            }
        }
    }

    private void createPhysicalLink(ComponentExchange connection, PhysicalComponent sourceContainerPC, PhysicalComponent targetContainerPC, ComponentPort sourcePort) {
        if (this.isValidCreation((AbstractEventOperation)connection, (Component)sourceContainerPC, (Component)targetContainerPC) && !this.doesNodeAlreadyHaveAPhysicalLinkForComponentExchange(sourceContainerPC, connection)) {
            if (connection.getSource().equals(sourcePort)) {
                this.doCreateExchange(connection, (Component)sourceContainerPC, (Component)targetContainerPC);
            } else {
                this.doCreateExchange(connection, (Component)targetContainerPC, (Component)sourceContainerPC);
            }
        }
    }

    @Override
    protected void doCreateExchange(FunctionalExchange functionalExchange, Component exchangeOutput, Component exchangeInput) {
        PhysicalLink physicalLink = CsFactory.eINSTANCE.createPhysicalLink(functionalExchange.getLabel());
        PhysicalPort outP = CsFactory.eINSTANCE.createPhysicalPort(functionalExchange.getSource().getName());
        PhysicalPort inP = CsFactory.eINSTANCE.createPhysicalPort(functionalExchange.getTarget().getName());
        physicalLink.getLinkEnds().add((Object)outP);
        physicalLink.getLinkEnds().add((Object)inP);
        exchangeInput.getOwnedFeatures().add((Object)inP);
        exchangeOutput.getOwnedFeatures().add((Object)outP);
        PhysicalLinkExt.attachToDefaultContainer((PhysicalLink)physicalLink);
        PortExt.attachPort((Port)outP, (ActivityNode)functionalExchange.getSource());
        PortExt.attachPort((Port)inP, (ActivityNode)functionalExchange.getTarget());
    }

    protected void doCreateExchange(ComponentExchange componentExchange, Component exchangeOutput, Component exchangeInput) {
        if (exchangeOutput == exchangeInput) {
            return;
        }
        PhysicalLink physicalLink = CsFactory.eINSTANCE.createPhysicalLink(componentExchange.getLabel());
        PhysicalPort outP = CsFactory.eINSTANCE.createPhysicalPort(componentExchange.getSource().getLabel());
        PhysicalPort inP = CsFactory.eINSTANCE.createPhysicalPort(componentExchange.getTarget().getLabel());
        physicalLink.getLinkEnds().add((Object)outP);
        physicalLink.getLinkEnds().add((Object)inP);
        exchangeInput.getOwnedFeatures().add((Object)inP);
        exchangeOutput.getOwnedFeatures().add((Object)outP);
        CapellaElementExt.creationService((EObject)inP);
        CapellaElementExt.creationService((EObject)outP);
        PhysicalLinkExt.attachToDefaultContainer((PhysicalLink)physicalLink);
        CapellaElementExt.creationService((EObject)physicalLink);
        ComponentExchangeAllocation cea = FaFactory.eINSTANCE.createComponentExchangeAllocation();
        cea.setSourceElement((TraceableElement)physicalLink);
        cea.setTargetElement((TraceableElement)componentExchange);
        physicalLink.getOwnedComponentExchangeAllocations().add((Object)cea);
        CapellaElementExt.creationService((EObject)cea);
        InformationsExchanger target = componentExchange.getTarget();
        this.createComponentPortAllocation(target, inP);
        InformationsExchanger source = componentExchange.getSource();
        this.createComponentPortAllocation(source, outP);
    }

    private ComponentPortAllocation createComponentPortAllocation(InformationsExchanger informationExchange, PhysicalPort physicalPort) {
        ComponentPortAllocation allocation = FaFactory.eINSTANCE.createComponentPortAllocation();
        allocation.setSourceElement((TraceableElement)physicalPort);
        allocation.setTargetElement((TraceableElement)informationExchange);
        physicalPort.getOwnedComponentPortAllocations().add((Object)allocation);
        CapellaElementExt.creationService((EObject)allocation);
        return allocation;
    }

    protected boolean doesNodeAlreadyHaveAPhysicalLinkForComponentExchange(PhysicalComponent physicalComponent, ComponentExchange componentExchange) {
        boolean result = false;
        SemanticEditingDomainFactory.SemanticEditingDomain editingDomain = (SemanticEditingDomainFactory.SemanticEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)componentExchange);
        SiriusCrossReferenceAdapter crossReferencer = editingDomain.getCrossReferencer();
        Collection inverseReferences = crossReferencer.getInverseReferences((EObject)componentExchange, true);
        for (EStructuralFeature.Setting setting : inverseReferences) {
            if (!(setting.getEObject() instanceof ComponentExchangeAllocation)) continue;
            result = true;
            break;
        }
        return result;
    }
}

