/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.exchanges;

import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.ctx.SystemComponent;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentNature;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.projection.exchanges.ComponentExchangesCreator;
import org.polarsys.capella.core.projection.exchanges.DefaultExchangesCreator;
import org.polarsys.capella.core.projection.exchanges.EntityExchangesCreator;
import org.polarsys.capella.core.projection.exchanges.IExchangesCreator;
import org.polarsys.capella.core.projection.exchanges.NodePhysicalComponentExchangesCreator;
import org.polarsys.capella.core.projection.exchanges.PhysicalActorExchangesCreator;

public class ConnectionCreatorFactory {
    public static IExchangesCreator createConnectionCreator(Component component_p, Part part_p) {
        if (component_p instanceof Entity) {
            return new EntityExchangesCreator(component_p);
        }
        if (component_p instanceof LogicalComponent) {
            return new ComponentExchangesCreator(component_p, part_p);
        }
        if (component_p instanceof SystemComponent) {
            return new ComponentExchangesCreator(component_p, part_p);
        }
        if (component_p instanceof PhysicalComponent) {
            PhysicalComponent pc = (PhysicalComponent)component_p;
            if (ComponentExt.isActor((Component)pc)) {
                return new PhysicalActorExchangesCreator(component_p, part_p);
            }
            if (pc.getNature() == PhysicalComponentNature.NODE) {
                return new NodePhysicalComponentExchangesCreator(component_p, part_p);
            }
        }
        return new DefaultExchangesCreator(component_p);
    }
}

