/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.actions.providers;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.CloneAction;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.SelectionHelper;
import org.polarsys.capella.core.platform.sirius.ui.navigator.view.CapellaCommonNavigator;
import org.polarsys.capella.core.sirius.ui.actions.DeleteRepresentationAction;
import org.polarsys.capella.core.sirius.ui.actions.MoveRepresentationsAction;
import org.polarsys.capella.core.sirius.ui.actions.OpenRepresentationsAction;
import org.polarsys.capella.core.sirius.ui.actions.RenameRepresentationAction;

public class RepresentationActionProvider
extends CommonActionProvider {
    private DeleteRepresentationAction _deleteRepresentationAction;
    private RenameRepresentationAction _renameRepresentationAction;
    private OpenRepresentationsAction _openRepresentation;
    private MoveRepresentationsAction _moveRepresentation;
    private CloneAction _cloneAction;

    public void init(ICommonActionExtensionSite site_p) {
        super.init(site_p);
        ICommonViewerSite commonViewSite = site_p.getViewSite();
        if (!(commonViewSite instanceof ICommonViewerWorkbenchSite)) {
            return;
        }
        ICommonViewerWorkbenchSite commonViewerWorkbenchSite = (ICommonViewerWorkbenchSite)commonViewSite;
        CapellaCommonNavigator activePart = (CapellaCommonNavigator)commonViewerWorkbenchSite.getPart();
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        ISelectionProvider selectionProvider = commonViewSite.getSelectionProvider();
        this._deleteRepresentationAction = new DeleteRepresentationAction();
        this._deleteRepresentationAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this._deleteRepresentationAction.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        SelectionHelper.registerToSelectionChanges((ISelectionChangedListener)this._deleteRepresentationAction, selectionProvider);
        this._renameRepresentationAction = new RenameRepresentationAction();
        SelectionHelper.registerToSelectionChanges((ISelectionChangedListener)this._renameRepresentationAction, selectionProvider);
        this._openRepresentation = new OpenRepresentationsAction();
        SelectionHelper.registerToSelectionChanges((ISelectionChangedListener)this._openRepresentation, selectionProvider);
        this._moveRepresentation = new MoveRepresentationsAction();
        this._moveRepresentation.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sirius.ui", (String)"/icons/full/others/forward.gif"));
        SelectionHelper.registerToSelectionChanges((ISelectionChangedListener)this._moveRepresentation, selectionProvider);
        this._cloneAction = new CloneAction((TreeViewer)activePart.getCommonViewer());
        this._cloneAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        SelectionHelper.registerToSelectionChanges((ISelectionChangedListener)this._cloneAction, selectionProvider);
    }

    public void fillActionBars(IActionBars actionBars_p) {
        actionBars_p.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this._openRepresentation);
        actionBars_p.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this._deleteRepresentationAction);
        actionBars_p.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this._renameRepresentationAction);
    }

    public void fillContextMenu(IMenuManager menu_p) {
        menu_p.appendToGroup("group.open", (IAction)this._openRepresentation);
        menu_p.appendToGroup("group.edit", (IAction)this._cloneAction);
        menu_p.appendToGroup("group.edit", (IAction)this._deleteRepresentationAction);
        menu_p.appendToGroup("group.port", (IContributionItem)new Separator());
        menu_p.appendToGroup("group.port", (IAction)this._moveRepresentation);
        menu_p.appendToGroup("group.port", (IAction)this._renameRepresentationAction);
    }

    public void dispose() {
        ISelectionProvider selectionProvider = this.getActionSite().getViewSite().getSelectionProvider();
        if (this._renameRepresentationAction != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this._renameRepresentationAction);
            this._renameRepresentationAction = null;
        }
        if (this._deleteRepresentationAction != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this._deleteRepresentationAction);
            this._deleteRepresentationAction = null;
        }
        if (this._openRepresentation != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this._openRepresentation);
            this._openRepresentation = null;
        }
        if (this._moveRepresentation != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this._moveRepresentation);
            this._moveRepresentation = null;
        }
        if (this._cloneAction != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this._cloneAction);
            this._cloneAction = null;
        }
        super.dispose();
    }
}

