/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditor;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.helpers.cache.ModelCache;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.model.handler.helpers.CapellaAdapterHelper;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.Messages;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;

public class ShowInDiagramAction
extends BaseSelectionListenerAction
implements IViewActionDelegate {
    public ShowInDiagramAction() {
        super(Messages.ShowInDiagramAction_Title);
        this.setActionDefinitionId("org.polarsys.capella.core.platform.sirius.ui.navigator.showInDiagramCommand");
    }

    public void run() {
        IStatus status = this.runWithStatus();
        if (!status.isOK()) {
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)Messages.ShowInDiagramAction_UnknownElement_Title, (String)status.getMessage());
        }
    }

    public IStatus runWithStatus() {
        List selectedElements = this.getStructuredSelection().toList();
        Collection semanticElements = CapellaAdapterHelper.resolveBusinessObjects((Collection)selectedElements);
        IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        Set<DDiagramElement> viewsFromEditor = this.getViewsFromEditor(activeEditor, semanticElements);
        if (viewsFromEditor.isEmpty()) {
            return new Status(1, "org.polarsys.capella.core.platform.sirius.ui.navigator", Messages.ShowInDiagramAction_UnknownElement_Message);
        }
        List availableElements = viewsFromEditor.stream().filter(this.isElementAvailable()).collect(Collectors.toList());
        if (availableElements.isEmpty()) {
            DDiagramElement diagramElement = viewsFromEditor.iterator().next();
            String message = this.getUnavailableElementMessage(diagramElement);
            return new Status(1, "org.polarsys.capella.core.platform.sirius.ui.navigator", message);
        }
        if (activeEditor instanceof DialectEditor) {
            DialectUIManager.INSTANCE.selectAndReveal((DialectEditor)activeEditor, new ArrayList(availableElements));
        }
        return Status.OK_STATUS;
    }

    protected Set<DDiagramElement> getViewsFromEditor(IEditorPart activeEditor, Collection<EObject> semanticElements) {
        HashSet<DDiagramElement> allViewElements = new HashSet<DDiagramElement>();
        if (activeEditor instanceof SiriusDiagramEditor) {
            SiriusDiagramEditor diagramEditor = (SiriusDiagramEditor)activeEditor;
            DRepresentation diagram = (DRepresentation)diagramEditor.getDiagram().getElement();
            for (EObject semanticElement : semanticElements) {
                Collection<Object> currentViewElements = Collections.emptyList();
                if (semanticElement instanceof Component) {
                    currentViewElements = ((Collection)ModelCache.getCache(ComponentExt::getRepresentingParts, (Object)((Component)semanticElement))).stream().flatMap(part -> this.getDDiagramElements(diagram, (EObject)part)).collect(Collectors.toList());
                }
                if (currentViewElements.isEmpty()) {
                    currentViewElements = this.getDDiagramElements(diagram, semanticElement).collect(Collectors.toList());
                }
                allViewElements.addAll(currentViewElements);
            }
        }
        return allViewElements;
    }

    private Stream<DDiagramElement> getDDiagramElements(DRepresentation diagram, EObject semantic) {
        return DiagramServices.getDiagramServices().getDiagramElements(diagram, semantic).stream().filter(DDiagramElement.class::isInstance).map(DDiagramElement.class::cast);
    }

    protected Predicate<DDiagramElement> isElementAvailable() {
        return element -> {
            DDiagramElementQuery query = new DDiagramElementQuery(element);
            return !query.isFolded() && !query.isHidden() && !query.isCollapsed() && !query.isFiltered();
        };
    }

    protected String getUnavailableElementMessage(DDiagramElement element) {
        String message = Messages.ShowInDiagramAction_UnknownElement_Message;
        DDiagramElementQuery query = new DDiagramElementQuery(element);
        if (query.isFolded()) {
            message = Messages.ShowInDiagramAction_FoldedElement_Message;
        } else if (query.isHidden()) {
            message = Messages.ShowInDiagramAction_HiddenElement_Message;
        } else if (query.isCollapsed()) {
            message = Messages.ShowInDiagramAction_CollapseElement_Message;
        } else if (query.isFiltered()) {
            message = Messages.ShowInDiagramAction_FilteredElement_Message;
        }
        return message;
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        boolean result = false;
        if (!selection.isEmpty()) {
            result = CapellaResourceHelper.isSemanticElements((Collection)selection.toList());
        }
        IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        return result &= activeEditor instanceof SiriusDiagramEditor;
    }

    public void init(IViewPart view) {
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selectionChanged((IStructuredSelection)selection);
    }
}

