/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.tools.report.appenders.reportlogview.handler;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.IMarkerSource;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.MarkerView;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.MarkerViewHelper;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.MarkerViewPlugin;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.handler.AbstractViewHandler;

public class DeleteConstraintMarkersHandler
extends AbstractViewHandler {
    public static final String COMMAND_ID = "org.polarsys.capella.common.tools.report.appenders.reportlogview.logview.deleteconstraintmarkers";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IConstraintDescriptor descriptor = this.getConstraintDescriptor(HandlerUtil.getCurrentSelection((ExecutionEvent)event));
        if (descriptor != null) {
            ArrayList<IMarker> delete = new ArrayList<IMarker>();
            MarkerView view = this.getView(event);
            List<IMarkerSource> sources = view.getMarkerSources();
            for (IMarkerSource source : sources) {
                for (IMarker m : source.getMarkers()) {
                    if (MarkerViewHelper.getConstraintDescriptor(m) != descriptor) continue;
                    delete.add(m);
                }
            }
            for (IMarker m : delete) {
                try {
                    m.delete();
                }
                catch (CoreException e) {
                    MarkerViewPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.capella.common.tools.report.appenders.reportlogview", e.getMessage(), (Throwable)e));
                }
            }
        }
        return null;
    }

    public boolean isEnabled() {
        IWorkbenchPage page;
        IWorkbenchWindow windows;
        boolean result = false;
        ISelection selection = null;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && (windows = workbench.getActiveWorkbenchWindow()) != null && (page = windows.getActivePage()) != null) {
            selection = page.getSelection();
        }
        if (this.getConstraintDescriptor(selection) != null) {
            result = true;
        }
        return result;
    }

    private IConstraintDescriptor getConstraintDescriptor(ISelection selection) {
        IStructuredSelection ssel;
        Object first;
        IConstraintDescriptor descriptor = null;
        if (selection instanceof IStructuredSelection && (first = (ssel = (IStructuredSelection)selection).getFirstElement()) != null && first instanceof IMarker) {
            IMarker marker = (IMarker)first;
            descriptor = MarkerViewHelper.getConstraintDescriptor(marker);
        }
        return descriptor;
    }
}

