/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.services;

import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ShowInContext;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.common.ui.services.ISelectorInPackageExplorer;
import org.polarsys.capella.core.data.capellacommon.AbstractCapabilityPkg;
import org.polarsys.capella.core.data.capellacommon.CapellacommonPackage;

public class SiriusSelectorInPackageExplorer
implements ISelectorInPackageExplorer {
    private Logger logger = ReportManagerRegistry.getInstance().subscribe("User Interface");

    public void selectInPackageExplorer(EObject element) {
        AbstractCapabilityPkg aspectPkg;
        if (element == null) {
            return;
        }
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (EcoreUtil2.isContainedBy((EObject)element, (EClass)CapellacommonPackage.Literals.ABSTRACT_CAPABILITY_PKG) && (aspectPkg = (AbstractCapabilityPkg)EcoreUtil2.getFirstContainer((EObject)element, (EClass)CapellacommonPackage.Literals.ABSTRACT_CAPABILITY_PKG)) != null) {
            SelectionRunnable selectionRunnable = new SelectionRunnable(aspectPkg.eContainer());
            display.asyncExec((Runnable)selectionRunnable);
        }
        SelectionRunnable selectionRunnable = new SelectionRunnable(element);
        display.asyncExec((Runnable)selectionRunnable);
    }

    public class SelectionRunnable
    implements Runnable {
        private EObject element;

        public SelectionRunnable(EObject element) {
            this.element = element;
        }

        @Override
        public void run() {
            if (this.element == null) {
                return;
            }
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window == null) {
                return;
            }
            IWorkbenchPage page = window.getActivePage();
            if (page == null) {
                return;
            }
            try {
                String viewId = "capella.project.explorer";
                IViewPart viewPart = page.showView(viewId);
                if (viewPart != null) {
                    StructuredSelection selection = new StructuredSelection((Object)this.element);
                    IShowInTarget showInTarget = (IShowInTarget)viewPart.getAdapter(IShowInTarget.class);
                    if (showInTarget != null) {
                        showInTarget.show(new ShowInContext(null, (ISelection)selection));
                    }
                }
            }
            catch (PartInitException pie) {
                SiriusSelectorInPackageExplorer.this.logger.debug((Object)new EmbeddedMessage(pie.getMessage(), "User Interface"));
            }
        }
    }
}

