/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.system.rules.cs;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.InformationsExchanger;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.capellacore.Generalization;
import org.polarsys.capella.core.data.capellacore.InvolvedElement;
import org.polarsys.capella.core.data.capellacore.Involvement;
import org.polarsys.capella.core.data.capellacore.InvolverElement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalPath;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.ctx.SystemComponent;
import org.polarsys.capella.core.data.ctx.SystemComponentPkg;
import org.polarsys.capella.core.data.epbs.ConfigurationItem;
import org.polarsys.capella.core.data.epbs.EpbsPackage;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.la.LogicalComponentPkg;
import org.polarsys.capella.core.data.oa.ActivityAllocation;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.data.oa.EntityPkg;
import org.polarsys.capella.core.data.oa.OaPackage;
import org.polarsys.capella.core.data.oa.Role;
import org.polarsys.capella.core.data.oa.RoleAllocation;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentNature;
import org.polarsys.capella.core.data.pa.PhysicalComponentPkg;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.transition.common.handlers.contextscope.ContextScopeHandlerHelper;
import org.polarsys.capella.core.transition.common.handlers.contextscope.IContextScopeHandler;
import org.polarsys.capella.core.transition.common.handlers.transformation.TransformationHandlerHelper;
import org.polarsys.capella.core.transition.system.rules.AbstractCapellaElementRule;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class ComponentRule
extends AbstractCapellaElementRule {
    public ComponentRule() {
        this.registerUpdatedAttribute(CsPackage.Literals.COMPONENT__ACTOR);
        this.registerUpdatedAttribute(CsPackage.Literals.COMPONENT__HUMAN);
        this.registerUpdatedAttribute(PaPackage.Literals.PHYSICAL_COMPONENT__KIND);
        this.registerUpdatedAttribute(PaPackage.Literals.PHYSICAL_COMPONENT__NATURE);
        this.registerUpdatedAttribute(CapellacorePackage.Literals.GENERALIZABLE_ELEMENT__ABSTRACT);
    }

    protected boolean transformAsRootComponent(EObject object, IContext context) {
        return BlockArchitectureExt.isRootComponent((Component)((Component)object));
    }

    @Override
    protected EObject transformDirectElement(EObject element, IContext context) {
        if (this.transformAsRootComponent(element, context)) {
            EObject root = TransformationHandlerHelper.getInstance((IContext)context).getLevelElement(element, context);
            BlockArchitecture target = (BlockArchitecture)TransformationHandlerHelper.getInstance((IContext)context).getBestTracedElement(root, context, CsPackage.Literals.BLOCK_ARCHITECTURE);
            return BlockArchitectureExt.getOrCreateSystem((BlockArchitecture)target);
        }
        return super.transformDirectElement(element, context);
    }

    @Override
    protected void updateElement(EObject logicalElement, EObject physicalElement, IContext context) {
        super.updateElement(logicalElement, physicalElement, context);
        if (logicalElement instanceof LogicalComponent && physicalElement instanceof PhysicalComponent) {
            LogicalComponent logicalComponent = (LogicalComponent)logicalElement;
            PhysicalComponent physicalComponent = (PhysicalComponent)physicalElement;
            if (!BlockArchitectureExt.isRootComponent((Component)physicalComponent)) {
                PhysicalComponentNature nature = this.getComputedNature(context, logicalComponent);
                physicalComponent.setNature(nature);
            }
        }
    }

    protected EObject getDefaultContainer(EObject element, EObject result, IContext context) {
        EObject root = TransformationHandlerHelper.getInstance((IContext)context).getLevelElement(element, context);
        BlockArchitecture target = (BlockArchitecture)TransformationHandlerHelper.getInstance((IContext)context).getBestTracedElement(root, context, CsPackage.Literals.BLOCK_ARCHITECTURE, element, result);
        if (result instanceof Entity || ComponentExt.isActor((EObject)result)) {
            return BlockArchitectureExt.getComponentPkg((BlockArchitecture)target, (boolean)true);
        }
        return BlockArchitectureExt.getOrCreateSystem((BlockArchitecture)target);
    }

    @Override
    protected EClass getSourceType() {
        return CsPackage.Literals.COMPONENT;
    }

    @Override
    protected void retrieveGoDeep(EObject source, List<EObject> result, IContext context) {
        super.retrieveGoDeep(source, result, context);
        this.retrieveComponentGoDeep(source, result, context);
    }

    protected void retrieveComponentGoDeep(EObject source, List<EObject> result, IContext context) {
        Component element = (Component)source;
        IContextScopeHandler handler = ContextScopeHandlerHelper.getInstance((IContext)context);
        if (handler.contains("SOURCE_SCOPE", (EObject)element, context)) {
            this.retrieveComponentAllocations(source, result, context);
            this.retrieveRepresentingPartitions(source, result, context);
            result.addAll((Collection<EObject>)element.getUsedInterfaceLinks());
            result.addAll((Collection<EObject>)element.getImplementedInterfaceLinks());
            handler.addAll("SOURCE_SCOPE", (Collection)element.getRepresentingParts(), context);
            handler.addAll("SOURCE_SCOPE", (Collection)element.getUsedInterfaceLinks(), context);
            handler.addAll("SOURCE_SCOPE", (Collection)element.getImplementedInterfaceLinks(), context);
            if (element instanceof InformationsExchanger) {
                InformationsExchanger info = (InformationsExchanger)element;
                result.addAll((Collection<EObject>)info.getInformationFlows());
                handler.addAll("SOURCE_SCOPE", (Collection)info.getInformationFlows(), context);
            }
            result.addAll(ComponentExt.getOwnedComponentPort((Component)element));
            handler.addAll("SOURCE_SCOPE", (Collection)ComponentExt.getOwnedComponentPort((Component)element), context);
            result.addAll(ComponentExt.getOwnedPhysicalPort((Component)element));
            handler.addAll("SOURCE_SCOPE", (Collection)ComponentExt.getOwnedPhysicalPort((Component)element), context);
            for (Generalization generalization : element.getSuperGeneralizations()) {
                result.add((EObject)generalization);
            }
        }
        if (element instanceof InvolvedElement) {
            for (Involvement involvement : ((InvolvedElement)element).getInvolvingInvolvements()) {
                InvolverElement invo = involvement.getInvolver();
                if (invo == null || !(invo instanceof AbstractCapability) && !(invo instanceof PhysicalPath)) continue;
                result.add((EObject)involvement);
            }
        }
    }

    protected void retrieveRepresentingPartitions(EObject source, List<EObject> result, IContext context) {
        Component element = (Component)source;
        result.addAll((Collection<EObject>)element.getRepresentingParts());
    }

    protected void retrieveComponentAllocations(EObject source, List<EObject> result, IContext context) {
        Component element = (Component)source;
        IContextScopeHandler handler = ContextScopeHandlerHelper.getInstance((IContext)context);
        result.addAll((Collection<EObject>)element.getFunctionalAllocations());
        if (handler.contains("SOURCE_SCOPE", (EObject)element, context)) {
            handler.addAll("SOURCE_SCOPE", (Collection)element.getFunctionalAllocations(), context);
        }
        if (element instanceof Entity) {
            for (RoleAllocation ra : ((Entity)element).getRoleAllocations()) {
                Role role = ra.getRole();
                for (ActivityAllocation aa : role.getActivityAllocations()) {
                    result.add((EObject)aa);
                    if (!handler.contains("SOURCE_SCOPE", (EObject)element, context)) continue;
                    handler.add("SOURCE_SCOPE", (EObject)aa, context);
                }
            }
        }
    }

    protected EStructuralFeature getTargetContainementFeature(EObject element, EObject result, EObject container, IContext context) {
        EClass targetType = this.getTargetType(element, context);
        if (container instanceof EntityPkg) {
            if (OaPackage.Literals.ENTITY.isSuperTypeOf(targetType)) {
                return OaPackage.Literals.ENTITY_PKG__OWNED_ENTITIES;
            }
            if (OaPackage.Literals.ENTITY_PKG.isSuperTypeOf(targetType)) {
                return OaPackage.Literals.ENTITY_PKG__OWNED_ENTITY_PKGS;
            }
        } else if (container instanceof Entity) {
            if (OaPackage.Literals.ENTITY.isSuperTypeOf(targetType)) {
                return OaPackage.Literals.ENTITY__OWNED_ENTITIES;
            }
        } else if (container instanceof SystemAnalysis) {
            if (CtxPackage.Literals.SYSTEM_COMPONENT_PKG.isSuperTypeOf(targetType)) {
                return CtxPackage.Literals.SYSTEM_ANALYSIS__OWNED_SYSTEM_COMPONENT_PKG;
            }
        } else if (container instanceof SystemComponentPkg) {
            if (CtxPackage.Literals.SYSTEM_COMPONENT.isSuperTypeOf(targetType)) {
                return CtxPackage.Literals.SYSTEM_COMPONENT_PKG__OWNED_SYSTEM_COMPONENTS;
            }
            if (CtxPackage.Literals.SYSTEM_COMPONENT_PKG.isSuperTypeOf(targetType)) {
                return CtxPackage.Literals.SYSTEM_COMPONENT_PKG__OWNED_SYSTEM_COMPONENT_PKGS;
            }
        } else if (container instanceof SystemComponent) {
            if (CtxPackage.Literals.SYSTEM_COMPONENT.isSuperTypeOf(targetType)) {
                return CtxPackage.Literals.SYSTEM_COMPONENT__OWNED_SYSTEM_COMPONENTS;
            }
            if (CtxPackage.Literals.SYSTEM_COMPONENT_PKG.isSuperTypeOf(targetType)) {
                return CtxPackage.Literals.SYSTEM_COMPONENT__OWNED_SYSTEM_COMPONENT_PKGS;
            }
        } else if (container instanceof LogicalArchitecture) {
            if (LaPackage.Literals.LOGICAL_COMPONENT_PKG.isSuperTypeOf(targetType)) {
                return LaPackage.Literals.LOGICAL_ARCHITECTURE__OWNED_LOGICAL_COMPONENT_PKG;
            }
        } else if (container instanceof LogicalComponentPkg) {
            if (LaPackage.Literals.LOGICAL_COMPONENT.isSuperTypeOf(targetType)) {
                return LaPackage.Literals.LOGICAL_COMPONENT_PKG__OWNED_LOGICAL_COMPONENTS;
            }
            if (LaPackage.Literals.LOGICAL_COMPONENT_PKG.isSuperTypeOf(targetType)) {
                return LaPackage.Literals.LOGICAL_COMPONENT_PKG__OWNED_LOGICAL_COMPONENT_PKGS;
            }
        } else if (container instanceof LogicalComponent) {
            if (LaPackage.Literals.LOGICAL_COMPONENT.isSuperTypeOf(targetType)) {
                return LaPackage.Literals.LOGICAL_COMPONENT__OWNED_LOGICAL_COMPONENTS;
            }
            if (LaPackage.Literals.LOGICAL_COMPONENT_PKG.isSuperTypeOf(targetType)) {
                return LaPackage.Literals.LOGICAL_COMPONENT__OWNED_LOGICAL_COMPONENT_PKGS;
            }
        } else if (container instanceof PhysicalArchitecture) {
            if (PaPackage.Literals.PHYSICAL_COMPONENT_PKG.isSuperTypeOf(targetType)) {
                return PaPackage.Literals.PHYSICAL_ARCHITECTURE__OWNED_PHYSICAL_COMPONENT_PKG;
            }
        } else if (container instanceof PhysicalComponentPkg) {
            if (PaPackage.Literals.PHYSICAL_COMPONENT.isSuperTypeOf(targetType)) {
                return PaPackage.Literals.PHYSICAL_COMPONENT_PKG__OWNED_PHYSICAL_COMPONENTS;
            }
            if (PaPackage.Literals.PHYSICAL_COMPONENT_PKG.isSuperTypeOf(targetType)) {
                return PaPackage.Literals.PHYSICAL_COMPONENT_PKG__OWNED_PHYSICAL_COMPONENT_PKGS;
            }
        } else if (container instanceof PhysicalComponent) {
            if (PaPackage.Literals.PHYSICAL_COMPONENT.isSuperTypeOf(targetType)) {
                return PaPackage.Literals.PHYSICAL_COMPONENT__OWNED_PHYSICAL_COMPONENTS;
            }
            if (PaPackage.Literals.PHYSICAL_COMPONENT_PKG.isSuperTypeOf(targetType)) {
                return PaPackage.Literals.PHYSICAL_COMPONENT__OWNED_PHYSICAL_COMPONENT_PKGS;
            }
        } else {
            if (container instanceof Part) {
                return CsPackage.Literals.PART__OWNED_ABSTRACT_TYPE;
            }
            if (container instanceof ConfigurationItem && EpbsPackage.Literals.CONFIGURATION_ITEM.isSuperTypeOf(targetType)) {
                return EpbsPackage.Literals.CONFIGURATION_ITEM__OWNED_CONFIGURATION_ITEMS;
            }
        }
        return element.eContainingFeature();
    }

    PhysicalComponentNature getComputedNature(IContext context, LogicalComponent logicalComponent) {
        Map<LogicalComponent, PhysicalComponentNature> natureMap = this.getNatureMap(context);
        PhysicalComponentNature nature = natureMap.get(logicalComponent);
        if (nature == null) {
            Collection subComponents = ComponentExt.getAllSubUsedComponents((Component)logicalComponent);
            subComponents.add(logicalComponent);
            nature = this.computeNature(subComponents);
            this.cacheNature(natureMap, subComponents, nature);
        }
        return nature;
    }

    private Map<LogicalComponent, PhysicalComponentNature> getNatureMap(IContext context) {
        HashMap natureMap = (HashMap)context.get((Object)"LC_TO_PC_COMPUTED_NATURE");
        if (natureMap == null) {
            natureMap = new HashMap();
            context.put((Object)"LC_TO_PC_COMPUTED_NATURE", natureMap);
        }
        return natureMap;
    }

    private PhysicalComponentNature computeNature(Collection<Component> subComponents) {
        boolean allSubComponentsActors = subComponents.stream().allMatch(Component::isActor);
        return allSubComponentsActors ? PhysicalComponentNature.NODE : PhysicalComponentNature.BEHAVIOR;
    }

    private void cacheNature(Map<LogicalComponent, PhysicalComponentNature> natureMap, Collection<Component> components, PhysicalComponentNature nature) {
        components.stream().filter(LogicalComponent.class::isInstance).map(LogicalComponent.class::cast).forEach(component -> {
            PhysicalComponentNature physicalComponentNature2 = natureMap.put((LogicalComponent)component, nature);
        });
    }
}

