/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.polarsys.capella.common.queries.interpretor.QueryInterpretor;
import org.polarsys.capella.core.data.capellacore.AbstractDependenciesPkg;
import org.polarsys.capella.core.data.capellacore.Generalization;
import org.polarsys.capella.core.data.information.datatype.BooleanType;
import org.polarsys.capella.core.data.information.datatype.DataType;
import org.polarsys.capella.core.data.information.datatype.DatatypePackage;
import org.polarsys.capella.core.data.information.datatype.Enumeration;
import org.polarsys.capella.core.data.information.datatype.NumericType;
import org.polarsys.capella.core.data.information.datatype.PhysicalQuantity;
import org.polarsys.capella.core.data.information.datatype.StringType;
import org.polarsys.capella.core.data.information.datavalue.DataValue;
import org.polarsys.capella.core.data.information.datavalue.DatavaluePackage;
import org.polarsys.capella.core.model.helpers.AbstractDependenciesPkgExt;
import org.polarsys.capella.core.model.helpers.DataValueExt;
import org.polarsys.capella.core.model.helpers.queries.QueryIdentifierConstants;

public class DataTypeExt {
    public static Collection<DataType> getAllDataTypes(EObject context) {
        return QueryInterpretor.executeQuery((String)QueryIdentifierConstants.GET_ALL_DATA_TYPES, (Object)context);
    }

    public static Map<AbstractDependenciesPkg, Collection<EObject>> getDataTypeDependencies2(DataType dataType) {
        HashMap<AbstractDependenciesPkg, Collection<EObject>> result = new HashMap<AbstractDependenciesPkg, Collection<EObject>>();
        for (Generalization aGeneralization : dataType.getSuperGeneralizations()) {
            AbstractDependenciesPkgExt.checkDependenciesAndAddToResult(result, (EObject)aGeneralization.getSuper());
        }
        return result;
    }

    public static Collection<AbstractDependenciesPkg> getDataTypeDependencies(DataType dataType) {
        return DataTypeExt.getDataTypeDependencies2(dataType).keySet();
    }

    public static List<DataValue> getAllDataValuesFromDataType(DataType currentDataType) {
        ArrayList<DataValue> result = new ArrayList<DataValue>(1);
        HashMap<EObject, List<EReference>> mapOfDataTypeWithFeatures = new HashMap<EObject, List<EReference>>();
        ArrayList<EReference> referenceElement = new ArrayList<EReference>(1);
        referenceElement.add(DatavaluePackage.Literals.DATA_VALUE_CONTAINER__OWNED_DATA_VALUES);
        if (currentDataType instanceof BooleanType) {
            referenceElement.add(DatatypePackage.Literals.BOOLEAN_TYPE__OWNED_DEFAULT_VALUE);
            referenceElement.add(DatatypePackage.Literals.BOOLEAN_TYPE__OWNED_LITERALS);
        } else if (currentDataType instanceof Enumeration) {
            referenceElement.add(DatatypePackage.Literals.ENUMERATION__OWNED_LITERALS);
            referenceElement.add(DatatypePackage.Literals.ENUMERATION__OWNED_DEFAULT_VALUE);
            referenceElement.add(DatatypePackage.Literals.ENUMERATION__OWNED_NULL_VALUE);
            referenceElement.add(DatatypePackage.Literals.ENUMERATION__OWNED_MIN_VALUE);
            referenceElement.add(DatatypePackage.Literals.ENUMERATION__OWNED_MAX_VALUE);
        } else if (currentDataType instanceof NumericType || currentDataType instanceof PhysicalQuantity) {
            referenceElement.add(DatatypePackage.Literals.NUMERIC_TYPE__OWNED_DEFAULT_VALUE);
            referenceElement.add(DatatypePackage.Literals.NUMERIC_TYPE__OWNED_NULL_VALUE);
            referenceElement.add(DatatypePackage.Literals.NUMERIC_TYPE__OWNED_MIN_VALUE);
            referenceElement.add(DatatypePackage.Literals.NUMERIC_TYPE__OWNED_MAX_VALUE);
        } else if (currentDataType instanceof StringType) {
            referenceElement.add(DatatypePackage.Literals.STRING_TYPE__OWNED_DEFAULT_VALUE);
            referenceElement.add(DatatypePackage.Literals.STRING_TYPE__OWNED_NULL_VALUE);
            referenceElement.add(DatatypePackage.Literals.STRING_TYPE__OWNED_MIN_LENGTH);
            referenceElement.add(DatatypePackage.Literals.STRING_TYPE__OWNED_MAX_LENGTH);
        }
        mapOfDataTypeWithFeatures.put((EObject)currentDataType, (List<EReference>)referenceElement);
        result.addAll(DataValueExt.getDataValuesFromMapOfEObjectAndEReferences(mapOfDataTypeWithFeatures));
        return result;
    }
}

