/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.toolkit.decomposition;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class OverlayedImageDescriptor
extends CompositeImageDescriptor {
    public static final int TOP_LEFT = 0;
    public static final int TOP_RIGHT = 1;
    public static final int BOTTOM_LEFT = 2;
    public static final int BOTTOM_RIGHT = 3;
    public static final int DEFAULT_POSITION = 3;
    private Image _baseImage;
    private Image _overlayImage;
    private int _overlayImagePosition;
    private Point _sizeOfImage;

    public OverlayedImageDescriptor(Image baseImage, Image overlayImage) {
        this(baseImage, overlayImage, false, false);
    }

    public OverlayedImageDescriptor(Image baseImage, Image overlayImage, boolean isUp, boolean isRight) {
        this._baseImage = baseImage;
        this._overlayImage = overlayImage;
        this._overlayImagePosition = this.getPosition(isUp, isRight);
        this._sizeOfImage = new Point(baseImage.getBounds().width + overlayImage.getBounds().width, baseImage.getBounds().height);
    }

    public Image getImage() {
        return this.createImage();
    }

    protected Point getSize() {
        return this._sizeOfImage;
    }

    protected void drawCompositeImage(int arg0, int arg1) {
        this.drawImage(this._baseImage.getImageData(), 0, 0);
        ImageData imageData = this._overlayImage.getImageData();
        int xOverlay = 0;
        int yOverlay = 0;
        switch (this._overlayImagePosition) {
            case 0: {
                xOverlay = 0;
                yOverlay = 0;
                break;
            }
            case 1: {
                xOverlay = this._sizeOfImage.x - imageData.width;
                yOverlay = 0;
                break;
            }
            case 2: {
                xOverlay = 0;
                yOverlay = this._sizeOfImage.y - imageData.height;
                break;
            }
            case 3: {
                xOverlay = this._sizeOfImage.x - imageData.width;
                yOverlay = this._sizeOfImage.y - imageData.height;
                break;
            }
            default: {
                xOverlay = 0;
                yOverlay = this._sizeOfImage.y - imageData.height;
            }
        }
        this.drawImage(imageData, xOverlay, yOverlay);
    }

    private int getPosition(boolean isUp, boolean isRight) {
        int position = 3;
        position = isUp ? (isRight ? 1 : 0) : (isRight ? 3 : 2);
        return position;
    }
}

