/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.core.data.capellacommon.AbstractCapabilityPkg;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentPkg;
import org.polarsys.capella.core.data.ctx.Mission;
import org.polarsys.capella.core.data.ctx.MissionPkg;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.helpers.ctx.services.CapabilityPkgExt;
import org.polarsys.capella.core.data.helpers.ctx.services.MissionPkgExt;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.ComponentPkgExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.core.sirius.analysis.CsServices;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.core.sirius.analysis.InformationServices;
import org.polarsys.capella.core.sirius.analysis.OAServices;
import org.polarsys.capella.core.sirius.analysis.showhide.AbstractShowHide;

public class ContextServices {
    private static ContextServices singleton = null;

    public static ContextServices getServices() {
        if (singleton == null) {
            singleton = new ContextServices();
        }
        return singleton;
    }

    public List<EObject> getCCCapabilities(DSemanticDecorator current) {
        return this.getMBCapabilities(current);
    }

    public List<EObject> getCMCapabilities(DSemanticDecorator current) {
        return this.getMBCapabilities(current);
    }

    public List<EObject> getCRBCapabilities(DSemanticDecorator diagram) {
        return this.getMBCapabilities(diagram);
    }

    public List<EObject> getCRIActors(DSemanticDecorator diagram) {
        return this.getMCBActors(diagram);
    }

    public List<EObject> getCRICapabilityRealizations(DSemanticDecorator diagram) {
        return this.getMBCapabilities(diagram);
    }

    public List<EObject> getCRIComponents(DSemanticDecorator diagram) {
        EObject target = diagram.getTarget();
        Component rootComponent = BlockArchitectureExt.getRootBlockArchitecture((EObject)target).getSystem();
        ArrayList<EObject> result = new ArrayList<EObject>();
        if (rootComponent != null) {
            Collection subComponents = ComponentExt.getAllSubUsedComponents((Component)rootComponent);
            result.addAll(subComponents);
        }
        return result;
    }

    public List<EObject> getMBCapabilities(DSemanticDecorator current) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        EObject target = current.getTarget();
        AbstractCapabilityPkg abstractCapabilityPkg = BlockArchitectureExt.getAbstractCapabilityPkg((BlockArchitecture)BlockArchitectureExt.getRootBlockArchitecture((EObject)target));
        result.addAll(CapabilityPkgExt.getAllAbstractCapabilities((AbstractCapabilityPkg)abstractCapabilityPkg));
        return result;
    }

    public List<EObject> getOCBCapabilities(DSemanticDecorator diagram) {
        return this.getMBCapabilities(diagram);
    }

    public List<EObject> getMCBCapabilities(DSemanticDecorator current) {
        return this.getMBCapabilities(current);
    }

    @Deprecated
    public EObject showHideMCBActors2(DSemanticDecorator view, List<EObject> selectedElements, List<EObject> visibleElements, List<DDiagramElement> visibleElementViews, AbstractShowHide showHideHandler) {
        AbstractShowHide.DiagramContext diagramContext = showHideHandler.new AbstractShowHide.DiagramContext();
        for (EObject actor : selectedElements) {
            showHideHandler.show(actor, diagramContext);
        }
        HashSet<EObject> toBeRemoved = new HashSet<EObject>();
        for (DDiagramElement node : visibleElementViews) {
            if (selectedElements.contains(node.getTarget())) continue;
            toBeRemoved.add(node.getTarget());
        }
        for (EObject aView : toBeRemoved) {
            showHideHandler.hide(aView, diagramContext);
        }
        return view;
    }

    public List<EObject> getCCMissions(DSemanticDecorator current) {
        return this.getMCBMissions(current);
    }

    public List<EObject> getMCBMissions(DSemanticDecorator current) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        EObject target = current.getTarget();
        SystemEngineering sysEng = SystemEngineeringExt.getSystemEngineering((CapellaElement)((CapellaElement)target));
        SystemAnalysis sysAnalysis = SystemEngineeringExt.getOwnedSystemAnalysis((SystemEngineering)sysEng);
        result.addAll(MissionPkgExt.getAllMissions((MissionPkg)sysAnalysis.getOwnedMissionPkg()));
        return result;
    }

    public List<EObject> getMBMissions(DSemanticDecorator diagram) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        EObject target = diagram.getTarget();
        if (diagram instanceof DDiagram && target instanceof MissionPkg) {
            result.addAll(MissionPkgExt.getAllMissions((MissionPkg)((MissionPkg)target)));
        }
        return result;
    }

    public List<EObject> getCMActors(DSemanticDecorator diagram) {
        return this.getMCBActors(diagram);
    }

    public List<EObject> getCCActors(DSemanticDecorator diagram) {
        return this.getMCBActors(diagram);
    }

    public List<EObject> getMCBActors(DSemanticDecorator current) {
        EObject target = current.getTarget();
        ComponentPkg componentPkg = BlockArchitectureExt.getComponentPkg((BlockArchitecture)BlockArchitectureExt.getRootBlockArchitecture((EObject)target), (boolean)false);
        return ComponentPkgExt.getAllActors((ComponentPkg)componentPkg).stream().filter(c -> !c.getRepresentingParts().isEmpty()).collect(Collectors.toList());
    }

    public List<EObject> getMCBComponents(DSemanticDecorator current) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        EObject target = current.getTarget();
        ComponentPkg componentPkg = BlockArchitectureExt.getComponentPkg((BlockArchitecture)BlockArchitectureExt.getRootBlockArchitecture((EObject)target), (boolean)false);
        result.addAll(ComponentPkgExt.getSubDefinedComponents((ComponentPkg)componentPkg).stream().filter(c -> !ComponentExt.isActor((Component)c)).collect(Collectors.toList()));
        return result;
    }

    public List<EObject> getCRBActors(DSemanticDecorator diagram) {
        return this.getMCBActors(diagram);
    }

    public List<EObject> getMBActors(DSemanticDecorator diagram) {
        return this.getMCBActors(diagram);
    }

    public List<EObject> getCOCActors(DSemanticDecorator view) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        Collection<? extends Component> availableEntitiesToInsert = OAServices.getService().getOEBEntities(view);
        for (Component component : availableEntitiesToInsert) {
            if (!ComponentExt.isActor((Component)component)) continue;
            result.add((EObject)component);
        }
        return result;
    }

    public List<EObject> getCOCEntities(DSemanticDecorator view) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        Collection<? extends Component> allComponents = OAServices.getService().getAvailableEntitiesToInsert(view);
        for (Component component : allComponents) {
            if (!(component instanceof Entity) || ComponentExt.isActor((Component)component)) continue;
            result.add((EObject)component);
        }
        return result;
    }

    public List<EObject> getCOCCapabilities(DSemanticDecorator diagram) {
        return this.getOCBCapabilities(diagram);
    }

    public List<EObject> getOCBActors(DSemanticDecorator view) {
        return this.getCOCActors(view);
    }

    public List<EObject> getOCBEntities(DSemanticDecorator view) {
        return this.getCOCEntities(view);
    }

    public Collection<Component> getCRBComponents(DSemanticDecorator decorator) {
        Collection<Object> components = Collections.emptyList();
        if (decorator.getTarget() instanceof Component) {
            components = CsServices.getService().getCCIIShowHideComponent(decorator);
        } else {
            Component firstComponent;
            EObject parentContainer = CsServices.getService().getParentContainer(decorator.getTarget());
            if (parentContainer instanceof Component) {
                components = CsServices.getService().getSubComponents(parentContainer);
            } else if (parentContainer instanceof BlockArchitecture && (firstComponent = ((BlockArchitecture)parentContainer).getSystem()) != null) {
                components = CsServices.getService().getSubComponents((EObject)firstComponent);
            }
        }
        return components.stream().filter(c -> !c.getRepresentingParts().isEmpty()).collect(Collectors.toList());
    }

    public Collection<EObject> getMBCapabilityInvolvementSemanticCandidates(DDiagram diagram) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (DDiagramElement dNode : DiagramServices.getDiagramServices().getAllAbstractNodes((EObject)diagram, false)) {
            EObject target = dNode.getTarget();
            if (!(target instanceof AbstractCapability)) continue;
            result.addAll((Collection<EObject>)((AbstractCapability)target).getInvolvedInvolvements());
        }
        return result;
    }

    public Collection<EObject> getMBMissionInvolvementSemanticCandidates(DDiagram diagram) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (DDiagramElement dNode : DiagramServices.getDiagramServices().getAllAbstractNodes((EObject)diagram, false)) {
            EObject target = dNode.getTarget();
            if (!(target instanceof Mission)) continue;
            result.addAll((Collection<EObject>)((Mission)target).getInvolvedInvolvements());
        }
        return result;
    }

    public Collection<EObject> getMBCapabilityIncludeSemanticCandidates(DDiagram diagram) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (DDiagramElement dNode : DiagramServices.getDiagramServices().getAllAbstractNodes((EObject)diagram, false)) {
            EObject target = dNode.getTarget();
            if (!(target instanceof AbstractCapability)) continue;
            result.addAll((Collection<EObject>)((AbstractCapability)target).getIncludes());
        }
        return result;
    }

    public Collection<EObject> getMBCapabilityExtendSemanticCandidates(DDiagram diagram) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (DDiagramElement dNode : DiagramServices.getDiagramServices().getAllAbstractNodes((EObject)diagram, false)) {
            EObject target = dNode.getTarget();
            if (!(target instanceof AbstractCapability)) continue;
            result.addAll((Collection<EObject>)((AbstractCapability)target).getExtends());
        }
        return result;
    }

    public Collection<EObject> getMBGeneralizationSemanticCandidates(DDiagram diagram) {
        Collection<EObject> compGeneralizations = this.getMBActorGeneralizationSemanticCandidates(diagram);
        compGeneralizations.addAll(this.getMBCapabilityGeneralizationSemanticCandidates(diagram));
        return compGeneralizations;
    }

    public Collection<EObject> getMBActorGeneralizationSemanticCandidates(DDiagram diagram) {
        return InformationServices.getService().getCDBGeneralizationSemanticCandidates(diagram);
    }

    public Collection<EObject> getMBCapabilityGeneralizationSemanticCandidates(DDiagram diagram) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (DDiagramElement dNode : DiagramServices.getDiagramServices().getAllAbstractNodes((EObject)diagram, false)) {
            EObject target = dNode.getTarget();
            if (!(target instanceof AbstractCapability)) continue;
            result.addAll((Collection<EObject>)((AbstractCapability)target).getSuperGeneralizations());
        }
        return result;
    }

    public Collection<EObject> getMBCapabilityExploitationSemanticCandidates(DDiagram diagram) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (DDiagramElement dNode : DiagramServices.getDiagramServices().getAllAbstractNodes((EObject)diagram, false)) {
            EObject target = dNode.getTarget();
            if (!(target instanceof Mission)) continue;
            result.addAll((Collection<EObject>)((Mission)target).getOwnedCapabilityExploitations());
        }
        return result;
    }

    public List<AbstractDNode> getDisplayedNodeViews(DSemanticDecorator view, Function<AbstractDNode, Boolean> filterFunc) {
        ArrayList<AbstractDNode> returnedList = new ArrayList<AbstractDNode>();
        if (view instanceof DDiagram) {
            DDiagram diagram = (DDiagram)view;
            for (AbstractDNode node : diagram.getNodes()) {
                if (!filterFunc.apply(node).booleanValue()) continue;
                returnedList.add(node);
            }
        }
        if (view instanceof DNodeContainer) {
            DNodeContainer currentContainer = (DNodeContainer)view;
            for (AbstractDNode node : currentContainer.getNodes()) {
                if (!filterFunc.apply(node).booleanValue()) continue;
                returnedList.add(node);
            }
        }
        return returnedList;
    }

    public List<AbstractDNode> getDisplayedContainerViews(DSemanticDecorator view, Function<AbstractDNode, Boolean> filterFunc) {
        ArrayList<AbstractDNode> returnedList = new ArrayList<AbstractDNode>();
        if (view instanceof DDiagram) {
            DDiagram diagram = (DDiagram)view;
            for (AbstractDNode node : diagram.getContainers()) {
                if (!filterFunc.apply(node).booleanValue()) continue;
                returnedList.add(node);
            }
        }
        if (view instanceof DNodeContainer) {
            DNodeContainer currentContainer = (DNodeContainer)view;
            for (AbstractDNode node : currentContainer.getContainers()) {
                if (!filterFunc.apply(node).booleanValue()) continue;
                returnedList.add(node);
            }
        }
        return returnedList;
    }

    public List<AbstractDNode> getDisplayedActorNodeViews(DSemanticDecorator view) {
        return this.getDisplayedNodeViews(view, new Function<AbstractDNode, Boolean>(){

            @Override
            public Boolean apply(AbstractDNode node) {
                if (node.getTarget() != null && node.getTarget() instanceof Component && ComponentExt.isActor((EObject)node.getTarget())) {
                    return true;
                }
                return false;
            }
        });
    }

    public List<AbstractDNode> getDisplayedActorContainerViews(DSemanticDecorator view) {
        return this.getDisplayedContainerViews(view, new Function<AbstractDNode, Boolean>(){

            @Override
            public Boolean apply(AbstractDNode node) {
                if (node.getTarget() instanceof Component && ComponentExt.isActor((EObject)node.getTarget())) {
                    return true;
                }
                return false;
            }
        });
    }

    public List<EObject> getDisplayedNodeActors(DSemanticDecorator view) {
        return this.getDisplayedActorNodeViews(view).stream().map(v -> v.getTarget()).collect(Collectors.toList());
    }

    public List<EObject> getDisplayedContainerActors(DSemanticDecorator view) {
        return this.getDisplayedActorContainerViews(view).stream().map(v -> v.getTarget()).collect(Collectors.toList());
    }

    public List<AbstractDNode> getDisplayedComponentNodeViews(DSemanticDecorator view) {
        return this.getDisplayedNodeViews(view, new Function<AbstractDNode, Boolean>(){

            @Override
            public Boolean apply(AbstractDNode node) {
                if (node.getTarget() != null && node.getTarget() instanceof Component && !ComponentExt.isActor((EObject)node.getTarget())) {
                    return true;
                }
                return false;
            }
        });
    }

    public List<AbstractDNode> getDisplayedComponentContainerViews(DSemanticDecorator view) {
        return this.getDisplayedContainerViews(view, new Function<AbstractDNode, Boolean>(){

            @Override
            public Boolean apply(AbstractDNode node) {
                if (node.getTarget() != null && node.getTarget() instanceof Component && !ComponentExt.isActor((EObject)node.getTarget())) {
                    return true;
                }
                return false;
            }
        });
    }

    public List<EObject> getDisplayedNodeComponents(DSemanticDecorator view) {
        return this.getDisplayedComponentNodeViews(view).stream().map(v -> v.getTarget()).collect(Collectors.toList());
    }

    public List<EObject> getDisplayedContainerComponents(DSemanticDecorator view) {
        return this.getDisplayedComponentContainerViews(view).stream().map(v -> v.getTarget()).collect(Collectors.toList());
    }
}

