/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.system.topdown.handlers.merge;

import java.util.Collection;
import org.eclipse.emf.diffmerge.diffdata.EElementRelativePresence;
import org.eclipse.emf.diffmerge.generic.api.Role;
import org.eclipse.emf.diffmerge.generic.api.diff.IDifference;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.capellacore.ModellingArchitecture;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.transition.common.handlers.merge.CategoryFilter;
import org.polarsys.capella.core.transition.common.handlers.transformation.TransformationHandlerHelper;
import org.polarsys.capella.core.transition.system.topdown.handlers.merge.Messages;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class OutsideArchitectureCategoryFilter
extends CategoryFilter {
    public OutsideArchitectureCategoryFilter(IContext context) {
        super(context, Messages.OutsideArchitectureCategoryFilter, Messages.OutsideArchitectureCategoryFilter_Description);
        this.setCategorySet("category.business");
        this.setInFocusMode(false);
        this.setVisible(false);
        this.setActive(true);
    }

    public boolean covers(IDifference<EObject> difference) {
        if (difference instanceof EElementRelativePresence) {
            EElementRelativePresence diff = (EElementRelativePresence)difference;
            EObject reference = (EObject)diff.getElementMatch().get(Role.REFERENCE);
            BlockArchitecture blockArch = this.getTargetArchitecture(reference, this.context);
            BlockArchitecture arch = BlockArchitectureExt.getRootBlockArchitecture((EObject)reference);
            if (reference != null) {
                if (arch == null) {
                    return false;
                }
                if (!blockArch.eClass().isInstance((Object)arch)) {
                    return true;
                }
            }
        }
        return false;
    }

    protected BlockArchitecture getTargetArchitecture(EObject source, IContext context) {
        BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)source);
        Collection selection = (Collection)context.get((Object)"TRANSITION_SOURCES");
        if (selection.size() > 0) {
            EObject selected = (EObject)selection.toArray()[0];
            architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)selected);
        }
        EClass clazz = TransformationHandlerHelper.getInstance((IContext)context).getTargetType((EObject)architecture, context);
        SystemEngineering engeneering = OutsideArchitectureCategoryFilter.getSystemEngineering(source);
        if (engeneering != null) {
            for (ModellingArchitecture archi : engeneering.getOwnedArchitectures()) {
                if (clazz == null || !clazz.isInstance((Object)archi)) continue;
                return (BlockArchitecture)archi;
            }
        }
        return architecture;
    }

    public static SystemEngineering getSystemEngineering(EObject currentElement) {
        EObject element = currentElement;
        while (element != null && !(element instanceof SystemEngineering)) {
            element = element.eContainer();
        }
        if (element == null) {
            return null;
        }
        return (SystemEngineering)element;
    }
}

