/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.search;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.core.ui.search.CapellaReplaceQuery;
import org.polarsys.capella.core.ui.search.CapellaReplaceRunnable;
import org.polarsys.capella.core.ui.search.CapellaSearchQuery;

public class CapellaReplaceRunnableWrapper {
    private final CapellaReplaceRunnable capellaReplaceRunnable;

    public CapellaReplaceRunnableWrapper(CapellaReplaceRunnable capellaReplaceRunnable) {
        this.capellaReplaceRunnable = capellaReplaceRunnable;
    }

    public void run() {
        if (this.capellaReplaceRunnable.askForReplacementText()) {
            Shell shell;
            block5: {
                shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                try {
                    new ProgressMonitorDialog(shell).run(true, true, (IRunnableWithProgress)this.capellaReplaceRunnable);
                }
                catch (InterruptedException | InvocationTargetException e) {
                    String message = e.getMessage();
                    if (message == null || message.isEmpty()) break block5;
                    MessageDialog.openError((Shell)shell, (String)"Capella Replace", (String)message);
                }
            }
            CapellaSearchQuery searchQuery = this.capellaReplaceRunnable.getSearchQuery();
            CapellaReplaceQuery replaceQuery = this.capellaReplaceRunnable.getReplaceQuery();
            String replacement = this.capellaReplaceRunnable.getReplacement();
            int replacedOccurrenceCount = replaceQuery.getReplacedOccurrenceCount();
            String searchPattern = searchQuery.getCapellaSearchSettings().getTextPattern();
            int replacedElementCount = replaceQuery.getReplacedElementCount();
            int replacedProjectCount = replaceQuery.getReplacedProjectCount();
            if (replacement != null) {
                String message = String.format("Replaced '%s' by '%s' for: %d occurrence(s) of %d element(s) in %d project(s)", searchPattern, replacement, replacedOccurrenceCount, replacedElementCount, replacedProjectCount);
                MessageDialog.openInformation((Shell)shell, (String)"Capella Replace", (String)message);
            }
            boolean atLeastOneOccurrenceReplaced = replacedOccurrenceCount > 0;
            boolean reSearchRequired = this.capellaReplaceRunnable.isRerunQueryAfterReplacement();
            if (atLeastOneOccurrenceReplaced && reSearchRequired) {
                NewSearchUI.runQueryInBackground((ISearchQuery)searchQuery);
            }
        }
    }
}

