/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.links.helpers.commands;

import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.core.business.queries.IBusinessQuery;
import org.polarsys.capella.core.business.queries.capellacore.BusinessQueriesProvider;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.model.links.helpers.LinkInfo;
import org.polarsys.capella.core.model.links.helpers.commands.AbstractCreateLinksCommand;

public abstract class AbstractQueryBasedCommand
extends AbstractCreateLinksCommand {
    protected final EClass _linkType;
    protected final EReference _linkRefInSource;
    protected CapellaElement _sourceElement;
    protected CapellaElement _targetElement;

    public AbstractQueryBasedCommand(String label, LinkInfo.LinkStyle linkStyle, EClass linkType, EReference linkRefInSource) {
        super(label, linkStyle);
        this._linkType = linkType;
        this._linkRefInSource = linkRefInSource;
    }

    protected boolean prepare() {
        if (this.getSources() == null || this.getTargets() == null || 1 != this.getSources().size() || 1 != this.getTargets().size()) {
            return false;
        }
        this._targetElement = (CapellaElement)this.getTarget();
        this._sourceElement = (CapellaElement)this.getSource();
        IBusinessQuery query = BusinessQueriesProvider.getInstance().getContribution(this._sourceElement.eClass(), (EStructuralFeature)this._linkRefInSource);
        if (query == null) {
            return false;
        }
        List availableElements = query.getAvailableElements((EObject)this._sourceElement);
        List currentElements = query.getCurrentElements((EObject)this._sourceElement, false);
        availableElements.removeAll(currentElements);
        return availableElements.contains(this._targetElement);
    }
}

