/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.choreography;

import java.util.List;
import org.eclipse.bpmn2.ChoreographyActivity;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.modeler.core.features.DefaultResizeBPMNShapeFeature;
import org.eclipse.bpmn2.modeler.core.features.choreography.ChoreographyUtil;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class ResizeChoreographyFeature
extends DefaultResizeBPMNShapeFeature {
    static final int TEXT_H = 15;

    public ResizeChoreographyFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canResizeShape(IResizeShapeContext context) {
        PictogramElement pe = context.getPictogramElement();
        if (pe instanceof ContainerShape && BusinessObjectUtil.getFirstBaseElement((PictogramElement)pe) instanceof ChoreographyActivity) {
            boolean doit;
            List bands = ChoreographyUtil.getParticipantBandBpmnShapes((ContainerShape)((ContainerShape)pe));
            int h = 15;
            for (BPMNShape shape : bands) {
                h = (int)((float)h + shape.getBounds().getHeight());
            }
            boolean bl = context.getHeight() > 0 ? context.getHeight() > h : (doit = true);
            if (doit && !super.canResizeShape(context)) {
                doit = false;
            }
            return doit;
        }
        return false;
    }

    public void resizeShape(IResizeShapeContext context) {
        super.resizeShape(context);
        ChoreographyUtil.updateParticipantBands((IFeatureProvider)this.getFeatureProvider(), (PictogramElement)context.getPictogramElement());
        ChoreographyUtil.updateChoreographyMessageLinks((IFeatureProvider)this.getFeatureProvider(), (PictogramElement)context.getPictogramElement());
    }
}

