/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.util.ColorManager;
import org.eclipse.birt.report.viewer.utilities.WebViewer;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class InputParameterHtmlDialog
extends Dialog {
    private String title;
    public static final String TITLE = Messages.getString((String)"InputParameterDailog.dialog.title");
    private String uri;
    private Browser browser;
    private HashMap options;
    public static final String VIEWER_PARAMETER = "parameter";
    public static final String VIEWER_FRAMESET = "frameset";
    public static final String VIEWER_RUN = "run";
    public static final int RETURN_CODE_BROWSER_CLOSED = 1001;
    public static final String STATUS_CLOSE = "close";
    public static final String STATUS_CANCEL = "cancel";

    public InputParameterHtmlDialog(Shell parent, String title, String uri, Browser target) {
        super(parent);
        this.title = title;
        this.uri = uri;
    }

    protected String stringEscape(String string) {
        return string.replace("&", "&&");
    }

    protected Control createButtonBar(Composite parent) {
        return parent;
    }

    protected Control createDialogArea(Composite parent) {
        parent.setBackground(ColorManager.getColor((int)219, (int)228, (int)238));
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gd = new GridData();
        gd.widthHint = 520;
        gd.heightHint = 395;
        composite.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this.browser = new Browser(composite, 0);
        gd = new GridData(1808);
        gd.horizontalSpan = 1;
        this.browser.setLayoutData((Object)gd);
        this.browser.addCloseWindowListener(new CloseWindowListener(){

            public void close(WindowEvent event) {
                ((Browser)event.widget).getShell().close();
                List parameters = SessionHandleAdapter.getInstance().getReportDesignHandle().getParameters().getContents();
                if (parameters != null && parameters.size() > 0) {
                    InputParameterHtmlDialog.this.setReturnCode(1001);
                }
            }
        });
        this.browser.addStatusTextListener(new StatusTextListener(){

            public void changed(StatusTextEvent event) {
                if (InputParameterHtmlDialog.STATUS_CLOSE.equalsIgnoreCase(event.text)) {
                    ((Browser)event.widget).getShell().close();
                    List parameters = SessionHandleAdapter.getInstance().getReportDesignHandle().getParameters().getContents();
                    if (parameters != null && parameters.size() > 0) {
                        InputParameterHtmlDialog.this.setReturnCode(1001);
                    }
                } else if (InputParameterHtmlDialog.STATUS_CANCEL.equalsIgnoreCase(event.text) && !((Browser)event.widget).getShell().isDisposed()) {
                    ((Browser)event.widget).getShell().close();
                }
            }
        });
        this.browser.addTitleListener(new TitleListener(){

            public void changed(TitleEvent event) {
                if (InputParameterHtmlDialog.STATUS_CANCEL.equalsIgnoreCase(event.title) && !((Browser)event.widget).getShell().isDisposed()) {
                    ((Browser)event.widget).getShell().close();
                }
            }
        });
        this.display();
        return composite;
    }

    public void display() {
        if (this.browser != null && this.uri != null && this.uri.length() > 0) {
            if (this.options == null) {
                this.options = new HashMap();
                this.options.put("SERVLET_NAME_KEY", VIEWER_PARAMETER);
                this.options.put("FORMAT_KEY", "html");
            }
            this.options.put("RESOURCE_FOLDER_KEY", ReportPlugin.getDefault().getResourceFolder());
            WebViewer.display((String)this.uri, (Browser)this.browser, (Map)this.options);
        }
    }

    protected boolean initDialog() {
        return true;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    public void setTitle(String newTitle) {
        this.title = newTitle;
        if (this.getShell() != null) {
            this.getShell().setText(newTitle);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }
}

