/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.ide.explorer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;

public class SetupReportProjectHandler
extends AbstractHandler {
    private List<IProject> validProjects = new ArrayList<IProject>();

    public void setEnabled(Object evaluationContext) {
        IEvaluationContext context;
        Object object;
        this.validProjects.clear();
        if (evaluationContext instanceof IEvaluationContext && (object = (context = (IEvaluationContext)evaluationContext).getVariable("selection")) instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)object;
            for (Object selectedObject : selection.toList()) {
                if (!(selectedObject instanceof IProject)) continue;
                IProject project = (IProject)selectedObject;
                try {
                    if (project.hasNature("org.eclipse.birt.report.designer.ui.reportprojectnature")) continue;
                    this.validProjects.add(project);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        }
        this.setBaseEnabled(!this.validProjects.isEmpty());
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        for (IProject project : this.validProjects) {
            try {
                IProjectDescription description = project.getDescription();
                ArrayList<String> newNatures = new ArrayList<String>(Arrays.asList(description.getNatureIds()));
                newNatures.add("org.eclipse.birt.report.designer.ui.reportprojectnature");
                description.setNatureIds(newNatures.toArray(new String[newNatures.size()]));
                project.setDescription(description, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                ExceptionUtil.handle((Throwable)e);
                throw new ExecutionException("Error executing command", (Throwable)e);
            }
        }
        return null;
    }
}

