/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.ide.adapters;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;

public class IDECPListElement {
    private int fEntryKind;
    private IPath fPath;
    private IPath fOrginalPath;
    private IResource fResource;
    private boolean fIsExported;
    private boolean fIsMissing;
    private Object fParentContainer;
    private IClasspathEntry fCachedEntry;

    public IDECPListElement(int entryKind, IPath path, IResource res) {
        this(null, entryKind, path, res);
    }

    public IDECPListElement(int entryKind) {
        this(null, entryKind, null, null);
    }

    public IDECPListElement(Object parent, int entryKind, IPath path, IResource res) {
        this(parent, entryKind, path, false, res);
    }

    public IDECPListElement(Object parent, int entryKind, IPath path, boolean newElement, IResource res) {
        this.fEntryKind = entryKind;
        this.fPath = path;
        this.fOrginalPath = newElement ? null : path;
        this.fResource = res;
        this.fIsExported = false;
        this.fIsMissing = false;
        this.fCachedEntry = null;
        this.fParentContainer = parent;
    }

    public IClasspathEntry getClasspathEntry() {
        if (this.fCachedEntry == null) {
            this.fCachedEntry = this.newClasspathEntry();
        }
        return this.fCachedEntry;
    }

    private IClasspathEntry newClasspathEntry() {
        IClasspathAttribute[] extraAttributes = new IClasspathAttribute[]{};
        switch (this.fEntryKind) {
            case 3: {
                return JavaCore.newSourceEntry((IPath)this.fPath, null, null, null, (IClasspathAttribute[])extraAttributes);
            }
            case 1: {
                return JavaCore.newLibraryEntry((IPath)this.fPath, null, null, null, (IClasspathAttribute[])extraAttributes, (boolean)this.isExported());
            }
            case 2: {
                return JavaCore.newProjectEntry((IPath)this.fPath, null, (boolean)false, (IClasspathAttribute[])extraAttributes, (boolean)this.isExported());
            }
            case 5: {
                return JavaCore.newContainerEntry((IPath)this.fPath, null, (IClasspathAttribute[])extraAttributes, (boolean)this.isExported());
            }
            case 4: {
                return JavaCore.newVariableEntry((IPath)this.fPath, null, null, null, (IClasspathAttribute[])extraAttributes, (boolean)this.isExported());
            }
        }
        return null;
    }

    public IPath getPath() {
        return this.fPath;
    }

    public int getEntryKind() {
        return this.fEntryKind;
    }

    public IResource getResource() {
        return this.fResource;
    }

    public Object[] getChildren(boolean hideOutputFolder) {
        return new Object[0];
    }

    public Object getParentContainer() {
        return this.fParentContainer;
    }

    protected void attributeChanged(String key) {
        this.fCachedEntry = null;
    }

    public boolean isDeprecated() {
        if (this.fEntryKind != 4) {
            return false;
        }
        if (this.fPath.segmentCount() > 0) {
            return JavaCore.getClasspathVariableDeprecationMessage((String)this.fPath.segment(0)) != null;
        }
        return false;
    }

    public boolean equals(Object other) {
        if (other != null && other.getClass().equals(this.getClass())) {
            IDECPListElement elem = (IDECPListElement)other;
            return this.getClasspathEntry().equals(elem.getClasspathEntry());
        }
        return false;
    }

    public int hashCode() {
        return this.fPath.hashCode() + this.fEntryKind;
    }

    public String toString() {
        return this.getClasspathEntry().toString();
    }

    public boolean isMissing() {
        return this.fIsMissing;
    }

    public void setIsMissing(boolean isMissing) {
        this.fIsMissing = isMissing;
    }

    public boolean isExported() {
        return this.fIsExported;
    }

    public void setExported(boolean isExported) {
        if (isExported != this.fIsExported) {
            this.fIsExported = isExported;
            this.attributeChanged(null);
        }
    }

    public void setPath(IPath path) {
        this.fCachedEntry = null;
        this.fPath = path;
    }

    public IPath getOrginalPath() {
        return this.fOrginalPath;
    }
}

