/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.series;

import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.type.DifferenceSeries;
import org.eclipse.birt.chart.model.type.LineSeries;
import org.eclipse.birt.chart.model.type.impl.LineSeriesImpl;
import org.eclipse.birt.chart.model.util.ChartElementUtil;
import org.eclipse.birt.chart.model.util.DefaultValueProvider;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.ChartCheckbox;
import org.eclipse.birt.chart.ui.swt.composites.LineAttributesComposite;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.util.ChartUIExtensionUtil;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class DifferenceSeriesAttributeComposite
extends Composite
implements SelectionListener,
Listener {
    protected Group grpLine = null;
    protected Group grpLine1 = null;
    protected LineAttributesComposite liacLine1 = null;
    protected Group grpLine2 = null;
    protected LineAttributesComposite liacLine2 = null;
    protected Series series = null;
    protected DifferenceSeries defSeries = DefaultValueProvider.defDifferenceSeries();
    protected ChartWizardContext context;
    private ChartCheckbox btnPalette;
    private ChartCheckbox btnCurve;
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.ui.extension/swt.series");

    public DifferenceSeriesAttributeComposite(Composite parent, int style, ChartWizardContext context, Series series) {
        super(parent, style);
        if (!(series instanceof LineSeriesImpl)) {
            try {
                throw new ChartException("org.eclipse.birt.chart.ui.extension", 30, "DifferenceSeriesAttributeComposite.Exception.IllegalArgument", new Object[]{series.getClass().getName()}, Messages.getResourceBundle());
            }
            catch (ChartException e) {
                logger.log((Exception)((Object)e));
                e.printStackTrace();
            }
        }
        this.series = series;
        this.context = context;
        this.init();
        this.placeComponents();
        ChartUIUtil.bindHelp((Control)parent, (String)this.getHelpId(series));
    }

    private String getHelpId(Series series) {
        String helpId = "org.eclipse.birt.chart.cshelp.FormatDifferenceChartYSeries_ID";
        return helpId;
    }

    private void init() {
        this.setSize(this.getParent().getClientArea().width, this.getParent().getClientArea().height);
    }

    private void placeComponents() {
        GridLayout glContent = new GridLayout(2, false);
        glContent.marginHeight = 2;
        glContent.marginWidth = 2;
        this.setLayout((Layout)glContent);
        this.grpLine = new Group((Composite)this, 0);
        GridLayout glGroup = new GridLayout(2, true);
        glGroup.horizontalSpacing = 5;
        this.grpLine.setLayout((Layout)glGroup);
        this.grpLine.setLayoutData((Object)new GridData(1808));
        this.grpLine.setText(Messages.getString("DifferenceSeriesAttributeComposite.Lbl.Line"));
        if (this.isPosivitiveAndNegativeLineAvailable()) {
            this.placePositiveAndNegativeLineComponents();
        } else {
            this.placeOneLineComponents();
        }
        Composite cmpButton = new Composite((Composite)this.grpLine, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = this.isPosivitiveAndNegativeLineAvailable() ? 2 : 1;
        cmpButton.setLayoutData((Object)gd);
        cmpButton.setLayout((Layout)new GridLayout(this.isPosivitiveAndNegativeLineAvailable() ? 2 : 1, false));
        this.btnPalette = this.context.getUIFactory().createChartCheckbox(cmpButton, 0, this.defSeries.isPaletteLineColor());
        this.btnPalette.setText(Messages.getString("DifferenceSeriesAttributeComposite.Lbl.LinePalette"));
        this.btnPalette.setLayoutData((Object)new GridData());
        this.btnPalette.setSelectionState(((LineSeries)this.series).isSetPaletteLineColor() ? (((LineSeries)this.series).isPaletteLineColor() ? 1 : 2) : 0);
        this.btnPalette.addSelectionListener((SelectionListener)this);
        this.btnCurve = this.context.getUIFactory().createChartCheckbox(cmpButton, 0, this.defSeries.isCurve());
        this.btnCurve.setText(Messages.getString("DifferenceSeriesAttributeComposite.Lbl.ShowLinesAsCurves"));
        this.btnCurve.setLayoutData((Object)new GridData());
        this.btnCurve.setSelectionState(((DifferenceSeries)this.series).isSetCurve() ? (((DifferenceSeries)this.series).isCurve() ? 1 : 2) : 0);
        this.btnCurve.addSelectionListener((SelectionListener)this);
        this.enableLinePaletteSetting(this.canEnableLinePalette());
    }

    protected boolean isPosivitiveAndNegativeLineAvailable() {
        return true;
    }

    protected void placePositiveAndNegativeLineComponents() {
        this.grpLine1 = new Group((Composite)this.grpLine, 0);
        GridData gdGRPLine = new GridData(1808);
        this.grpLine1.setLayout((Layout)new FillLayout());
        this.grpLine1.setLayoutData((Object)gdGRPLine);
        this.grpLine1.setText(Messages.getString("DifferenceSeriesAttributeComposite.Lbl.PositiveLine"));
        this.liacLine1 = this.createLineComponent((Composite)this.grpLine1, ((DifferenceSeries)this.series).getLineAttributes(), this.defSeries.getLineAttributes());
        this.grpLine2 = new Group((Composite)this.grpLine, 0);
        gdGRPLine = new GridData(1808);
        this.grpLine2.setLayout((Layout)new FillLayout());
        this.grpLine2.setLayoutData((Object)gdGRPLine);
        this.grpLine2.setText(Messages.getString("DifferenceSeriesAttributeComposite.Lbl.NegativeLine"));
        this.liacLine2 = this.createLineComponent((Composite)this.grpLine2, ((DifferenceSeries)this.series).getNegativeLineAttributes(), this.defSeries.getNegativeLineAttributes());
    }

    protected void placeOneLineComponents() {
        this.liacLine1 = this.createLineComponent((Composite)this.grpLine, ((DifferenceSeries)this.series).getLineAttributes(), this.defSeries.getLineAttributes());
        GridData gdLiacLine1 = new GridData(768);
        this.liacLine1.setLayoutData(gdLiacLine1);
        this.liacLine1.addListener(this);
    }

    protected LineAttributesComposite createLineComponent(Composite parent, LineAttributes lineAttrs, LineAttributes lineAttrsDef) {
        LineAttributesComposite lineAttrComp = new LineAttributesComposite(parent, 0, this.context, lineAttrs, true, true, true, true, true, lineAttrsDef);
        lineAttrComp.addListener(this);
        return lineAttrComp;
    }

    public Point getPreferredSize() {
        return new Point(400, 200);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource().equals(this.btnCurve)) {
            ChartElementUtil.setEObjectAttribute((EObject)this.series, (String)"curve", (Object)(this.btnCurve.getSelectionState() == 1 ? 1 : 0), (this.btnCurve.getSelectionState() == 0 ? 1 : 0) != 0);
        } else if (e.getSource().equals(this.btnPalette)) {
            ChartElementUtil.setEObjectAttribute((EObject)this.series, (String)"paletteLineColor", (Object)(this.btnPalette.getSelectionState() == 1 ? 1 : 0), (this.btnPalette.getSelectionState() == 0 ? 1 : 0) != 0);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void handleEvent(Event event) {
        boolean isUnset;
        boolean bl = isUnset = event.detail == ChartUIExtensionUtil.PROPERTY_UNSET;
        if (event.widget.equals((Object)this.liacLine1)) {
            if (event.type == 4) {
                ChartElementUtil.setEObjectAttribute((EObject)((DifferenceSeries)this.series).getLineAttributes(), (String)"visible", (Object)((Boolean)event.data), (boolean)isUnset);
                this.enableLinePaletteSetting(this.canEnableLinePalette());
            } else if (event.type == 1) {
                ChartElementUtil.setEObjectAttribute((EObject)((DifferenceSeries)this.series).getLineAttributes(), (String)"style", (Object)event.data, (boolean)isUnset);
            } else if (event.type == 2) {
                ChartElementUtil.setEObjectAttribute((EObject)((DifferenceSeries)this.series).getLineAttributes(), (String)"thickness", (Object)((Integer)event.data), (boolean)isUnset);
            } else if (event.type == 3) {
                ((DifferenceSeries)this.series).getLineAttributes().setColor((ColorDefinition)event.data);
            }
        } else if (event.widget.equals((Object)this.liacLine2)) {
            if (event.type == 4) {
                ChartElementUtil.setEObjectAttribute((EObject)((DifferenceSeries)this.series).getNegativeLineAttributes(), (String)"visible", (Object)((Boolean)event.data), (boolean)isUnset);
                this.enableLinePaletteSetting(this.canEnableLinePalette());
            } else if (event.type == 1) {
                ChartElementUtil.setEObjectAttribute((EObject)((DifferenceSeries)this.series).getNegativeLineAttributes(), (String)"style", (Object)event.data, (boolean)isUnset);
            } else if (event.type == 2) {
                ChartElementUtil.setEObjectAttribute((EObject)((DifferenceSeries)this.series).getNegativeLineAttributes(), (String)"thickness", (Object)((Integer)event.data), (boolean)isUnset);
            } else if (event.type == 3) {
                ((DifferenceSeries)this.series).getNegativeLineAttributes().setColor((ColorDefinition)event.data);
            }
        }
    }

    protected boolean canEnableLinePalette() {
        return !this.context.getUIFactory().isSetInvisible((EObject)((DifferenceSeries)this.series).getLineAttributes()) || !this.context.getUIFactory().isSetInvisible((EObject)((DifferenceSeries)this.series).getNegativeLineAttributes());
    }

    private void enableLinePaletteSetting(boolean isEnabled) {
        if (this.btnPalette != null) {
            this.btnPalette.setEnabled(isEnabled);
        }
    }
}

