/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.lookup.basic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.ServiceRegistrationResult;

public class ServiceStore {
    private final IReadOnlyQueryEnvironment queryEnvironment;
    private final Map<Integer, Map<String, List<IService<?>>>> services = new HashMap();

    public ServiceStore(IReadOnlyQueryEnvironment queryEnvironment) {
        this.queryEnvironment = queryEnvironment;
    }

    public List<IService<?>> getMultiService(String methodName, int argc) {
        Map<String, List<IService<?>>> argcServices = this.services.get(argc);
        if (argcServices == null) {
            return null;
        }
        return argcServices.get(methodName);
    }

    private List<IService<?>> getOrCreateMultiService(IService<?> service) {
        List<IService<?>> result;
        int argc = service.getNumberOfParameters();
        String serviceName = service.getName();
        Map<String, List<IService<?>>> argcServices = this.services.get(argc);
        if (argcServices == null) {
            argcServices = new HashMap();
            this.services.put(argc, argcServices);
        }
        if ((result = argcServices.get(serviceName)) == null) {
            result = new ArrayList();
            argcServices.put(serviceName, result);
        }
        return result;
    }

    public int size() {
        int result = 0;
        for (Map<String, List<IService<?>>> byArgC : this.services.values()) {
            for (List<IService<?>> byName : byArgC.values()) {
                result += byName.size();
            }
        }
        return result;
    }

    public IService<?> remove(IService<?> service) {
        IService<?> result;
        if (service == null) {
            return null;
        }
        int argc = service.getNumberOfParameters();
        Map<String, List<IService<?>>> argcServices = this.services.get(argc);
        if (argcServices != null) {
            String serviceName = service.getName();
            List<IService<?>> servicesList = argcServices.get(serviceName);
            if (servicesList != null && servicesList.remove(service)) {
                result = service;
                if (servicesList.isEmpty() && argcServices.remove(serviceName) != null && argcServices.isEmpty()) {
                    this.services.remove(argc);
                }
            } else {
                result = null;
            }
        } else {
            result = null;
        }
        return result;
    }

    public ServiceRegistrationResult add(IService<?> service) {
        ServiceRegistrationResult result = new ServiceRegistrationResult();
        List<IService<?>> multiService = this.getOrCreateMultiService(service);
        for (IService<?> existingService : multiService) {
            if (service.getPriority() > existingService.getPriority()) {
                if (!service.isLowerOrEqualParameterTypes(this.queryEnvironment, existingService) && !existingService.isLowerOrEqualParameterTypes(this.queryEnvironment, service)) continue;
                result.addMasked(service, existingService);
                continue;
            }
            if (service.getPriority() == existingService.getPriority()) {
                if (service.isEqualParameterTypes(this.queryEnvironment, existingService)) {
                    result.addDuplicated(service, existingService);
                    continue;
                }
                if (service.isLowerOrEqualParameterTypes(this.queryEnvironment, existingService)) {
                    result.addMasked(service, existingService);
                    continue;
                }
                if (!existingService.isLowerOrEqualParameterTypes(this.queryEnvironment, service)) continue;
                result.addIsMaskedBy(service, existingService);
                continue;
            }
            if (!service.isLowerOrEqualParameterTypes(this.queryEnvironment, existingService) && !existingService.isLowerOrEqualParameterTypes(this.queryEnvironment, service)) continue;
            result.addIsMaskedBy(service, existingService);
        }
        if (!multiService.contains(service)) {
            result.getRegistered().add(service);
            multiService.add(service);
        }
        return result;
    }

    public Set<IService<?>> getServices() {
        LinkedHashSet result = new LinkedHashSet();
        for (Map<String, List<IService<?>>> byArgC : this.services.values()) {
            for (List<IService<?>> byName : byArgC.values()) {
                result.addAll(byName);
            }
        }
        return result;
    }

    public boolean isRegistered(IService<?> service) {
        if (service == null) {
            return false;
        }
        List<IService<?>> multiService = this.getMultiService(service.getName(), service.getNumberOfParameters());
        return multiService != null && multiService.contains(service);
    }
}

