/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.delegates;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.acceleo.query.delegates.AbstractEnvironmentProvider;
import org.eclipse.acceleo.query.parser.AstResult;
import org.eclipse.acceleo.query.runtime.EvaluationResult;
import org.eclipse.acceleo.query.runtime.IQueryBuilderEngine;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IQueryEvaluationEngine;
import org.eclipse.acceleo.query.runtime.QueryEvaluation;
import org.eclipse.acceleo.query.runtime.QueryParsing;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EValidator;

public class AQLValidationDelegate
extends AbstractEnvironmentProvider
implements EValidator.ValidationDelegate {
    private static final String SELF = "self";

    public boolean validate(EClass eClass, EObject eObject, Map<Object, Object> context, EOperation invariant, String expression) {
        return Boolean.TRUE.equals(this.evaluate(eObject, expression));
    }

    public boolean validate(EClass eClass, EObject eObject, Map<Object, Object> context, String constraint, String expression) {
        return Boolean.TRUE.equals(this.evaluate(eObject, expression));
    }

    public boolean validate(EDataType eDataType, Object value, Map<Object, Object> context, String constraint, String expression) {
        return Boolean.TRUE.equals(this.evaluate(value, expression));
    }

    private Object evaluate(Object self, String expression) {
        IQueryEnvironment environment = this.getEnvironment();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put(SELF, self);
        IQueryBuilderEngine builderEngine = QueryParsing.newBuilder();
        AstResult astResult = builderEngine.build(expression);
        if (astResult.getDiagnostic().getSeverity() == 0) {
            IQueryEvaluationEngine evaluationEngine = QueryEvaluation.newEngine(environment);
            EvaluationResult evaluationResult = evaluationEngine.eval(astResult, variables);
            if (evaluationResult.getDiagnostic().getSeverity() != 0) {
                StringBuilder messages = new StringBuilder();
                for (Diagnostic child : evaluationResult.getDiagnostic().getChildren()) {
                    messages.append("\n" + child.getMessage());
                }
                throw new IllegalArgumentException("Unable to evaluate \"" + expression + "\"" + messages.toString());
            }
            return evaluationResult.getResult();
        }
        StringBuilder messages = new StringBuilder();
        for (Diagnostic child : astResult.getDiagnostic().getChildren()) {
            messages.append("\n" + child.getMessage());
        }
        throw new IllegalArgumentException("Unable to parse \"" + expression + "\"" + messages.toString());
    }
}

