/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query;

import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringJoiner;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenFactory;
import org.antlr.v4.runtime.TokenFactory;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.UnbufferedCharStream;
import org.antlr.v4.runtime.UnbufferedTokenStream;
import org.eclipse.acceleo.query.ast.ASTNode;
import org.eclipse.acceleo.query.ast.AstPackage;
import org.eclipse.acceleo.query.ast.Error;
import org.eclipse.acceleo.query.ast.ErrorExpression;
import org.eclipse.acceleo.query.ast.ErrorTypeLiteral;
import org.eclipse.acceleo.query.parser.AstBuilderListener;
import org.eclipse.acceleo.query.parser.AstResult;
import org.eclipse.acceleo.query.parser.Positions;
import org.eclipse.acceleo.query.parser.QueryLexer;
import org.eclipse.acceleo.query.parser.QueryParser;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.Query;
import org.eclipse.acceleo.query.runtime.ServiceUtils;
import org.eclipse.acceleo.query.runtime.impl.ECrossReferenceAdapterCrossReferenceProvider;
import org.eclipse.acceleo.query.runtime.impl.ResourceSetRootEObjectProvider;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameQueryEnvironment;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameResolver;
import org.eclipse.acceleo.query.services.configurator.IOptionProvider;
import org.eclipse.acceleo.query.services.configurator.IResourceSetConfigurator;
import org.eclipse.acceleo.query.services.configurator.IResourceSetConfiguratorDescriptor;
import org.eclipse.acceleo.query.services.configurator.IServicesConfigurator;
import org.eclipse.acceleo.query.services.configurator.IServicesConfiguratorDescriptor;
import org.eclipse.acceleo.query.validation.type.ClassType;
import org.eclipse.acceleo.query.validation.type.EClassifierSetLiteralType;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.SequenceType;
import org.eclipse.acceleo.query.validation.type.SetType;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;

public final class AQLUtils {
    private static final Map<String, List<IServicesConfiguratorDescriptor>> SERVICES_CONFIGURATORS = new LinkedHashMap<String, List<IServicesConfiguratorDescriptor>>();
    private static final List<IResourceSetConfiguratorDescriptor> RESOURCE_SET_CONFIGURATORS = new ArrayList<IResourceSetConfiguratorDescriptor>();
    public static final String INSTALL_CROSS_REFERENCE_ADAPTER_OPTION = "InstallCrossReferenceAdapter";
    public static final String BASE_URI_OPTION = "BaseURI";
    public static final String PROPERTIES_URIS_OPTION = "PropertiesURIs";
    public static final String AQL_LANGUAGE = "org.eclipse.acceleo.query";
    private static final Map<Object, ECrossReferenceAdapter> CROSS_REFERENCE_ADAPTERS = new HashMap<Object, ECrossReferenceAdapter>();

    private AQLUtils() {
    }

    public static List<String> computeAvailableTypes(List<String> uris, boolean includePrimitiveTypes, boolean includeSequenceTypes, boolean includeSetTypes) {
        HashSet<String> types = new HashSet<String>();
        if (includePrimitiveTypes) {
            types.add("String");
            types.add("Integer");
            types.add("Real");
            types.add("Boolean");
        }
        if (uris != null) {
            for (String nsURI : uris) {
                EPackage ePkg = EPackageRegistryImpl.INSTANCE.getEPackage(nsURI);
                if (ePkg == null) continue;
                types.addAll(AQLUtils.getEClassifiers(ePkg));
            }
        }
        ArrayList<String> res = new ArrayList<String>(types.size() * 3);
        for (String type : types) {
            res.add(type);
            if (includeSequenceTypes) {
                res.add("Sequence(" + type + ")");
            }
            if (!includeSetTypes) continue;
            res.add("OrderedSet(" + type + ")");
        }
        Collections.sort(res);
        return res;
    }

    private static List<String> getEClassifiers(EPackage ePkg) {
        ArrayList<String> res = new ArrayList<String>();
        for (EClassifier eClassifier : ePkg.getEClassifiers()) {
            res.add(ePkg.getName() + "::" + eClassifier.getName());
        }
        for (EPackage child : ePkg.getESubpackages()) {
            res.addAll(AQLUtils.getEClassifiers(child));
        }
        return res;
    }

    public static AcceleoAQLResult parseWhileAqlExpression(String expression) {
        AcceleoAQLResult result;
        if (expression != null && expression.length() > 0) {
            AstBuilderListener astBuilder = new AstBuilderListener();
            UnbufferedCharStream input = new UnbufferedCharStream((Reader)new StringReader(expression), expression.length());
            QueryLexer lexer = new QueryLexer((CharStream)input);
            lexer.setTokenFactory((TokenFactory)new CommonTokenFactory(true));
            lexer.removeErrorListeners();
            lexer.addErrorListener(astBuilder.getErrorListener());
            UnbufferedTokenStream tokens = new UnbufferedTokenStream((TokenSource)lexer);
            QueryParser parser = new QueryParser((TokenStream)tokens);
            parser.addParseListener(astBuilder);
            parser.removeErrorListeners();
            parser.addErrorListener(astBuilder.getErrorListener());
            parser.expression();
            result = new AcceleoAQLResult(astBuilder.getAstResult(), AQLUtils.rewindWhiteSpaces(expression, parser.getCurrentToken().getStartIndex()));
        } else {
            ErrorExpression errorExpression = (ErrorExpression)EcoreUtil.create((EClass)AstPackage.eINSTANCE.getErrorExpression());
            ArrayList<Error> aqlErrors = new ArrayList<Error>(1);
            aqlErrors.add(errorExpression);
            Positions<ASTNode> aqlPositions = new Positions<ASTNode>();
            if (expression != null) {
                aqlPositions.setIdentifierStartPositions(errorExpression, 0);
                aqlPositions.setIdentifierStartLines(errorExpression, 0);
                aqlPositions.setIdentifierStartColumns(errorExpression, 0);
                aqlPositions.setIdentifierEndPositions(errorExpression, 0);
                aqlPositions.setIdentifierEndLines(errorExpression, 0);
                aqlPositions.setIdentifierEndColumns(errorExpression, 0);
                aqlPositions.setStartPositions(errorExpression, 0);
                aqlPositions.setStartLines(errorExpression, 0);
                aqlPositions.setStartColumns(errorExpression, 0);
                aqlPositions.setEndPositions(errorExpression, 0);
                aqlPositions.setEndLines(errorExpression, 0);
                aqlPositions.setEndColumns(errorExpression, 0);
            }
            BasicDiagnostic diagnostic = new BasicDiagnostic();
            diagnostic.add((Diagnostic)new BasicDiagnostic(4, AQL_LANGUAGE, 0, "missing expression", new Object[]{errorExpression}));
            result = new AcceleoAQLResult(new AstResult(errorExpression, aqlPositions, aqlErrors, (Diagnostic)diagnostic), 0);
        }
        return result;
    }

    private static int rewindWhiteSpaces(String text, int position) {
        int res;
        if (text != null && !text.isEmpty()) {
            int index = position - 1;
            if (Character.isWhitespace(text.charAt(index))) {
                while (--index >= 0 && Character.isWhitespace(text.charAt(index))) {
                }
                res = index + 1;
            } else {
                res = position;
            }
        } else {
            res = position;
        }
        return res;
    }

    public static AstResult parseWhileAqlTypeLiteral(String expression) {
        AstResult result;
        if (expression != null && expression.length() > 0) {
            AstBuilderListener astBuilder = new AstBuilderListener();
            UnbufferedCharStream input = new UnbufferedCharStream((Reader)new StringReader(expression), expression.length());
            QueryLexer lexer = new QueryLexer((CharStream)input);
            lexer.setTokenFactory((TokenFactory)new CommonTokenFactory(true));
            lexer.removeErrorListeners();
            lexer.addErrorListener(astBuilder.getErrorListener());
            UnbufferedTokenStream tokens = new UnbufferedTokenStream((TokenSource)lexer);
            QueryParser parser = new QueryParser((TokenStream)tokens);
            parser.addParseListener(astBuilder);
            parser.removeErrorListeners();
            parser.addErrorListener(astBuilder.getErrorListener());
            parser.typeLiteral();
            result = astBuilder.getAstResult();
        } else {
            ErrorTypeLiteral errorTypeLiteral = (ErrorTypeLiteral)EcoreUtil.create((EClass)AstPackage.eINSTANCE.getErrorTypeLiteral());
            ArrayList<Error> errs = new ArrayList<Error>(1);
            errs.add(errorTypeLiteral);
            Positions<ASTNode> aqlPositions = new Positions<ASTNode>();
            if (expression != null) {
                aqlPositions.setIdentifierStartPositions(errorTypeLiteral, 0);
                aqlPositions.setIdentifierStartLines(errorTypeLiteral, 0);
                aqlPositions.setIdentifierStartColumns(errorTypeLiteral, 0);
                aqlPositions.setIdentifierEndPositions(errorTypeLiteral, 0);
                aqlPositions.setIdentifierEndLines(errorTypeLiteral, 0);
                aqlPositions.setIdentifierEndColumns(errorTypeLiteral, 0);
                aqlPositions.setStartPositions(errorTypeLiteral, 0);
                aqlPositions.setStartLines(errorTypeLiteral, 0);
                aqlPositions.setStartColumns(errorTypeLiteral, 0);
                aqlPositions.setEndPositions(errorTypeLiteral, 0);
                aqlPositions.setEndLines(errorTypeLiteral, 0);
                aqlPositions.setEndColumns(errorTypeLiteral, 0);
            }
            BasicDiagnostic diagnostic = new BasicDiagnostic();
            diagnostic.add((Diagnostic)new BasicDiagnostic(4, AQL_LANGUAGE, 0, "missing type literal", new Object[]{errorTypeLiteral}));
            result = new AstResult(errorTypeLiteral, aqlPositions, errs, (Diagnostic)diagnostic);
        }
        return result;
    }

    public static String getAqlTypeString(IType type) {
        StringBuilder res = new StringBuilder();
        if (type instanceof EClassifierType) {
            res.append(((EClassifierType)type).getType().getEPackage().getName());
            res.append("::");
            res.append(((EClassifierType)type).getType().getName());
        } else if (type instanceof SequenceType) {
            res.append("Sequence(");
            res.append(AQLUtils.getAqlTypeString(((SequenceType)type).getCollectionType()));
            res.append(")");
        } else if (type instanceof EClassifierSetLiteralType) {
            res.append("{");
            StringJoiner joiner = new StringJoiner(" | ");
            for (EClassifier eClassifier : ((EClassifierSetLiteralType)type).getEClassifiers()) {
                joiner.add(eClassifier.getEPackage().getName() + "::" + eClassifier.getName());
            }
            res.append(joiner.toString());
            res.append("}");
        } else if (type instanceof SetType) {
            res.append("OrderedSet(");
            res.append(AQLUtils.getAqlTypeString(((SetType)type).getCollectionType()));
            res.append(")");
        } else if (type instanceof ClassType) {
            Object cls = ((ClassType)type).getType();
            if (cls == Double.class) {
                res.append("Real");
            } else {
                res.append(((Class)cls).getSimpleName());
            }
        }
        return res.toString();
    }

    public static int[][] getLinesAndColumns(String text) {
        int[][] res = new int[text.length()][2];
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (LineNumberReader reader = new LineNumberReader(new StringReader(text));){
                int column = 0;
                int i = 0;
                while (i < res.length) {
                    int previousLine = reader.getLineNumber();
                    reader.read();
                    if (previousLine != reader.getLineNumber()) {
                        column = 0;
                    }
                    res[i][0] = reader.getLineNumber();
                    res[i][1] = ++column;
                    ++i;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<IServicesConfigurator> getServicesConfigurators(String language) {
        ArrayList<IServicesConfigurator> res = new ArrayList<IServicesConfigurator>();
        Map<String, List<IServicesConfiguratorDescriptor>> map = SERVICES_CONFIGURATORS;
        synchronized (map) {
            List<IServicesConfiguratorDescriptor> configurators = SERVICES_CONFIGURATORS.get(language);
            if (configurators != null) {
                List<IServicesConfiguratorDescriptor> list = configurators;
                synchronized (list) {
                    for (IServicesConfiguratorDescriptor descriptor : configurators) {
                        IServicesConfigurator configurator = descriptor.getServicesConfigurator();
                        if (configurator == null) continue;
                        res.add(configurator);
                    }
                }
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerServicesConfigurator(IServicesConfiguratorDescriptor configurator) {
        if (configurator != null) {
            Map<String, List<IServicesConfiguratorDescriptor>> map = SERVICES_CONFIGURATORS;
            synchronized (map) {
                List configurators;
                List list = configurators = SERVICES_CONFIGURATORS.computeIfAbsent(configurator.getLanguage(), l -> new ArrayList());
                synchronized (list) {
                    configurators.add(configurator);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterServicesConfigurator(IServicesConfiguratorDescriptor configuratorDescriptor) {
        if (configuratorDescriptor != null) {
            Map<String, List<IServicesConfiguratorDescriptor>> map = SERVICES_CONFIGURATORS;
            synchronized (map) {
                List<IServicesConfiguratorDescriptor> configurators = SERVICES_CONFIGURATORS.get(configuratorDescriptor.getLanguage());
                if (configurators != null) {
                    List<IServicesConfiguratorDescriptor> list = configurators;
                    synchronized (list) {
                        if (configurators.remove(configuratorDescriptor) && configurators.isEmpty()) {
                            SERVICES_CONFIGURATORS.remove(configuratorDescriptor.getLanguage());
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<IResourceSetConfigurator> getResourceSetConfigurators() {
        ArrayList<IResourceSetConfigurator> res = new ArrayList<IResourceSetConfigurator>();
        List<IResourceSetConfiguratorDescriptor> list = RESOURCE_SET_CONFIGURATORS;
        synchronized (list) {
            for (IResourceSetConfiguratorDescriptor descriptor : RESOURCE_SET_CONFIGURATORS) {
                IResourceSetConfigurator configurator = descriptor.getResourceSetConfigurator();
                if (configurator == null) continue;
                res.add(configurator);
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerResourceSetConfigurator(IResourceSetConfiguratorDescriptor configurator) {
        if (configurator != null) {
            List<IResourceSetConfiguratorDescriptor> list = RESOURCE_SET_CONFIGURATORS;
            synchronized (list) {
                RESOURCE_SET_CONFIGURATORS.add(configurator);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterResourceSetConfigurator(IResourceSetConfiguratorDescriptor configuratorDescriptor) {
        if (configuratorDescriptor != null) {
            List<IResourceSetConfiguratorDescriptor> list = RESOURCE_SET_CONFIGURATORS;
            synchronized (list) {
                RESOURCE_SET_CONFIGURATORS.remove(configuratorDescriptor);
            }
        }
    }

    public static ResourceSet createResourceSetForModels(List<Exception> exceptions, Object key, ResourceSet defaultResourceSet, Map<String, String> options) {
        ResourceSet res = null;
        for (IResourceSetConfigurator configurator : AQLUtils.getResourceSetConfigurators()) {
            try {
                res = configurator.createResourceSetForModels(key, options);
                if (res == null) continue;
                break;
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        if (res == null) {
            res = defaultResourceSet;
        }
        if (Boolean.valueOf(options.get(INSTALL_CROSS_REFERENCE_ADAPTER_OPTION)).booleanValue()) {
            ECrossReferenceAdapter adapter = new ECrossReferenceAdapter();
            adapter.setTarget((Notifier)res);
            res.eAdapters().add((Object)adapter);
            CROSS_REFERENCE_ADAPTERS.put(key, adapter);
        }
        return res;
    }

    public static void cleanResourceSetForModels(Object key, ResourceSet resourceSet) {
        ECrossReferenceAdapter adapter = CROSS_REFERENCE_ADAPTERS.remove(key);
        if (adapter != null) {
            adapter.unsetTarget((Notifier)resourceSet);
            resourceSet.eAdapters().remove((Object)adapter);
        }
        for (IResourceSetConfigurator configurator : AQLUtils.getResourceSetConfigurators()) {
            configurator.cleanResourceSetForModels(key);
        }
    }

    public static Map<String, String> getInitializedOptions(String language, Map<String, String> options) {
        LinkedHashMap<String, String> res = new LinkedHashMap<String, String>();
        for (IOptionProvider provider : AQLUtils.getOptionProviders(AQL_LANGUAGE)) {
            res.putAll(provider.getInitializedOptions(options));
        }
        for (IOptionProvider provider : AQLUtils.getOptionProviders(language)) {
            res.putAll(provider.getInitializedOptions(options));
        }
        return res;
    }

    public static Set<String> getPossibleOptionNames(String language) {
        LinkedHashSet<String> res = new LinkedHashSet<String>();
        for (IOptionProvider provider : AQLUtils.getOptionProviders(AQL_LANGUAGE)) {
            res.addAll(provider.getOptions());
        }
        for (IOptionProvider provider : AQLUtils.getOptionProviders(language)) {
            res.addAll(provider.getOptions());
        }
        res.add(INSTALL_CROSS_REFERENCE_ADAPTER_OPTION);
        return res;
    }

    private static List<IOptionProvider> getOptionProviders(String language) {
        ArrayList<IOptionProvider> res = new ArrayList<IOptionProvider>();
        res.addAll(AQLUtils.getServicesConfigurators(AQL_LANGUAGE));
        res.addAll(AQLUtils.getServicesConfigurators(language));
        res.addAll(AQLUtils.getResourceSetConfigurators());
        return res;
    }

    public static IQualifiedNameQueryEnvironment newQualifiedNameEnvironmentDefaultServices(String language, Map<String, String> options, IQualifiedNameResolver resolver, ResourceSet resourceSetForModels, boolean forWorkspace) {
        ECrossReferenceAdapterCrossReferenceProvider crossReferenceProvider = new ECrossReferenceAdapterCrossReferenceProvider(ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)resourceSetForModels));
        ResourceSetRootEObjectProvider rootProvider = new ResourceSetRootEObjectProvider(resourceSetForModels);
        Properties properties = AQLUtils.getProperties(resourceSetForModels.getURIConverter(), options);
        IQualifiedNameQueryEnvironment queryEnvironment = Query.newQualifiedNameEnvironmentWithDefaultServices(resolver, crossReferenceProvider, rootProvider, properties, forWorkspace);
        for (IServicesConfigurator configurator : AQLUtils.getServicesConfigurators(AQL_LANGUAGE)) {
            ServiceUtils.registerServices(queryEnvironment, configurator.getServices(queryEnvironment, resourceSetForModels, options, forWorkspace));
        }
        for (IServicesConfigurator configurator : AQLUtils.getServicesConfigurators(language)) {
            ServiceUtils.registerServices(queryEnvironment, configurator.getServices(queryEnvironment, resourceSetForModels, options, forWorkspace));
        }
        return queryEnvironment;
    }

    private static Properties getProperties(URIConverter uriConverter, Map<String, String> options) {
        Properties properties = new Properties();
        String propertiesURIsOption = options.get(PROPERTIES_URIS_OPTION);
        if (propertiesURIsOption != null) {
            String[] uris = propertiesURIsOption.split(",");
            String baseURIString = options.get(BASE_URI_OPTION);
            URI baseURI = baseURIString != null ? URI.createURI((String)baseURIString, (boolean)true) : null;
            String[] stringArray = uris;
            int n = uris.length;
            int n2 = 0;
            while (n2 < n) {
                String uriString = stringArray[n2];
                URI uri = URI.createURI((String)uriString, (boolean)true);
                if (uri.isRelative() && baseURI != null) {
                    uri = uri.resolve(baseURI);
                }
                try {
                    Throwable throwable = null;
                    Object var13_15 = null;
                    try (InputStream is = uriConverter.createInputStream(uri);){
                        properties.load(is);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ++n2;
            }
        }
        return properties;
    }

    public static void cleanServices(String language, IReadOnlyQueryEnvironment queryEnvironment, ResourceSet resourceSetForModels) {
        for (IServicesConfigurator configurator : AQLUtils.getServicesConfigurators(AQL_LANGUAGE)) {
            configurator.cleanServices(queryEnvironment, resourceSetForModels);
        }
        for (IServicesConfigurator configurator : AQLUtils.getServicesConfigurators(language)) {
            configurator.cleanServices(queryEnvironment, resourceSetForModels);
        }
    }

    public static class AcceleoAQLResult {
        private final AstResult astResult;
        private final int endPosition;

        public AcceleoAQLResult(AstResult astResult, int endPosition) {
            this.astResult = astResult;
            this.endPosition = endPosition;
        }

        public AstResult getAstResult() {
            return this.astResult;
        }

        public int getEndPosition() {
            return this.endPosition;
        }
    }
}

