/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.evaluation.strategy;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.acceleo.OpenModeKind;
import org.eclipse.acceleo.aql.evaluation.strategy.IAcceleoGenerationStrategy;
import org.eclipse.acceleo.aql.evaluation.strategy.IWriterFactory;
import org.eclipse.acceleo.aql.evaluation.writer.IAcceleoWriter;
import org.eclipse.acceleo.aql.evaluation.writer.NullWriter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;

public class DefaultGenerationStrategy
implements IAcceleoGenerationStrategy {
    private static final Map<String, Object> EMPTY_OPTION_MAP = Collections.emptyMap();
    protected final Map<URI, Map<String, List<String>>> protectedAreaContents = new LinkedHashMap<URI, Map<String, List<String>>>();
    protected final URIConverter uriConverter;
    private final IWriterFactory writerFactory;

    public DefaultGenerationStrategy(URIConverter uriConverter, IWriterFactory writerFactory) {
        this.uriConverter = uriConverter;
        this.writerFactory = writerFactory;
    }

    @Override
    public void closeWriter(IAcceleoWriter writer) throws IOException {
        writer.close();
    }

    @Override
    public String consumeProtectedAreaContent(URI uri, String protectedAreaID) {
        String res;
        Map<String, List<String>> uriAreaContentsMap = this.protectedAreaContents.get(uri);
        if (uriAreaContentsMap != null) {
            List<String> areaContents = uriAreaContentsMap.get(protectedAreaID);
            if (areaContents == null || areaContents.isEmpty()) {
                res = null;
            } else {
                res = areaContents.remove(0);
                if (areaContents.isEmpty()) {
                    uriAreaContentsMap.remove(protectedAreaID);
                    if (uriAreaContentsMap.isEmpty()) {
                        this.protectedAreaContents.remove(uri);
                    }
                }
            }
        } else {
            res = null;
        }
        return res;
    }

    @Override
    public Map<String, List<String>> consumeAllProtectedAreas(URI uri) {
        Map<String, List<String>> remainingAreaContents = this.protectedAreaContents.remove(uri);
        Map<String, List<String>> res = remainingAreaContents != null ? remainingAreaContents : Collections.emptyMap();
        return res;
    }

    @Override
    public IAcceleoWriter createWriterForLog(URI uri, Charset charset, String lineDelimiter) throws IOException {
        return this.createWriterFor(uri, OpenModeKind.APPEND, charset, lineDelimiter);
    }

    @Override
    public IAcceleoWriter createWriterForLostContent(URI uri, String protectedAreaID, Charset charset, String lineDelimiter) throws IOException {
        URI lostURI = URI.createURI((String)(uri.toString() + "-lost.txt"));
        return this.createWriterFor(lostURI, OpenModeKind.APPEND, charset, lineDelimiter);
    }

    @Override
    public IAcceleoWriter createWriterFor(URI uri, OpenModeKind openMode, Charset charset, String lineDelimiter) throws IOException {
        IAcceleoWriter writer;
        boolean exists = this.uriConverter.exists(uri, EMPTY_OPTION_MAP);
        switch (openMode) {
            case CREATE: {
                if (exists) {
                    writer = new NullWriter(uri, charset);
                    break;
                }
                writer = this.writerFactory.createWriter(OpenModeKind.CREATE, uri, this.uriConverter, charset, lineDelimiter);
                break;
            }
            case OVERWRITE: {
                if (exists) {
                    Throwable throwable = null;
                    Object var8_9 = null;
                    try (InputStream input = this.uriConverter.createInputStream(uri);){
                        Map<String, List<String>> protectedAreas = this.readProtectedAreaContent(new InputStreamReader(input), lineDelimiter);
                        if (protectedAreas != null && !protectedAreas.isEmpty()) {
                            this.protectedAreaContents.put(uri, protectedAreas);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                writer = this.writerFactory.createWriter(OpenModeKind.OVERWRITE, uri, this.uriConverter, charset, lineDelimiter);
                break;
            }
            case APPEND: {
                writer = this.writerFactory.createWriter(OpenModeKind.APPEND, uri, this.uriConverter, charset, lineDelimiter);
                break;
            }
            default: {
                writer = new NullWriter(uri, charset);
            }
        }
        return writer;
    }

    @Override
    public void start(URI destination) {
    }

    @Override
    public void terminate() {
    }

    protected Map<String, List<String>> readProtectedAreaContent(Reader reader, String lineDelimiter) throws IOException {
        LinkedHashMap<String, List<String>> protectedAreas = new LinkedHashMap<String, List<String>>();
        BufferedReader localReader = new BufferedReader(reader);
        String line = localReader.readLine();
        while (line != null) {
            int start = line.indexOf(USER_CODE_START);
            if (start >= 0) {
                String id = line.substring(start + USER_CODE_START.length()).trim();
                StringBuffer areaContent = new StringBuffer(1024);
                areaContent.append(line.substring(start));
                areaContent.append(lineDelimiter);
                line = localReader.readLine();
                while (line != null) {
                    int end = line.indexOf(USER_CODE_END);
                    if (end >= 0) {
                        int endOffset = end + USER_CODE_END.length();
                        areaContent.append(line.substring(0, endOffset));
                        areaContent.append(lineDelimiter);
                        break;
                    }
                    areaContent.append(line);
                    areaContent.append(lineDelimiter);
                    line = localReader.readLine();
                }
                protectedAreas.computeIfAbsent(id, i -> new ArrayList()).add(areaContent.toString());
            }
            line = localReader.readLine();
        }
        return protectedAreas;
    }
}

