/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.tests.utils;

import java.util.List;
import java.util.Set;
import org.eclipse.acceleo.AcceleoASTNode;
import org.eclipse.acceleo.AcceleoPackage;
import org.eclipse.acceleo.Binding;
import org.eclipse.acceleo.Block;
import org.eclipse.acceleo.BlockComment;
import org.eclipse.acceleo.Comment;
import org.eclipse.acceleo.CommentBody;
import org.eclipse.acceleo.ErrorBinding;
import org.eclipse.acceleo.ErrorComment;
import org.eclipse.acceleo.ErrorExpressionStatement;
import org.eclipse.acceleo.ErrorFileStatement;
import org.eclipse.acceleo.ErrorForStatement;
import org.eclipse.acceleo.ErrorIfStatement;
import org.eclipse.acceleo.ErrorImport;
import org.eclipse.acceleo.ErrorLetStatement;
import org.eclipse.acceleo.ErrorMetamodel;
import org.eclipse.acceleo.ErrorModule;
import org.eclipse.acceleo.ErrorProtectedArea;
import org.eclipse.acceleo.ErrorQuery;
import org.eclipse.acceleo.ErrorTemplate;
import org.eclipse.acceleo.ErrorVariable;
import org.eclipse.acceleo.Expression;
import org.eclipse.acceleo.ExpressionStatement;
import org.eclipse.acceleo.FileStatement;
import org.eclipse.acceleo.ForStatement;
import org.eclipse.acceleo.IfStatement;
import org.eclipse.acceleo.Import;
import org.eclipse.acceleo.LetStatement;
import org.eclipse.acceleo.Metamodel;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.ModuleDocumentation;
import org.eclipse.acceleo.ModuleElement;
import org.eclipse.acceleo.ModuleElementDocumentation;
import org.eclipse.acceleo.ModuleReference;
import org.eclipse.acceleo.NewLineStatement;
import org.eclipse.acceleo.ParameterDocumentation;
import org.eclipse.acceleo.ProtectedArea;
import org.eclipse.acceleo.Query;
import org.eclipse.acceleo.Statement;
import org.eclipse.acceleo.Template;
import org.eclipse.acceleo.TextStatement;
import org.eclipse.acceleo.Variable;
import org.eclipse.acceleo.aql.parser.AcceleoAstResult;
import org.eclipse.acceleo.query.ast.ASTNode;
import org.eclipse.acceleo.query.ast.BooleanLiteral;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.ast.CallType;
import org.eclipse.acceleo.query.ast.ClassTypeLiteral;
import org.eclipse.acceleo.query.ast.CollectionTypeLiteral;
import org.eclipse.acceleo.query.ast.Conditional;
import org.eclipse.acceleo.query.ast.EClassifierTypeLiteral;
import org.eclipse.acceleo.query.ast.EnumLiteral;
import org.eclipse.acceleo.query.ast.Error;
import org.eclipse.acceleo.query.ast.IntegerLiteral;
import org.eclipse.acceleo.query.ast.Lambda;
import org.eclipse.acceleo.query.ast.Let;
import org.eclipse.acceleo.query.ast.NullLiteral;
import org.eclipse.acceleo.query.ast.RealLiteral;
import org.eclipse.acceleo.query.ast.SequenceInExtensionLiteral;
import org.eclipse.acceleo.query.ast.SetInExtensionLiteral;
import org.eclipse.acceleo.query.ast.StringLiteral;
import org.eclipse.acceleo.query.ast.TypeLiteral;
import org.eclipse.acceleo.query.ast.TypeSetLiteral;
import org.eclipse.acceleo.query.ast.VarRef;
import org.eclipse.acceleo.query.ast.VariableDeclaration;
import org.eclipse.acceleo.query.ast.util.AstSwitch;
import org.eclipse.acceleo.util.AcceleoSwitch;
import org.eclipse.emf.ecore.EObject;

public class ModuleAstSerializer
extends AcceleoSwitch<Void> {
    private static final String SPACE = " ";
    private static final String MISSING_NAME_MESSAGE_PREFIX = "missing name: ";
    private static final String MISSING_OPEN_PARENTHESIS_MESSAGE_PREFIX = "missing open parenthesis: ";
    private static final String MISSING_CLOSE_PARENTHESIS_MESSAGE_PREFIX = "missing close parenthesis: ";
    private static final String MISSING_START_TAG_PREFIX_CLOSE_PARENTHESIS_MESSAGE_PREFIX = "missing start tag prefix close parenthesis: ";
    private static final String MISSING_END_TAG_PREFIX_CLOSE_PARENTHESIS_MESSAGE_PREFIX = "missing end tag prefix close parenthesis: ";
    private static final String MISSING_SEPARATOR_CLOSE_PARENTHESIS_MESSAGE_PREFIX = "missing separator close parenthesis: ";
    private static final String MISSING_END_HEADER_MESSAGE_PREFIX = "missing end header: ";
    private static final String MISSING_END_MESSAGE_PREFIX = "missing end: ";
    private static final String MISSING_COLON_MESSAGE_PREFIX = "missing colon: ";
    private static final String MISSING_TYPE_MESSAGE_PREFIX = "missing type: ";
    private static final String NULL_STRING = "null";
    private StringBuilder builder;
    private QueryAstSerializer querySerializer = new QueryAstSerializer();
    private String indentation;
    private AcceleoAstResult ast;

    protected void indent() {
        this.indentation = String.valueOf(this.indentation) + "  ";
    }

    protected void deindent() {
        this.indentation = this.indentation.substring(0, this.indentation.length() - 2);
    }

    public String serialize(AcceleoAstResult astResult) {
        this.ast = astResult;
        this.builder = new StringBuilder();
        this.indentation = "";
        this.doSwitch((EObject)astResult.getModule());
        return this.builder.toString();
    }

    protected void newLine() {
        this.builder.append("\n" + this.indentation);
    }

    public Void caseModule(Module module) {
        if (module.getDocumentation() != null) {
            this.doSwitch((EObject)module.getDocumentation());
        }
        this.newLine();
        this.builder.append("header position " + module.getStartHeaderPosition());
        this.builder.append("..");
        this.builder.append(module.getEndHeaderPosition());
        this.newLine();
        this.builder.append("module " + module.getName());
        if (module.getEncoding() != null) {
            this.newLine();
            this.builder.append("encoding ");
            this.builder.append(module.getEncoding());
        }
        this.indent();
        for (Metamodel metamodel : module.getMetamodels()) {
            this.newLine();
            this.doSwitch((EObject)metamodel);
        }
        if (module.getExtends() != null) {
            this.newLine();
            this.builder.append("extends ");
            this.doSwitch((EObject)module.getExtends());
        }
        for (Import imported : module.getImports()) {
            this.newLine();
            this.doSwitch((EObject)imported);
        }
        for (ModuleElement element : module.getModuleElements()) {
            this.newLine();
            this.doSwitch((EObject)element);
        }
        this.deindent();
        return null;
    }

    public Void caseErrorModule(ErrorModule errorModule) {
        this.builder.append("*** error module ***");
        this.newLine();
        this.builder.append(MISSING_OPEN_PARENTHESIS_MESSAGE_PREFIX + errorModule.getMissingOpenParenthesis());
        this.newLine();
        this.builder.append("missing EPackage: " + errorModule.getMissingEPackage());
        this.newLine();
        this.builder.append(MISSING_CLOSE_PARENTHESIS_MESSAGE_PREFIX + errorModule.getMissingCloseParenthesis());
        this.newLine();
        this.builder.append(MISSING_END_HEADER_MESSAGE_PREFIX + errorModule.getMissingEndHeader());
        this.newLine();
        return null;
    }

    public Void caseImport(Import imp) {
        this.builder.append("imports ");
        this.doSwitch((EObject)imp.getModule());
        return null;
    }

    public Void caseErrorImport(ErrorImport errorImport) {
        this.builder.append("*** error import ***");
        this.newLine();
        this.builder.append(MISSING_END_MESSAGE_PREFIX + errorImport.getMissingEnd());
        this.newLine();
        return null;
    }

    public Void caseModuleReference(ModuleReference moduleReference) {
        this.builder.append(moduleReference.getQualifiedName());
        return null;
    }

    public Void caseMetamodel(Metamodel metamodel) {
        if (metamodel.getReferencedPackage() != null) {
            this.builder.append("metamodel " + metamodel.getReferencedPackage().getNsURI());
        } else {
            this.builder.append("metamodel null");
        }
        return null;
    }

    public Void caseErrorMetamodel(ErrorMetamodel errorMetamodel) {
        this.builder.append("*** error metamodel ***");
        this.newLine();
        this.builder.append("missing end quote: " + errorMetamodel.getMissingEndQuote());
        this.newLine();
        return null;
    }

    public Void caseTemplate(Template template) {
        if (template.getDocumentation() != null) {
            this.doSwitch((EObject)template.getDocumentation());
        }
        this.newLine();
        this.builder.append(template.getVisibility().getName());
        this.builder.append(" template " + template.getName() + "(");
        StringBuilder previousBuilder = this.builder;
        this.builder = new StringBuilder();
        for (Variable variable : template.getParameters()) {
            this.doSwitch((EObject)variable);
            this.builder.append(", ");
        }
        if (this.builder.length() >= 2) {
            previousBuilder.append(this.builder.substring(0, this.builder.length() - 2));
        }
        this.builder = previousBuilder;
        this.builder.append(')');
        if (template.isMain()) {
            this.newLine();
            this.builder.append("@main");
        }
        if (template.getGuard() != null) {
            this.newLine();
            this.builder.append("guard ");
            this.doSwitch((EObject)template.getGuard());
        }
        if (template.getPost() != null) {
            this.newLine();
            this.builder.append("post ");
            this.doSwitch((EObject)template.getPost());
        }
        this.doSwitch((EObject)template.getBody());
        this.newLine();
        this.builder.append("[/template]");
        return null;
    }

    public Void caseErrorTemplate(ErrorTemplate errorTemplate) {
        this.builder.append("*** error template ***");
        this.newLine();
        this.builder.append("missing visibility: " + errorTemplate.getMissingVisibility());
        this.newLine();
        this.builder.append(MISSING_NAME_MESSAGE_PREFIX + errorTemplate.getMissingName());
        this.newLine();
        this.builder.append(MISSING_OPEN_PARENTHESIS_MESSAGE_PREFIX + errorTemplate.getMissingOpenParenthesis());
        this.newLine();
        this.builder.append("missing parameters: " + errorTemplate.getMissingParameters());
        this.newLine();
        this.builder.append(MISSING_CLOSE_PARENTHESIS_MESSAGE_PREFIX + errorTemplate.getMissingCloseParenthesis());
        this.newLine();
        this.builder.append("missing guard open parenthesis: " + errorTemplate.getMissingGuardOpenParenthesis());
        this.newLine();
        this.builder.append("missing guard close parenthesis: " + errorTemplate.getMissingGuardCloseParenthesis());
        this.newLine();
        this.builder.append("missing post close parenthesis: " + errorTemplate.getMissingPostCloseParenthesis());
        this.newLine();
        this.builder.append("missing post end header: " + errorTemplate.getMissingEndHeader());
        this.newLine();
        this.builder.append("missing post end: " + errorTemplate.getMissingEnd());
        this.newLine();
        return null;
    }

    public Void caseBlock(Block block) {
        this.indent();
        for (Statement statement : block.getStatements()) {
            this.newLine();
            this.doSwitch((EObject)statement);
        }
        this.deindent();
        return null;
    }

    public Void caseBinding(Binding binding) {
        this.builder.append(binding.getName());
        this.builder.append(" : ");
        if (binding.getType() != null) {
            this.builder.append(this.querySerializer.serialize(binding.getType().getAst()));
        } else {
            this.builder.append(NULL_STRING);
        }
        this.builder.append(" = ");
        this.doSwitch((EObject)binding.getInitExpression());
        return null;
    }

    public Void caseErrorBinding(ErrorBinding errorBinding) {
        this.builder.append("*** error binding ***");
        this.newLine();
        this.builder.append(MISSING_NAME_MESSAGE_PREFIX + errorBinding.getMissingName());
        this.newLine();
        this.builder.append(MISSING_COLON_MESSAGE_PREFIX + errorBinding.getMissingColon());
        this.newLine();
        this.builder.append(MISSING_TYPE_MESSAGE_PREFIX + errorBinding.getMissingType());
        this.newLine();
        this.builder.append("missing affectation symbol: " + errorBinding.getMissingAffectationSymbole());
        this.newLine();
        this.builder.append("missing affectation symbol position: " + errorBinding.getMissingAffectationSymbolePosition());
        this.newLine();
        return null;
    }

    public Void caseBlockComment(BlockComment blockComment) {
        this.builder.append("[blockComment]");
        return null;
    }

    public Void caseComment(Comment comment) {
        this.builder.append("[comment ");
        this.doSwitch((EObject)comment.getBody());
        this.builder.append(" /]");
        return null;
    }

    public Void caseErrorComment(ErrorComment errorComment) {
        this.builder.append("*** error comment ***");
        this.newLine();
        this.builder.append(MISSING_END_HEADER_MESSAGE_PREFIX + errorComment.getMissingEndHeader());
        this.newLine();
        return null;
    }

    public Void caseCommentBody(CommentBody commentBody) {
        this.builder.append(commentBody.getValue().replaceAll("\r\n", "\n"));
        return null;
    }

    public Void caseExpression(Expression expression) {
        this.builder.append(this.querySerializer.serialize(expression.getAst().getAst()));
        return null;
    }

    public Void caseFileStatement(FileStatement file) {
        this.builder.append("[file url ");
        this.doSwitch((EObject)file.getUrl());
        this.builder.append(" mode ");
        this.builder.append(file.getMode().getName());
        if (file.getCharset() != null) {
            this.builder.append(" charset ");
            this.doSwitch((EObject)file.getCharset());
        }
        this.doSwitch((EObject)file.getBody());
        this.newLine();
        this.builder.append("[/file]");
        return null;
    }

    public Void caseErrorFileStatement(ErrorFileStatement errorFileStatement) {
        this.builder.append("*** error file statement ***");
        this.newLine();
        this.builder.append("missing open mode: " + errorFileStatement.getMissingOpenMode());
        this.newLine();
        this.builder.append(MISSING_OPEN_PARENTHESIS_MESSAGE_PREFIX + errorFileStatement.getMissingOpenParenthesis());
        this.newLine();
        this.builder.append("missing comma: " + errorFileStatement.getMissingComma());
        this.newLine();
        this.builder.append(MISSING_CLOSE_PARENTHESIS_MESSAGE_PREFIX + errorFileStatement.getMissingCloseParenthesis());
        this.newLine();
        this.builder.append(MISSING_END_HEADER_MESSAGE_PREFIX + errorFileStatement.getMissingEndHeader());
        this.newLine();
        this.builder.append(MISSING_END_MESSAGE_PREFIX + errorFileStatement.getMissingEnd());
        this.newLine();
        return null;
    }

    public Void caseForStatement(ForStatement forStatement) {
        this.builder.append("[for ");
        if (forStatement.getBinding() != null) {
            this.doSwitch((EObject)forStatement.getBinding());
        } else {
            this.builder.append("null binding");
        }
        if (forStatement.getSeparator() != null) {
            this.builder.append(" separator ");
            this.doSwitch((EObject)forStatement.getSeparator());
        }
        this.doSwitch((EObject)forStatement.getBody());
        this.newLine();
        this.builder.append("[/for]");
        return null;
    }

    public Void caseErrorForStatement(ErrorForStatement errorForStatement) {
        this.builder.append("*** error for statement ***");
        this.newLine();
        this.builder.append(MISSING_OPEN_PARENTHESIS_MESSAGE_PREFIX + errorForStatement.getMissingOpenParenthesis());
        this.newLine();
        this.builder.append("missing binding: " + errorForStatement.getMissingBinding());
        this.newLine();
        this.builder.append(MISSING_CLOSE_PARENTHESIS_MESSAGE_PREFIX + errorForStatement.getMissingCloseParenthesis());
        this.newLine();
        this.builder.append(MISSING_SEPARATOR_CLOSE_PARENTHESIS_MESSAGE_PREFIX + errorForStatement.getMissingSeparatorCloseParenthesis());
        this.newLine();
        this.builder.append(MISSING_END_HEADER_MESSAGE_PREFIX + errorForStatement.getMissingEndHeader());
        this.newLine();
        this.builder.append(MISSING_END_MESSAGE_PREFIX + errorForStatement.getMissingEnd());
        this.newLine();
        return null;
    }

    public Void caseIfStatement(IfStatement ifStatement) {
        this.builder.append("[if ");
        this.doSwitch((EObject)ifStatement.getCondition());
        this.doSwitch((EObject)ifStatement.getThen());
        if (ifStatement.getElse() != null) {
            this.newLine();
            this.builder.append("[else]");
            this.doSwitch((EObject)ifStatement.getElse());
        }
        this.newLine();
        this.builder.append("[/if]");
        return null;
    }

    public Void caseErrorIfStatement(ErrorIfStatement errorIfStatement) {
        this.builder.append("*** error if statement ***");
        this.newLine();
        this.builder.append(MISSING_OPEN_PARENTHESIS_MESSAGE_PREFIX + errorIfStatement.getMissingOpenParenthesis());
        this.newLine();
        this.builder.append(MISSING_CLOSE_PARENTHESIS_MESSAGE_PREFIX + errorIfStatement.getMissingCloseParenthesis());
        this.newLine();
        this.builder.append(MISSING_END_HEADER_MESSAGE_PREFIX + errorIfStatement.getMissingEndHeader());
        this.newLine();
        this.builder.append(MISSING_END_MESSAGE_PREFIX + errorIfStatement.getMissingEnd());
        this.newLine();
        return null;
    }

    public Void caseLetStatement(LetStatement let) {
        this.builder.append("[let ");
        for (Variable variable : let.getVariables()) {
            this.newLine();
            this.doSwitch((EObject)variable);
        }
        this.doSwitch((EObject)let.getBody());
        this.newLine();
        this.builder.append("[/let]");
        return null;
    }

    public Void caseErrorLetStatement(ErrorLetStatement errorLetStatement) {
        this.builder.append("*** error let statement ***");
        this.newLine();
        this.builder.append("missing bindings: " + errorLetStatement.getMissingBindings());
        this.newLine();
        this.builder.append(MISSING_END_HEADER_MESSAGE_PREFIX + errorLetStatement.getMissingEndHeader());
        this.newLine();
        this.builder.append(MISSING_END_MESSAGE_PREFIX + errorLetStatement.getMissingEnd());
        this.newLine();
        return null;
    }

    public Void caseQuery(Query query) {
        if (query.getDocumentation() != null) {
            this.doSwitch((EObject)query.getDocumentation());
        }
        this.builder.append(query.getVisibility().getName());
        this.builder.append(" query " + query.getName() + "(");
        StringBuilder previousBuilder = this.builder;
        if (!query.getParameters().isEmpty()) {
            this.builder = new StringBuilder();
            for (Variable variable : query.getParameters()) {
                this.doSwitch((EObject)variable);
                this.builder.append(", ");
            }
            previousBuilder.append(this.builder.substring(0, this.builder.length() - 2));
            this.builder = previousBuilder;
        }
        this.builder.append(") ");
        this.builder.append(") : ");
        if (query.getType() != null) {
            this.builder.append(this.querySerializer.serialize(query.getType().getAst()));
        } else {
            this.builder.append(NULL_STRING);
        }
        this.builder.append(' ');
        this.doSwitch((EObject)query.getBody());
        this.newLine();
        this.builder.append("/]");
        return null;
    }

    public Void caseErrorQuery(ErrorQuery errorQuery) {
        this.builder.append("*** error query ***");
        this.newLine();
        this.builder.append("missing visibility: " + errorQuery.getMissingVisibility());
        this.newLine();
        this.builder.append(MISSING_NAME_MESSAGE_PREFIX + errorQuery.getMissingName());
        this.newLine();
        this.builder.append(MISSING_OPEN_PARENTHESIS_MESSAGE_PREFIX + errorQuery.getMissingOpenParenthesis());
        this.newLine();
        this.builder.append("missing parameters: " + errorQuery.getMissingParameters());
        this.newLine();
        this.builder.append(MISSING_CLOSE_PARENTHESIS_MESSAGE_PREFIX + errorQuery.getMissingCloseParenthesis());
        this.newLine();
        this.builder.append(MISSING_COLON_MESSAGE_PREFIX + errorQuery.getMissingColon());
        this.newLine();
        this.builder.append(MISSING_TYPE_MESSAGE_PREFIX + errorQuery.getMissingType());
        this.newLine();
        this.builder.append("missing equal: " + errorQuery.getMissingEqual());
        this.newLine();
        this.builder.append(MISSING_END_MESSAGE_PREFIX + errorQuery.getMissingEnd());
        this.newLine();
        return null;
    }

    public Void caseTextStatement(TextStatement text) {
        this.builder.append(text.getValue());
        if (text.isNewLineNeeded()) {
            this.builder.append(" (newLineNeeded)");
        }
        return null;
    }

    public Void caseNewLineStatement(NewLineStatement newLineStatement) {
        this.builder.append("NEW_LINE ");
        if (newLineStatement.isIndentationNeeded()) {
            this.builder.append("(indentationNeeded) ");
        }
        return null;
    }

    public Void caseExpressionStatement(ExpressionStatement expressionStatement) {
        this.builder.append('[');
        this.doSwitch((EObject)expressionStatement.getExpression());
        this.builder.append("/]");
        if (expressionStatement.isNewLineNeeded()) {
            this.builder.append(" (newLineNeeded");
        }
        return null;
    }

    public Void caseErrorExpressionStatement(ErrorExpressionStatement errorExpressionStatement) {
        this.builder.append("*** error expression statement ***");
        this.newLine();
        this.builder.append(MISSING_END_HEADER_MESSAGE_PREFIX + errorExpressionStatement.getMissingEndHeader());
        this.newLine();
        return null;
    }

    public Void caseVariable(Variable variable) {
        if (variable.eClass() == AcceleoPackage.eINSTANCE.getVariable()) {
            this.builder.append(variable.getName());
            this.builder.append(" : ");
            if (variable.getType() != null) {
                this.builder.append(this.querySerializer.serialize(variable.getType().getAst()));
            } else {
                this.builder.append(NULL_STRING);
            }
        }
        return null;
    }

    public Void caseErrorVariable(ErrorVariable errorVariable) {
        this.builder.append("*** error variable ***");
        this.newLine();
        this.builder.append(MISSING_NAME_MESSAGE_PREFIX + errorVariable.getMissingName());
        this.newLine();
        this.builder.append(MISSING_COLON_MESSAGE_PREFIX + errorVariable.getMissingColon());
        this.newLine();
        this.builder.append(MISSING_TYPE_MESSAGE_PREFIX + errorVariable.getMissingType());
        this.newLine();
        return null;
    }

    public Void caseProtectedArea(ProtectedArea protectedArea) {
        this.builder.append("[protected ");
        this.doSwitch((EObject)protectedArea.getId());
        this.doSwitch((EObject)protectedArea.getBody());
        if (protectedArea.getStartTagPrefix() != null) {
            this.builder.append(" startTagPrefix ");
            this.doSwitch((EObject)protectedArea.getStartTagPrefix());
        }
        if (protectedArea.getEndTagPrefix() != null) {
            this.builder.append(" endTagPrefix ");
            this.doSwitch((EObject)protectedArea.getEndTagPrefix());
        }
        this.newLine();
        this.builder.append("[/protected]");
        return null;
    }

    public Void caseErrorProtectedArea(ErrorProtectedArea errorProtectedArea) {
        this.builder.append("*** error protected area ***");
        this.newLine();
        this.builder.append(MISSING_OPEN_PARENTHESIS_MESSAGE_PREFIX + errorProtectedArea.getMissingOpenParenthesis());
        this.newLine();
        this.builder.append(MISSING_CLOSE_PARENTHESIS_MESSAGE_PREFIX + errorProtectedArea.getMissingCloseParenthesis());
        this.newLine();
        this.builder.append(MISSING_START_TAG_PREFIX_CLOSE_PARENTHESIS_MESSAGE_PREFIX + errorProtectedArea.getMissingStartTagPrefixCloseParenthesis());
        this.newLine();
        this.builder.append(MISSING_END_TAG_PREFIX_CLOSE_PARENTHESIS_MESSAGE_PREFIX + errorProtectedArea.getMissingEndTagPrefixCloseParenthesis());
        this.newLine();
        this.builder.append(MISSING_END_HEADER_MESSAGE_PREFIX + errorProtectedArea.getMissingEndHeader());
        this.newLine();
        this.builder.append(MISSING_END_MESSAGE_PREFIX + errorProtectedArea.getMissingEnd());
        this.newLine();
        return null;
    }

    public Void caseModuleDocumentation(ModuleDocumentation modueDocumentation) {
        this.doSwitch((EObject)modueDocumentation.getBody());
        this.newLine();
        this.builder.append("author: " + modueDocumentation.getAuthor());
        this.newLine();
        this.builder.append("version: " + modueDocumentation.getVersion());
        this.newLine();
        this.builder.append("since: " + modueDocumentation.getSince());
        this.newLine();
        return null;
    }

    public Void caseModuleElementDocumentation(ModuleElementDocumentation moduleElementDocumentation) {
        this.doSwitch((EObject)moduleElementDocumentation.getBody());
        for (ParameterDocumentation documentation : moduleElementDocumentation.getParameterDocumentation()) {
            this.newLine();
            this.doSwitch((EObject)documentation);
        }
        return null;
    }

    public Void caseParameterDocumentation(ParameterDocumentation parameterDocumentation) {
        this.doSwitch((EObject)parameterDocumentation.getBody());
        return null;
    }

    public Void caseAcceleoASTNode(AcceleoASTNode node) {
        this.builder.append(" (" + this.ast.getStartPosition((ASTNode)node));
        this.builder.append("..");
        this.builder.append(this.ast.getEndPosition((ASTNode)node) + ")");
        return null;
    }

    private final class QueryAstSerializer
    extends AstSwitch<Void> {
        private StringBuilder builder;

        private QueryAstSerializer() {
        }

        public String serialize(org.eclipse.acceleo.query.ast.Expression expression) {
            this.builder = new StringBuilder();
            this.doSwitch((EObject)expression);
            return this.builder.toString();
        }

        public Void caseBinding(org.eclipse.acceleo.query.ast.Binding binding) {
            this.builder.append(binding.getName());
            if (binding.getType() != null) {
                this.builder.append(' ').append(':').append(' ');
                this.builder.append(this.doSwitch((EObject)binding.getType()));
            }
            this.builder.append(' ').append('=').append(' ');
            this.builder.append(this.doSwitch((EObject)binding.getValue()));
            return null;
        }

        public Void caseBooleanLiteral(BooleanLiteral booleanLiteral) {
            this.builder.append(booleanLiteral.isValue());
            return null;
        }

        public Void caseCall(Call call) {
            if (call.getType() == CallType.COLLECTIONCALL) {
                this.builder.append("->");
            } else {
                this.builder.append('.');
            }
            if (call.isSuperCall()) {
                this.builder.append("super:");
            }
            this.builder.append(call.getServiceName());
            this.builder.append('(');
            StringBuilder previousBuilder = this.builder;
            this.builder = new StringBuilder();
            for (org.eclipse.acceleo.query.ast.Expression argument : call.getArguments()) {
                this.doSwitch((EObject)argument);
                this.builder.append(',').append(' ');
            }
            if (this.builder.length() > 0) {
                previousBuilder.append(this.builder.substring(0, this.builder.length() - 2));
            }
            this.builder = previousBuilder;
            this.builder.append(')');
            return null;
        }

        public Void caseCollectionTypeLiteral(CollectionTypeLiteral collectionTypeLiteral) {
            if (collectionTypeLiteral.getValue() == List.class) {
                this.builder.append("Sequence(");
            } else if (collectionTypeLiteral.getValue() == Set.class) {
                this.builder.append("OrderedSet(");
            } else {
                this.builder.append("***invalid type of collection ***(");
            }
            this.doSwitch((EObject)collectionTypeLiteral.getElementType());
            this.builder.append(")");
            return null;
        }

        public Void caseConditional(Conditional conditional) {
            this.builder.append("if (");
            this.doSwitch((EObject)conditional.getPredicate());
            this.builder.append(") then ");
            this.doSwitch((EObject)conditional.getTrueBranch());
            this.builder.append(" else ");
            this.doSwitch((EObject)conditional.getFalseBranch());
            this.builder.append(" endif ");
            return null;
        }

        public Void caseEnumLiteral(EnumLiteral enumLiteral) {
            this.builder.append(enumLiteral.getEPackageName());
            this.builder.append("::");
            this.builder.append(enumLiteral.getEEnumName());
            this.builder.append("::");
            this.builder.append(enumLiteral.getEEnumLiteralName());
            return null;
        }

        public Void caseError(Error error) {
            this.builder.append("***ERROR***");
            return null;
        }

        public Void caseIntegerLiteral(IntegerLiteral object) {
            this.builder.append(object.getValue());
            return null;
        }

        public Void caseLambda(Lambda lambda) {
            this.doSwitch((EObject)lambda.getParameters().get(0));
            this.builder.append(" | ");
            this.doSwitch((EObject)lambda.getExpression());
            return null;
        }

        public Void caseLet(Let let) {
            this.builder.append("let ");
            StringBuilder previousBuilder = this.builder;
            this.builder = new StringBuilder();
            for (org.eclipse.acceleo.query.ast.Binding binding : let.getBindings()) {
                this.doSwitch((EObject)binding);
                this.builder.append(',').append(' ');
            }
            previousBuilder.append(this.builder.substring(0, this.builder.length() - 2));
            this.builder.append(" in ");
            this.doSwitch((EObject)let.getBody());
            return (Void)super.caseLet(let);
        }

        public Void caseNullLiteral(NullLiteral nullLiteral) {
            this.builder.append(ModuleAstSerializer.NULL_STRING);
            return null;
        }

        public Void caseSequenceInExtensionLiteral(SequenceInExtensionLiteral sequenceInExtensionLiteral) {
            this.builder.append("Sequence{");
            if (!sequenceInExtensionLiteral.getValues().isEmpty()) {
                for (org.eclipse.acceleo.query.ast.Expression value : sequenceInExtensionLiteral.getValues()) {
                    this.doSwitch((EObject)value);
                    this.builder.append(',').append(' ');
                }
            }
            this.builder.append('}');
            return null;
        }

        public Void caseRealLiteral(RealLiteral realLiteral) {
            this.builder.append(realLiteral.getValue());
            return null;
        }

        public Void caseSetInExtensionLiteral(SetInExtensionLiteral setInExtensionLiteral) {
            this.builder.append("OrderedSet{");
            if (!setInExtensionLiteral.getValues().isEmpty()) {
                StringBuilder previousBuilder = this.builder;
                this.builder = new StringBuilder();
                for (org.eclipse.acceleo.query.ast.Expression value : setInExtensionLiteral.getValues()) {
                    this.doSwitch((EObject)value);
                    this.builder.append(',').append(' ');
                }
                previousBuilder.append(this.builder.substring(0, this.builder.length() - 2));
            }
            this.builder.append('}');
            return null;
        }

        public Void caseStringLiteral(StringLiteral stringLiteral) {
            this.builder.append('\'');
            this.builder.append(stringLiteral.getValue());
            this.builder.append('\'');
            return null;
        }

        public Void caseTypeSetLiteral(TypeSetLiteral typeSetLiteral) {
            this.builder.append('{');
            if (!typeSetLiteral.getTypes().isEmpty()) {
                StringBuilder previousBuilder = this.builder;
                this.builder = new StringBuilder();
                try {
                    for (TypeLiteral type : typeSetLiteral.getTypes()) {
                        this.doSwitch((EObject)type);
                        this.builder.append(" | ");
                    }
                    previousBuilder.append(this.builder.substring(0, this.builder.length() - 3));
                }
                finally {
                    this.builder = previousBuilder;
                }
            }
            this.builder.append('}');
            return null;
        }

        public Void caseClassTypeLiteral(ClassTypeLiteral object) {
            if (object.getValue() != null) {
                this.builder.append(object.getValue().getName());
            }
            return null;
        }

        public Void caseEClassifierTypeLiteral(EClassifierTypeLiteral object) {
            this.builder.append(object.getEClassifierName());
            return null;
        }

        public Void caseVariableDeclaration(VariableDeclaration variableDeclaration) {
            this.builder.append(variableDeclaration.getName());
            if (variableDeclaration.getType() != null) {
                this.builder.append(' ').append(':').append(' ');
                this.doSwitch((EObject)variableDeclaration.getType());
            }
            this.builder.append(' ').append('=').append(' ');
            this.doSwitch((EObject)variableDeclaration.getExpression());
            return null;
        }

        public Void caseVarRef(VarRef varRef) {
            this.builder.append(varRef.getVariableName());
            return null;
        }
    }
}

