/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.parser;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.acceleo.query.ast.And;
import org.eclipse.acceleo.query.ast.AstPackage;
import org.eclipse.acceleo.query.ast.Binding;
import org.eclipse.acceleo.query.ast.BooleanLiteral;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.ast.ClassTypeLiteral;
import org.eclipse.acceleo.query.ast.CollectionTypeLiteral;
import org.eclipse.acceleo.query.ast.Conditional;
import org.eclipse.acceleo.query.ast.EClassifierTypeLiteral;
import org.eclipse.acceleo.query.ast.EnumLiteral;
import org.eclipse.acceleo.query.ast.ErrorBinding;
import org.eclipse.acceleo.query.ast.ErrorCall;
import org.eclipse.acceleo.query.ast.ErrorConditional;
import org.eclipse.acceleo.query.ast.ErrorEClassifierTypeLiteral;
import org.eclipse.acceleo.query.ast.ErrorEnumLiteral;
import org.eclipse.acceleo.query.ast.ErrorExpression;
import org.eclipse.acceleo.query.ast.ErrorStringLiteral;
import org.eclipse.acceleo.query.ast.ErrorTypeLiteral;
import org.eclipse.acceleo.query.ast.ErrorVariableDeclaration;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.ast.Implies;
import org.eclipse.acceleo.query.ast.IntegerLiteral;
import org.eclipse.acceleo.query.ast.Lambda;
import org.eclipse.acceleo.query.ast.Let;
import org.eclipse.acceleo.query.ast.NullLiteral;
import org.eclipse.acceleo.query.ast.Or;
import org.eclipse.acceleo.query.ast.RealLiteral;
import org.eclipse.acceleo.query.ast.SequenceInExtensionLiteral;
import org.eclipse.acceleo.query.ast.SetInExtensionLiteral;
import org.eclipse.acceleo.query.ast.StringLiteral;
import org.eclipse.acceleo.query.ast.TypeLiteral;
import org.eclipse.acceleo.query.ast.TypeSetLiteral;
import org.eclipse.acceleo.query.ast.VarRef;
import org.eclipse.acceleo.query.ast.VariableDeclaration;
import org.eclipse.acceleo.query.parser.QueryLexer;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class AstBuilder {
    private static final Set<String> KEYWORDS = AstBuilder.initKeywords();
    private static final String ESCAPE_X = "\\x";
    private static final String ESCAPE_U = "\\u";
    private static final String INVALID_ESCAPE_SEQUENCE = "Invalid escape sequence : ";

    private static Set<String> initKeywords() {
        HashSet<String> res = new HashSet<String>();
        int i = 0;
        while (i <= QueryLexer.VOCABULARY.getMaxTokenType()) {
            String literalName = QueryLexer.VOCABULARY.getLiteralName(i);
            if (literalName != null) {
                res.add(literalName.substring(1, literalName.length() - 1));
            }
            ++i;
        }
        return res;
    }

    public static boolean isKeyword(String identifier) {
        return KEYWORDS.contains(identifier);
    }

    public static String protectWithUnderscore(String identifier) {
        Object res = AstBuilder.isKeyword(identifier) ? "_" + identifier : identifier;
        return res;
    }

    public EnumLiteral enumLiteral(String ePackageName, String eEnumName, String eEnumLiteralName) {
        EnumLiteral result = (EnumLiteral)EcoreUtil.create((EClass)AstPackage.Literals.ENUM_LITERAL);
        result.setEPackageName(AstBuilder.stripUnderscore(ePackageName));
        result.setEEnumName(AstBuilder.stripUnderscore(eEnumName));
        result.setEEnumLiteralName(AstBuilder.stripUnderscore(eEnumLiteralName));
        return result;
    }

    public IntegerLiteral integerLiteral(int i) {
        IntegerLiteral literal = (IntegerLiteral)EcoreUtil.create((EClass)AstPackage.Literals.INTEGER_LITERAL);
        literal.setValue(i);
        return literal;
    }

    public RealLiteral realLiteral(double i) {
        RealLiteral literal = (RealLiteral)EcoreUtil.create((EClass)AstPackage.Literals.REAL_LITERAL);
        literal.setValue(i);
        return literal;
    }

    public StringLiteral stringLiteral(String str) {
        StringLiteral literal = (StringLiteral)EcoreUtil.create((EClass)AstPackage.Literals.STRING_LITERAL);
        literal.setValue(AstBuilder.stripSlashes(str));
        return literal;
    }

    public ErrorStringLiteral errorStringLiteral(String str) {
        ErrorStringLiteral errorStringLiteral = (ErrorStringLiteral)EcoreUtil.create((EClass)AstPackage.Literals.ERROR_STRING_LITERAL);
        errorStringLiteral.setValue(str);
        return errorStringLiteral;
    }

    public static String stripUnderscore(String identifier) {
        String res = identifier != null && identifier.startsWith("_") ? identifier.substring(1) : identifier;
        return res;
    }

    public static String stripSlashes(String text) {
        int end = text.length();
        StringBuilder res = new StringBuilder(end);
        int i = 0;
        while (i < end) {
            block14: {
                char c;
                block15: {
                    block13: {
                        c = text.charAt(i);
                        if (c == '\\') break block13;
                        res.append(c);
                        break block14;
                    }
                    if (i + 1 >= end) break block15;
                    char c1 = text.charAt(++i);
                    switch (c1) {
                        case 'b': {
                            res.append('\b');
                            break block14;
                        }
                        case 't': {
                            res.append('\t');
                            break block14;
                        }
                        case 'n': {
                            res.append('\n');
                            break block14;
                        }
                        case 'f': {
                            res.append('\f');
                            break block14;
                        }
                        case 'r': {
                            res.append('\r');
                            break block14;
                        }
                        case '\\': {
                            res.append('\\');
                            break block14;
                        }
                        case '\"': {
                            res.append('\"');
                            break block14;
                        }
                        case '\'': {
                            res.append('\'');
                            break block14;
                        }
                        case 'x': {
                            res.append(AstBuilder.stripXChar(text, end, i));
                            i += 2;
                            break block14;
                        }
                        case 'u': {
                            res.append(AstBuilder.stripUChar(text, end, i));
                            i += 4;
                            break block14;
                        }
                        default: {
                            throw new IllegalArgumentException(INVALID_ESCAPE_SEQUENCE + c + c1);
                        }
                    }
                }
                throw new IllegalArgumentException(INVALID_ESCAPE_SEQUENCE + c);
            }
            ++i;
        }
        return res.toString();
    }

    private static char[] stripXChar(String text, int end, int i) {
        if (i + 2 < end) {
            return AstBuilder.charFromHexaCode(text.charAt(i + 1), text.charAt(i + 2));
        }
        if (i + 1 < end) {
            throw new IllegalArgumentException("Invalid escape sequence : \\x" + text.charAt(i + 1));
        }
        throw new IllegalArgumentException("Invalid escape sequence : \\x");
    }

    private static char[] stripUChar(String text, int end, int i) {
        if (i + 4 < end) {
            return AstBuilder.charFromHexaCode(text.charAt(i + 1), text.charAt(i + 2), text.charAt(i + 3), text.charAt(i + 4));
        }
        if (i + 3 < end) {
            throw new IllegalArgumentException("Invalid escape sequence : \\u" + text.charAt(i + 1) + text.charAt(i + 2) + text.charAt(i + 3));
        }
        if (i + 2 < end) {
            throw new IllegalArgumentException("Invalid escape sequence : \\u" + text.charAt(i + 1) + text.charAt(i + 2));
        }
        if (i + 1 < end) {
            throw new IllegalArgumentException("Invalid escape sequence : \\u" + text.charAt(i + 1));
        }
        throw new IllegalArgumentException("Invalid escape sequence : \\u");
    }

    private static char[] charFromHexaCode(char c0, char c1) {
        try {
            int codePoint = Integer.parseInt(String.valueOf(new char[]{c0, c1}), 16);
            if (Character.isValidCodePoint(codePoint)) {
                return Character.toChars(codePoint);
            }
            throw new IllegalArgumentException("Invalid escape sequence : \\x" + c0 + c1);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid escape sequence : \\x" + c0 + c1);
        }
    }

    private static char[] charFromHexaCode(char c0, char c1, char c2, char c3) {
        try {
            int codePoint = Integer.parseInt(String.valueOf(new char[]{c0, c1, c2, c3}), 16);
            if (Character.isValidCodePoint(codePoint)) {
                return Character.toChars(codePoint);
            }
            throw new IllegalArgumentException("Invalid escape sequence : \\u" + c0 + c1 + c2 + c3);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid escape sequence : \\u" + c0 + c1 + c2 + c3);
        }
    }

    public BooleanLiteral booleanLiteral(boolean bool) {
        BooleanLiteral literal = (BooleanLiteral)EcoreUtil.create((EClass)AstPackage.Literals.BOOLEAN_LITERAL);
        literal.setValue(bool);
        return literal;
    }

    public CollectionTypeLiteral collectionTypeLiteral(Class<?> type, TypeLiteral elementType) {
        if (type != List.class && type != Set.class) {
            throw new IllegalArgumentException("collection type must be either list or set.");
        }
        CollectionTypeLiteral literal = (CollectionTypeLiteral)EcoreUtil.create((EClass)AstPackage.Literals.COLLECTION_TYPE_LITERAL);
        literal.setValue(type);
        literal.setElementType(elementType);
        return literal;
    }

    public EClassifierTypeLiteral eClassifierTypeLiteral(String ePackageName, String eClassifierName) {
        EClassifierTypeLiteral result = (EClassifierTypeLiteral)EcoreUtil.create((EClass)AstPackage.Literals.ECLASSIFIER_TYPE_LITERAL);
        result.setEPackageName(AstBuilder.stripUnderscore(ePackageName));
        result.setEClassifierName(AstBuilder.stripUnderscore(eClassifierName));
        return result;
    }

    public ClassTypeLiteral typeLiteral(Class<?> type) {
        ClassTypeLiteral result = (ClassTypeLiteral)EcoreUtil.create((EClass)AstPackage.Literals.CLASS_TYPE_LITERAL);
        result.setValue(type);
        return result;
    }

    public Call callService(String serviceName, Expression ... args) {
        Call call = (Call)EcoreUtil.create((EClass)AstPackage.Literals.CALL);
        call.setServiceName(AstBuilder.stripUnderscore(serviceName));
        call.getArguments().addAll(Arrays.asList(args));
        return call;
    }

    public And callAndService(Expression ... args) {
        And and = (And)EcoreUtil.create((EClass)AstPackage.Literals.AND);
        and.setServiceName("and");
        and.getArguments().addAll(Arrays.asList(args));
        return and;
    }

    public Or callOrService(Expression ... args) {
        Or or = (Or)EcoreUtil.create((EClass)AstPackage.Literals.OR);
        or.setServiceName("or");
        or.getArguments().addAll(Arrays.asList(args));
        return or;
    }

    public Implies callImpliesService(Expression ... args) {
        Implies implies = (Implies)EcoreUtil.create((EClass)AstPackage.Literals.IMPLIES);
        implies.setServiceName("implies");
        implies.getArguments().addAll(Arrays.asList(args));
        return implies;
    }

    public VarRef varRef(String name) {
        VarRef ref = (VarRef)EcoreUtil.create((EClass)AstPackage.Literals.VAR_REF);
        ref.setVariableName(name);
        return ref;
    }

    public Lambda lambda(Expression expression, VariableDeclaration ... parameters) {
        Lambda lambda = (Lambda)EcoreUtil.create((EClass)AstPackage.Literals.LAMBDA);
        lambda.setExpression(expression);
        List<VariableDeclaration> params = Arrays.asList(parameters);
        lambda.getParameters().addAll(params);
        return lambda;
    }

    public ErrorExpression errorExpression() {
        return (ErrorExpression)EcoreUtil.create((EClass)AstPackage.Literals.ERROR_EXPRESSION);
    }

    public ErrorTypeLiteral errorTypeLiteral() {
        ErrorTypeLiteral result = (ErrorTypeLiteral)EcoreUtil.create((EClass)AstPackage.Literals.ERROR_TYPE_LITERAL);
        return result;
    }

    public ErrorEClassifierTypeLiteral errorEClassifierTypeLiteral(boolean missingColon, String ePackageName) {
        ErrorEClassifierTypeLiteral result = (ErrorEClassifierTypeLiteral)EcoreUtil.create((EClass)AstPackage.Literals.ERROR_ECLASSIFIER_TYPE_LITERAL);
        result.setMissingColon(missingColon);
        result.setEPackageName(AstBuilder.stripUnderscore(ePackageName));
        return result;
    }

    public ErrorEnumLiteral errorEnumLiteral(boolean missingColon, String ePackageName, String eEnumName) {
        ErrorEnumLiteral result = (ErrorEnumLiteral)EcoreUtil.create((EClass)AstPackage.Literals.ERROR_ENUM_LITERAL);
        result.setMissingColon(missingColon);
        result.setEPackageName(AstBuilder.stripUnderscore(ePackageName));
        result.setEEnumName(AstBuilder.stripUnderscore(eEnumName));
        return result;
    }

    public ErrorCall errorCall(String serviceName, boolean isMissingEndParenthesis, Expression ... args) {
        ErrorCall result = (ErrorCall)EcoreUtil.create((EClass)AstPackage.Literals.ERROR_CALL);
        result.setServiceName(AstBuilder.stripUnderscore(serviceName));
        result.setMissingEndParenthesis(isMissingEndParenthesis);
        result.getArguments().addAll(Arrays.asList(args));
        return result;
    }

    public VariableDeclaration variableDeclaration(String name, Expression expression) {
        VariableDeclaration result = (VariableDeclaration)EcoreUtil.create((EClass)AstPackage.Literals.VARIABLE_DECLARATION);
        result.setName(name);
        result.setExpression(expression);
        return result;
    }

    public VariableDeclaration variableDeclaration(String name, TypeLiteral type, Expression expression) {
        VariableDeclaration result = this.variableDeclaration(name, expression);
        result.setType(type);
        return result;
    }

    public NullLiteral nullLiteral() {
        return (NullLiteral)EcoreUtil.create((EClass)AstPackage.Literals.NULL_LITERAL);
    }

    public SetInExtensionLiteral setInExtension(List<Expression> expressions) {
        SetInExtensionLiteral result = (SetInExtensionLiteral)EcoreUtil.create((EClass)AstPackage.Literals.SET_IN_EXTENSION_LITERAL);
        result.getValues().addAll(expressions);
        return result;
    }

    public SequenceInExtensionLiteral sequenceInExtension(List<Expression> expressions) {
        SequenceInExtensionLiteral result = (SequenceInExtensionLiteral)EcoreUtil.create((EClass)AstPackage.Literals.SEQUENCE_IN_EXTENSION_LITERAL);
        result.getValues().addAll(expressions);
        return result;
    }

    public ErrorVariableDeclaration errorVariableDeclaration(String variableName, TypeLiteral type, Expression expression) {
        ErrorVariableDeclaration result = (ErrorVariableDeclaration)EcoreUtil.create((EClass)AstPackage.Literals.ERROR_VARIABLE_DECLARATION);
        result.setName(variableName);
        result.setType(type);
        result.setExpression(expression);
        return result;
    }

    public Conditional conditional(Expression predicate, Expression trueBranch, Expression falseBranch) {
        Conditional result = (Conditional)EcoreUtil.create((EClass)AstPackage.Literals.CONDITIONAL);
        result.setPredicate(predicate);
        result.setTrueBranch(trueBranch);
        result.setFalseBranch(falseBranch);
        return result;
    }

    public ErrorConditional errorConditional(Expression predicate, Expression trueBranch, Expression falseBranch) {
        ErrorConditional result = (ErrorConditional)EcoreUtil.create((EClass)AstPackage.Literals.ERROR_CONDITIONAL);
        result.setPredicate(predicate);
        result.setTrueBranch(trueBranch);
        result.setFalseBranch(falseBranch);
        return result;
    }

    public Binding binding(String varName, TypeLiteral type, Expression expression) {
        Binding binding = (Binding)EcoreUtil.create((EClass)AstPackage.Literals.BINDING);
        binding.setName(varName);
        binding.setType(type);
        binding.setValue(expression);
        return binding;
    }

    public Let let(Expression body, Binding ... bindings) {
        Let let = (Let)EcoreUtil.create((EClass)AstPackage.Literals.LET);
        let.setBody(body);
        Binding[] bindingArray = bindings;
        int n = bindings.length;
        int n2 = 0;
        while (n2 < n) {
            Binding binding = bindingArray[n2];
            let.getBindings().add((Object)binding);
            ++n2;
        }
        return let;
    }

    public TypeSetLiteral typeSetLiteral(List<TypeLiteral> types) {
        TypeSetLiteral typeSetLiteral = (TypeSetLiteral)EcoreUtil.create((EClass)AstPackage.Literals.TYPE_SET_LITERAL);
        typeSetLiteral.getTypes().addAll(types);
        return typeSetLiteral;
    }

    public ErrorBinding errorBinding(String name, TypeLiteral type) {
        ErrorBinding errorBinding = (ErrorBinding)EcoreUtil.create((EClass)AstPackage.Literals.ERROR_BINDING);
        errorBinding.setName(name);
        errorBinding.setType(type);
        return errorBinding;
    }
}

