/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.tests.anydsl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Kind implements Enumerator
{
    OTHER(0, "Other", "Other"),
    SEED(1, "Seed", "Seed"),
    OILSEED(2, "Oilseed", "Oilseed"),
    TREE(3, "Tree", "Tree"),
    ROOT(4, "Root", "Root"),
    BULB(5, "Bulb", "Bulb"),
    LEAF(6, "Leaf", "Leaf"),
    STEM(7, "Stem", "Stem"),
    FLOWER(8, "Flower", "Flower"),
    INFLORESCENCE(9, "Inflorescence", "Inflorescence"),
    SPICE(10, "Spice", "Spice");

    public static final int OTHER_VALUE = 0;
    public static final int SEED_VALUE = 1;
    public static final int OILSEED_VALUE = 2;
    public static final int TREE_VALUE = 3;
    public static final int ROOT_VALUE = 4;
    public static final int BULB_VALUE = 5;
    public static final int LEAF_VALUE = 6;
    public static final int STEM_VALUE = 7;
    public static final int FLOWER_VALUE = 8;
    public static final int INFLORESCENCE_VALUE = 9;
    public static final int SPICE_VALUE = 10;
    private static final Kind[] VALUES_ARRAY;
    public static final List<Kind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Kind[]{OTHER, SEED, OILSEED, TREE, ROOT, BULB, LEAF, STEM, FLOWER, INFLORESCENCE, SPICE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Kind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Kind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Kind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Kind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Kind get(int value) {
        switch (value) {
            case 0: {
                return OTHER;
            }
            case 1: {
                return SEED;
            }
            case 2: {
                return OILSEED;
            }
            case 3: {
                return TREE;
            }
            case 4: {
                return ROOT;
            }
            case 5: {
                return BULB;
            }
            case 6: {
                return LEAF;
            }
            case 7: {
                return STEM;
            }
            case 8: {
                return FLOWER;
            }
            case 9: {
                return INFLORESCENCE;
            }
            case 10: {
                return SPICE;
            }
        }
        return null;
    }

    private Kind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

