/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.tests.anydsl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Continent implements Enumerator
{
    EUROPE(0, "Europe", "Europe"),
    ASIA(1, "Asia", "Asia"),
    AFRICA(2, "Africa", "Africa"),
    AMERICA(3, "America", "America"),
    AUSTRALIA(4, "Australia", "Australia"),
    ANTARCTICA(5, "Antarctica", "Antarctica");

    public static final int EUROPE_VALUE = 0;
    public static final int ASIA_VALUE = 1;
    public static final int AFRICA_VALUE = 2;
    public static final int AMERICA_VALUE = 3;
    public static final int AUSTRALIA_VALUE = 4;
    public static final int ANTARCTICA_VALUE = 5;
    private static final Continent[] VALUES_ARRAY;
    public static final List<Continent> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Continent[]{EUROPE, ASIA, AFRICA, AMERICA, AUSTRALIA, ANTARCTICA};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Continent get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Continent result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Continent getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Continent result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Continent get(int value) {
        switch (value) {
            case 0: {
                return EUROPE;
            }
            case 1: {
                return ASIA;
            }
            case 2: {
                return AFRICA;
            }
            case 3: {
                return AMERICA;
            }
            case 4: {
                return AUSTRALIA;
            }
            case 5: {
                return ANTARCTICA;
            }
        }
        return null;
    }

    private Continent(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

